/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: primary_thread.c,v 1.10 2007/04/19 07:44:46 honda Exp $
 */

#include <vwindows.h>
#include <hal_msg.h>
#include <hw_timer.h>

#include <objbase.h>
#include <shellapi.h>
#include <resource.h>

#include "jsp_kernel.h"
#include "task.h"
#include <eventlog.h>
#include <cpu_rename.h>

    /* λ˴ԤؿΥ塼 */
struct tagDestructionProcedureQueue
{
	struct tagDestructionProcedureQueue * Next;
	void (*DestructionProcedure)(void *);
	void * Parameter;
};

 /*
  *   ץȥ
  */
extern void kernel_start();
extern void kernel_exit();

 /*
  *   ѿ
  */
HINSTANCE ProcessInstance;
HANDLE    PrimaryThreadHandle;
HWND      PrimaryDialogHandle;
HANDLE    CurrentRunningThreadHandle;
BOOL      ShutdownPostponementRequest;

static HANDLE WorkerThreadHandle = NULL;
static struct tagDestructionProcedureQueue * DestructionProcedureQueue;


 /*
  *  ߼¹Υåɤꤵ줿Ǥ뤫ɤΥå
  */
Inline 
int isTaskThreadRunning(TCB * tcb)
{   return (tcb != 0) && (tcb->tskctxb.ThreadHandle == CurrentRunningThreadHandle);   }


 /*
  * ͥ륹
  *   kernel_startϺǸexit_and_dispatchƤ֤Τǡƥ˴
  *   ƿåɤ롣
  */

static DWORD WINAPI
KernelStarter(LPVOID param)
{
    TlsAlloc();
	TlsSetValue(TLS_LOGMASK, (LPVOID)1);
	TlsSetValue(TLS_THREADHANDLE, (LPVOID)CurrentRunningThreadHandle);

    kprintf(("KernelStarter begins performing kernel initialization.\n"));

    kernel_start();

    /* ץϤˤʤ */

	return 0;
}

 /*
  *  㳰ư롼 
  *     Visual C++   -> cpu_config.c ˰ưޤ
  *     mingw/cygwin -> cpu_insn.S   ˰ưޤ
  */
extern void TaskExceptionPerformer(void);

 /*
  * ǥ롼
  *   ֤ʤ֥˴ץк
  */
DWORD WINAPI
ForceShutdownHandler(LPVOID param)
{
	do {
		ShutdownPostponementRequest = FALSE;
		Sleep(5000);
	} while(ShutdownPostponementRequest == TRUE);
	ExitProcess(0);
	return 0;
}

 /*
  * ǥХåѥΥåϥɥ
  */
Inline LRESULT CALLBACK
PrimaryDialogCommandHandler(WPARAM wParam, LPARAM lParam)
{
	static BOOL lock_flag;

	switch(wParam)
	{
			/* ֥åζߤץܥ */
		case IDC_CLOCKSUPPLY:
		{
			int state;

			state = SendDlgItemMessage(PrimaryDialogHandle, IDC_CLOCKSUPPLY,BM_GETCHECK,0,0);
			switch(state)
			{
					/* å -> åߤ and ưƤ륹åɤ */
			case BST_CHECKED:
				if((lock_flag = sense_lock()) != TRUE)
					dis_int(0);
				hw_timer_terminate();
				if(CurrentRunningThreadHandle != NULL)
					SuspendThread(CurrentRunningThreadHandle);
				break;

					/* åƳ -> Ǹ˻ߤ᤿åɤκƳ and åƳ */
			case BST_UNCHECKED:
				if(CurrentRunningThreadHandle != NULL)
					ResumeThread(CurrentRunningThreadHandle);
				hw_timer_initialize();
				if(lock_flag != TRUE)
					ena_int(0);
				break;
			}
			break;
		}

	default:
		return FALSE;
	}

	return TRUE;
}

    /*
     *  TOPPERS/JSP åɥǥ ǥѥå 
     */
static void task_dispatcher(int is_taskschedule_required)
{
		/* ưƤ륹å(=+)Сߤ */
	if(CurrentRunningThreadHandle != NULL)
	{
		wait_for_thread_suspension_completion(CurrentRunningThreadHandle);

            //ưƤΤǤСߥޥ٥¸
        if(isTaskThreadRunning(runtsk))
			vget_ims(&runtsk->tskctxb.InterruptLevel);
	}

		/*  */

        //ǥѥåɬפ
    if(is_taskschedule_required != 0 && enadsp && runtsk != schedtsk)
        runtsk = schedtsk;

        //ڴ西¸ߤʤ顢Υư
	if(runtsk != 0l)
	{
		CurrentRunningThreadHandle = runtsk->tskctxb.ThreadHandle;

			/* 㳰ä */
		if (runtsk->enatex && runtsk->texptn != 0) 
		{
				/* 㳰ư롼ؤȺؤ */
			CONTEXT context;
			context.ContextFlags = CONTEXT_FULL;
			GetThreadContext(CurrentRunningThreadHandle,&context);
			*(DWORD *)(context.Esp -= 4) = context.Eip;
			context.Eip = (DWORD)TaskExceptionPerformer;
			SetThreadContext(CurrentRunningThreadHandle,&context);
		}else
			chg_ims(runtsk->tskctxb.InterruptLevel);
		
		LOG_DSP_LEAVE(runtsk);
		ResumeThread(runtsk->tskctxb.ThreadHandle);
	}else
	{
			/* ưΤʤʤ顢ߤ򤢤Ԥ */
		CurrentRunningThreadHandle = NULL;
		ena_int(0);
	}
}



	/*
	 * TOPPERS/JSP åɥǥ ͥåϥɥ
	 */
Inline LRESULT CALLBACK
HALMessageHandler(WPARAM wParam,LPARAM lParam)
{
	switch(wParam)
	{
			/*
			 *֥˴Ƥץå 
			 *  lParam : ˴оݥTCBΥɥ쥹
			 */
	case HALMSG_DESTROY:
        {
            TCB * tcb = (TCB *)lParam;

				    /* tcb == 0 ΩΤϡKernelStarterexit_and_dispatchȤΤ */
            if(tcb == 0 || isTaskThreadRunning(tcb)){
                CurrentRunningThreadHandle = NULL;

                    /* εư׵Фext_tskȡλǤǤ˿åɤΥϥɥ뤬äƤΤǾäƤϤʤ */

                if(tcb == runtsk)
                    runtsk = 0;
            }
        }

			/*
			 *֥ڤؤƤץå
			 */
	case HALMSG_DISPATCH:
        task_dispatcher(1);
        break;

		/*
		 *ֳߤȯƤץå
		 * lParam : ֹ (>0)
		 */
	case HALMSG_INTERRUPT:
        if(lParam == 0 || iniflg == FALSE || ras_int((unsigned int)lParam) == FALSE)
            break;

            /* ߼ս : Τޤ޼ */

        /*
         * ּ˼¹Ԥ٤ߤõơ߽򳫻ϤƤץå
         */
    case HALMSG_INTERRUPT_FINISH:
        {
			    /* ߼¹ԤƤ륹åɤ */
		    wait_for_thread_suspension_completion(CurrentRunningThreadHandle);

				/* ߥå and ǥѥå */
			if((CurrentRunningThreadHandle = sch_int()) != NULL)
			{
                    //ޤưƤγߥޥ٥
				if(isTaskThreadRunning(runtsk))
					vget_ims(&runtsk->tskctxb.InterruptLevel);

                ResumeThread(CurrentRunningThreadHandle);   //ߥåɵư
			}
            else {
                    // ؤ
                task_dispatcher(reqflg);
                reqflg = 0;
            }

			break;
		}

		/*
		 *ִåɤθ¤Ǥäƴؿ¹ԤƤץå
		 *  lParam : ѥ᡼Ǽ빽¤ΤؤΥݥ
		 *    ѥ᡼¤
		 *      func  : ¹Ԥؿ
		 *      param : ѥ᡼ȤϤǤ⥢("void *")
		 *
		 * ) ǥɥȤȡ˴ǥɥäƤޤ
		 */
	case HALMSG_EXECUTEPROCEDURE:
		{
			void ** work = (void **)lParam;
			((void (*)(void *))(*work))(*(work+1));
			break;
		}

		/*
		 *ֺǸκǸˤνưƤ(onExitϥɥ)ץå
		 * lParam : ؿ¹ԥåȤä ( func,paramؤΥݥ )
		 */
	case HALMSG_ADDDESTRUCTIONPROCEDURE:
		{
			struct tagDestructionProcedureQueue * scope;
			void ** work = (void **)lParam;

			scope = DestructionProcedureQueue;

			if((DestructionProcedureQueue = GlobalAlloc(GMEM_FIXED, sizeof(struct tagDestructionProcedureQueue))) != NULL)
			{
				DestructionProcedureQueue->DestructionProcedure = *(work);
				DestructionProcedureQueue->Parameter = *(work+1);
				DestructionProcedureQueue->Next = scope;
			}else
				FatalAssertion(TRUE, "GlobalAlloc could not acquire a memory block at " __FILE__);

			break;
		}

		/*
		 *֥ץߤƤץå
		 */
	case HALMSG_QUITREQUEST:
		{
			struct tagDestructionProcedureQueue * destqueue;
			void * destarea;

			dis_int(0);		// ߼դ⤳ΥåɤΤǡ̤˶ػߤʤƤ

//			WorkerThreadHandle = CreateThread(NULL, 0, ForceShutdownHandler, 0, NULL, NULL);

			hw_timer_terminate();

			if(CurrentRunningThreadHandle != NULL)
				wait_for_thread_suspension_completion(CurrentRunningThreadHandle);

			destqueue = DestructionProcedureQueue;
			while(destqueue != NULL)
			{
				(*destqueue->DestructionProcedure)(destqueue->Parameter);
				destarea = destqueue;
				destqueue = destqueue->Next;
				GlobalFree((HGLOBAL)destarea);
			}

			DestroyWindow(PrimaryDialogHandle);
			break;
		}

	default:
		return FALSE;
	}
	return TRUE;
}

/*
 * ͥ륷ߥ졼ˤȤʤ륹åɤΥåϥɥ
 */
LRESULT CALLBACK PrimaryDialogProc(HWND hDlg,UINT Msg,WPARAM wParam,LPARAM lParam)
{
	switch(Msg)
	{
		/* ȥ쥤Ǳå */
	case HALMSG_MESSAGE+1:
		if(lParam == WM_RBUTTONUP)
			kernel_exit();

		break;

		/* ͥå */
	case HALMSG_MESSAGE:
		return HALMessageHandler(wParam,lParam);

		/* ǥХåѥΥƥΥå */
	case WM_COMMAND:
		return PrimaryDialogCommandHandler(wParam,lParam);
	
		/* (åϥɥ) */
	case WM_INITDIALOG:
		{
			DWORD ThreadID;
			NOTIFYICONDATA nid;

			PrimaryDialogHandle = hDlg;	//Ū

				/* ȥ쥤˥Ͽ */
			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.uFlags = NIF_ICON|NIF_TIP|NIF_MESSAGE;
			nid.uID = ID_NOTIFYICON;
			lstrcpy(nid.szTip,"TOPPERS/JSP");
			nid.hWnd = hDlg;
			nid.uCallbackMessage = HALMSG_MESSAGE+1;
			nid.hIcon = LoadIcon(ProcessInstance,MAKEINTRESOURCE(IDI_ERTLICON));

			Shell_NotifyIcon(NIM_ADD,&nid);

				/* ̥ͥåɤǵư */
			PrimaryThreadHandle = (HANDLE)hDlg;
			CurrentRunningThreadHandle = CreateThread(NULL,0,KernelStarter,NULL,CREATE_SUSPENDED,&ThreadID);
            ResumeThread(CurrentRunningThreadHandle);

			FatalAssertion(CurrentRunningThreadHandle != NULL, "CreateThread at " __FILE__);

			break;
		}

		/* Ĥ褦ȤƤޤ */
	case WM_CLOSE:
			HALQuitRequest();
			break;

		/* ˴ޤ */
	case WM_DESTROY:
		{
				/* ȥ쥤 */
			NOTIFYICONDATA nid;

			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.uFlags = 0;
			nid.hWnd = hDlg;
			nid.uID = ID_NOTIFYICON;
			Shell_NotifyIcon(NIM_DELETE,&nid);

			PrimaryThreadHandle = NULL;
			PostQuitMessage(0);
			break;
		}

		/* ޽ */
	case WM_TIMER:
			/* 16ӥåȤ1 -> ͥΥ */
		if((wParam & 0xffff0000) == 0xffff0000)
		{
				/* 16ӥåȤϳֹ */
			return HALMessageHandler(HALMSG_INTERRUPT,(wParam & 0x0000ffff));
		}
	default:
		return FALSE;
	}
	return TRUE;
}


    /* ޥץåǤꤹ褦虜ñΥץåΤߤǽ褦ˤ */
void setAffinityMask(void)
{
    DWORD process;
    DWORD system;
    DWORD newaffinitymask;

    if(GetProcessAffinityMask(GetCurrentProcess(), &process, &system) != 0) {
        newaffinitymask = 1;
        while((process & newaffinitymask) == 0)
            newaffinitymask <<= 1;
        SetProcessAffinityMask(GetCurrentProcess(), newaffinitymask);
    }

    kprintf(("setAffinityMask : 0x%08x\n", newaffinitymask));
}

static void initialize(HANDLE hInstance)
{
	ProcessInstance            = hInstance;
	DestructionProcedureQueue  = NULL;
	PrimaryThreadHandle        = NULL;
	CurrentRunningThreadHandle = NULL;

#ifdef KERNEL_DEBUG_MODE
    AllocConsole();
#endif
        /* ץåդ */
    setAffinityMask();

}

static void finalRelease(void)
{
	int i;

    kprintf(("finalRelease()\n"));

	/* ˴Ƥʤθ */
	for(i=0;i<_kernel_tmax_tskid;i++)
	{
		if(_kernel_tcb_table[i].tskctxb.ThreadHandle != NULL)
		{
			if(TerminateThread(_kernel_tcb_table[i].tskctxb.ThreadHandle,0) != 0)
    			CloseHandle(_kernel_tcb_table[i].tskctxb.ThreadHandle);
			_kernel_tcb_table[i].tskctxb.ThreadHandle = NULL;
		}
	}

    /* COM̿򤷤Ƥ륹åɤ */
	if(WorkerThreadHandle  != NULL)
	{
		TerminateThread(WorkerThreadHandle ,0);
		CloseHandle(WorkerThreadHandle);
        WorkerThreadHandle = NULL;
	}

#ifdef KERNEL_DEBUG_MODE
    MessageBox(NULL, "The kernel will be shut down.", "TOPPERS/JSP", MB_OK);
    FreeConsole();
#endif

}


/*
 * ᥤؿ
 */
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShow)
{
	MSG msg;
	HANDLE hDlg;

    TlsAlloc();

    initialize(hInstance);

	TlsSetValue(TLS_LOGMASK, 0);
    hDlg = CreateDialog(hInstance,"PrimaryDialog",NULL,PrimaryDialogProc);
	if(hDlg != NULL)
	{		
		ShowWindow(PrimaryDialogHandle,SW_HIDE);

		OnDebug(ShowWindow(PrimaryDialogHandle,SW_SHOW));

		while(GetMessage(&msg,NULL,0,0) != 0)
		{
			if(msg.message == WM_QUIT)
				msg.message = 0;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	else
		FatalAssertion(hDlg != NULL, "CreateDialog at " __FILE__ "("  ")");

    finalRelease();

    ExitProcess(msg.wParam);
	return msg.wParam;
}

