/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hal_msg.h,v 1.14 2003/12/15 07:19:22 takayuki Exp $
 */


#ifndef __HAL_MSG_H
#define __HAL_MSG_H

#include <constants.h>
#include <t_services.h>
#include <vwindows.h>


#ifndef __HAL_MSG_MSGONLY

    /* OSư륹åɤΥϥɥ */
extern HWND PrimaryDialogHandle;

    /* åɤåʤSendMessage */
Inline void HALSendMessage(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    if(PrimaryDialogHandle != GetCurrentThread())
        SendMessage(PrimaryDialogHandle, uMsg, wParam, lParam);
    else
        PostMessage(PrimaryDialogHandle, uMsg, wParam, lParam);
}

    //ǥѥå
Inline void
HALDispatchRequest(void)
{   HALSendMessage(HALMSG_MESSAGE, HALMSG_DISPATCH, (LPARAM)0);   }

    //ƥ˴ ( : inline򻲾ȤƤϤҤȤĤʤΤǤΤޤޤˤ)
Inline void
HALDestroyRequest(void * tcb)
{	PostMessage(PrimaryDialogHandle,HALMSG_MESSAGE,HALMSG_DESTROY,(LPARAM)tcb);   }

    //߰ (intno : ֹ)
Inline void
HALInterruptRequest(unsigned int intno)
{	PostMessage(PrimaryDialogHandle,HALMSG_MESSAGE,HALMSG_INTERRUPT,(LPARAM)intno);   }

    //߽λ
Inline void
HALInterruptRequestAndWait(void)
{
	SendMessage(PrimaryDialogHandle,HALMSG_MESSAGE,HALMSG_INTERRUPT_FINISH,(LPARAM)0);
}

    //ǤդΥ롼μ¹׵
Inline BOOL
HALExecuteProcedure(void * func, void * param)
{
	void * _workofHALExecuteProcedure[2];
	
	if(func == NULL)
		return FALSE;

	_workofHALExecuteProcedure[0] = func;
	_workofHALExecuteProcedure[1] = param;
	HALSendMessage(HALMSG_MESSAGE,HALMSG_EXECUTEPROCEDURE,(LPARAM)_workofHALExecuteProcedure);

	return TRUE;
}

    //˴˴ؿϿ
Inline BOOL
HALAddDestructionProcedure(void * func, void * param)
{
	void * _workofHALAddDestructionProcedure[2];

	if(func == NULL)
		return FALSE;

	_workofHALAddDestructionProcedure[0] = func;
	_workofHALAddDestructionProcedure[1] = param;
    HALSendMessage(HALMSG_MESSAGE,HALMSG_ADDDESTRUCTIONPROCEDURE,(LPARAM)_workofHALAddDestructionProcedure);

	return TRUE;
}

    //ͥưνλ׵
Inline void
HALQuitRequest(void)
{
    HALSendMessage(HALMSG_MESSAGE,HALMSG_QUITREQUEST,0);
}

#endif

#endif

/***/