/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 *	åȥƥ¸⥸塼 ֥D70F3716GCѡ
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "v850asm.inc"

#define Set(x,y,z) Lea x, r6; Lea y, r7; st.z r7, 0[r6]

/*
 *  ٥Υåȥƥ¸ν
 *
 *  ȥåץ⥸塼ǡν˸ƤӽФ롥
 */

	.text
	.globl hardware_init_hook
hardware_init_hook:

	/* ƥ०ȥȥ쥸20MHz */
	movhi  hi(VSWC), r0, r11
	movea  lo(VSWC), r11, r11
	mov  0x01, r12
	st.b  r12, 0[r11]

	/* ݸ줿쥸ؤΥ
	   ץååȥ롦쥸ᥤ󥯥åfxx(PCC=0) */
	movhi  hi(PRCMD), r0, r11
	movea  lo(PRCMD), r11, r11
	movhi  hi(PCC), r0, r13
	movea  lo(PCC), r13, r13
	st.b  r12, 0[r11]
	st.b  r0, 0[r13]
	 nop
	 nop
	 nop
	 nop
	 nop
	movhi  hi(PLLCTL), r0, r13
	movea  lo(PLLCTL), r13, r13
	mov  0x03, r12
	st.b  r12, 0[r13]				/* PLLȥ쥸PLLư */

	movhi  hi(PRCMD), r0, r11
	movea  lo(PRCMD), r11, r11
	movhi  hi(OCDM), r0, r13
	movea  lo(OCDM), r13, r13
	st.b  r12, 0[r11]
	st.b  r0, 0[r13]
	 nop
	 nop
	 nop
	 nop
	 nop
	movhi  hi(WDTM2), r0, r11
	movea  lo(WDTM2), r11, r11
	mov  0x08, r12
	st.b  r12, 0[r11]				/* WDTM2 stop */

	jmp		r31



	/* ɸ߽ȥڡ */
	.macro StandardInterruptEntry name
	.globl \name
\name:
	jr	vector_handler
	nop;nop;nop;nop;nop;nop
	.endm

	.macro ReservedInterruptEntry
	nop;nop;nop;nop;nop;nop;nop;nop
	.endm

/*
 * ߥϥɥʬ
 * 		Ȥꤢս˽롣
 */

	.section	".vectors","ax"
	.align      4
	.globl      __reset
__reset:
	jr	start
	nop;nop;nop;nop;nop;nop

	StandardInterruptEntry NMI
	StandardInterruptEntry INTWDT1
	StandardInterruptEntry INTWDT2
	StandardInterruptEntry TRAP0
	StandardInterruptEntry TRAP1
#ifdef DEBUGGER
DBG0:
	.org 0x0060
	.long 0xFFFFFFFF
	.long 0xFFFFFFFF
	.long 0xFFFFFFFF
	.long 0xFFFFFFFF
#else
	StandardInterruptEntry DBG0
#endif

/*#-------------------------------------------------------------------
  #	SECURITY_ID
  #-------------------------------------------------------------------*/
/*	.section	"SECURITY_ID" */
	.word	0xffffffff	/* --0-3 byte code,Address is 0x70-0x73 */
	.word	0xffffffff	/* --4-7 byte code,Address is 0x74-0x77 */
	.hword	0xffff		/* --8-9 byte code,Address is 0x78-0x79 */
/*#-------------------------------------------------------------------
  #	OPTION_BYTES
  #-------------------------------------------------------------------*/
/*	.section	"OPTION_BYTES" */
	.hword	0x0000		/* --0-1 byte code,Address is 0x7a-0x7b */
	.hword	0x0000		/* --2-3 byte code,Address is 0x7c-0x7d */
	.hword	0x0000		/* --4-5 byte code,Address is 0x7e-0x7f */

	StandardInterruptEntry INTLVI
	StandardInterruptEntry INTP0
	StandardInterruptEntry INTP1
	StandardInterruptEntry INTP2
	StandardInterruptEntry INTP3
	StandardInterruptEntry INTP4
	StandardInterruptEntry INTP5
	StandardInterruptEntry INTP6
	StandardInterruptEntry INTP7
	StandardInterruptEntry INTTQ0OV 
	StandardInterruptEntry INTTQ0CC0
	StandardInterruptEntry INTTQ0CC1
	StandardInterruptEntry INTTQ0CC2
	StandardInterruptEntry INTTQ0CC3
	StandardInterruptEntry INTTP0OV 
	StandardInterruptEntry INTTP0CC0
	StandardInterruptEntry INTTP0CC1
	StandardInterruptEntry INTTP1OV 
	StandardInterruptEntry INTTP1CC0
	StandardInterruptEntry INTTP1CC1
	StandardInterruptEntry INTTP2OV 
	StandardInterruptEntry INTTP2CC0
	StandardInterruptEntry INTTP2CC1
	StandardInterruptEntry INTTP3OV 
	StandardInterruptEntry INTTP3CC0
	StandardInterruptEntry INTTP3CC1
	StandardInterruptEntry INTTP4OV 
	StandardInterruptEntry INTTP4CC0
	StandardInterruptEntry INTTP4CC1
	StandardInterruptEntry INTTP5OV 
	StandardInterruptEntry INTTP5CC0
	StandardInterruptEntry INTTP5CC1
	StandardInterruptEntry INTTM0EQ0
	StandardInterruptEntry INTCB0R
	StandardInterruptEntry INTCB0T
	StandardInterruptEntry INTCB1R
	StandardInterruptEntry INTCB1T
	StandardInterruptEntry INTCB2R
	StandardInterruptEntry INTCB2T
	StandardInterruptEntry INTCB3R
	StandardInterruptEntry INTCB3T
#ifdef DEBUGGER
INTUA0R:
	.org 0x0310
	.long 0xFFFFFFFF
	.long 0xFFFFFFFF
	.long 0xFFFFFFFF
	.long 0xFFFFFFFF
#else
	StandardInterruptEntry INTUA0R
#endif
	StandardInterruptEntry INTUA1R
	StandardInterruptEntry INTUA1T
	StandardInterruptEntry INTUA2R
	StandardInterruptEntry INTUA2T
	StandardInterruptEntry INTAD
	StandardInterruptEntry INTDMA0
	StandardInterruptEntry INTDMA1
	StandardInterruptEntry INTDMA2
	StandardInterruptEntry INTDMA3
	StandardInterruptEntry INTKR
	StandardInterruptEntry INTWTI 
	StandardInterruptEntry INTWT

/*
 * ɾѹǽ?
 *  dummy
 */
 	.text
	.align 4
	.globl _vxget_tim
_vxget_tim:
	jmp	r31


#ifdef DEBUGGER
	.section MonitorROM, "ax"
__monitor:
        .rept	(512)
        .long	0xFFFFFFFF
        .endr
#endif

