/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005 by Freelines CO.,Ltd
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.c,v 1.9 2007/01/05 02:10:17 honda Exp $
 */

/*
 *	ץå¸⥸塼V850ѡ
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include <hw_serial.h>

/*
 *  ƥȤǤγߥޥ
 */
#ifdef SUPPORT_CHG_IPM
UH	task_intmask;
#endif /* SUPPORT_CHG_IPM */

/*
 *  󥿥ƥȤǤγߥޥ
 */
UH	int_intmask;


/*
 *  ߥͥȥ
 */

UW	intnest = 0;

/*
 *  ߥϥɥơ֥
 */
INTVE InterruptHandlerEntry[NUM_INTERRUPT];

/*
 *  ץå¸ν
 */
void
cpu_initialize(void)
{
	hw_port_initialize(SERIAL_PORT);
}

/*
 *  ץå¸νλ
 */
void
cpu_terminate(void)
{
}

/*
 * ϿƤʤߤȯȸƤӽФ
 */

void cpu_experr(unsigned int intno)
{
    syslog(LOG_EMERG, "!Unexpected interrupt. [INTNO = %d]", intno);
    __asm("halt");
}

/*
 *   ƥʸλ
 */

void
cpu_putc(char c)
{
    if (c == '\n') {
        hw_port_wait_putchar(SERIAL_PORT, '\r');
    }
    hw_port_wait_putchar(SERIAL_PORT, c);
}

void *
local_memcpy (void *out, const void *in, unsigned int n)
{
    char *o = out;
    const char *i = in;

    while (n -- > 0)
        *o ++ = *i ++;
    return out;
}
