; *
; *  TOPPERS/JSP Kernel
; *      Toyohashi Open Platform for Embedded Real-Time Systems/
; *      Just Standard Profile Kernel
; * 
; *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
; *                              Toyohashi Univ. of Technology, JAPAN
; * 
; *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
; *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
; *  ҤƤ˸¤ꡤܥեȥܥեȥ
; *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
; *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
; *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
; *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
; *      ˴ޤޤƤ뤳ȡ
; *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
; *      ѤǤǺۤˤϡۤȼɥȡ
; *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
; *      ̵ݾڵǺܤ뤳ȡ
; *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
; *      ѤǤʤǺۤˤϡΤ줫ξ
; *      ȡ
; *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
; *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
; *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
; *        𤹤뤳ȡ
; *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
; *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
; * 
; *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
; *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
; *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
; *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
; * 
; *  @(#) $Id: cpu_support.S,v 1.5 2003/12/04 08:25:44 honda Exp $
; *

        .c_mode
        .align  1
        .global __kernel_dispatch
        .include  "c5402dsk.h"
        .mmregs

__kernel_dispatch:
        PSHM   AR1                       ;AR1,6,7򥹥å¸
        PSHM   AR6                       ;PCϸƤӽФ˥å¸
        PSHM   AR7                       ;¾쥸ARx¸ɬפϤʤ
        LDM    SP,A
        MVDM   *(__kernel_runtsk),AR1    ;AR1 <- runtsk
        NOP
        STL    A,*AR1(TCB_sp)            ;åTCB¸
        ST     #dispatch_r,*AR1(TCB_pc)  ;¹ԺƳϤTCB¸
        B      dispatcher_1

dispatch_r:
        POPM   AR7                       ;쥸
        POPM   AR6
        POPM   AR1 
        B      __kernel_calltex          ;㳰롼θƤӽФ

        .global __kernel_exit_and_dispatch
__kernel_exit_and_dispatch:
        SSBX   INTM                      ;߶ػ
        ST     #0,*(__kernel_nest)               ;ͥνΤ
dispatcher_1:
        LD     *(__kernel_schedtsk),A    ;schedtsk뤫
        BC     dispatcher_2,AEQ          ;̵Х
        MVDK   *(__kernel_schedtsk),*(__kernel_runtsk)   ;schedtskruntsk
        MVDM   *(__kernel_runtsk),AR1
        NOP
        MVDK   *AR1(TCB_sp),SP           ;TCB饹å
        LD     *AR1(TCB_pc),A            ;TCB¹ԺƳϤ
        BACC   A    
        
dispatcher_2:
        STM    #STACKTOP,SP
        ST     #0x01,*(__kernel_nest)
        RSBX   INTM                      ;ߵ
        IDLE   1                         ;ꥻåȤޥƤʤԤ
        SSBX   INTM                      ;߶ػ
        ST     #0x0,*(__kernel_nest)
        B      dispatcher_1


;
;  εư
;

        .global __kernel_activate_r
;         .global _activate_r
__kernel_activate_r:
;_activate_r:
        RSBX   INTM                      ;ߵ
        POPM   AR2
        POPM   AR3
        LDM    AR2,B
        LDM    AR3,A
        BACC   B



        .global _interrupt
_interrupt:
        PSHM   ST0
        PSHM   AL
        PSHM   AH
        PSHM   AG
        PSHM   BL
        PSHM   BH
        PSHM   BG
        PSHM   ST1
        PSHM   AR0
        PSHM   AR2
        PSHM   AR3
        PSHM   AR4
        PSHM   AR5
        PSHM   T
        PSHM   TRN
        PSHM   BK
        PSHM   BRC
        PSHM   RSA
        PSHM   REA
        PSHM   PMST
        LD     *(__kernel_nest),A
        ADDM   #1,*(__kernel_nest)               ;ߤΥͥȲ򥤥󥯥
        BC     _interrupt_from_int,ANEQ
        LDM    SP,A                      ;åؤ
        STM    #STACKTOP,SP              ;Υåݥ󥿤
        PSHM   AL                        ;¸Ԥ
        PSHM   IMR
        MVDM   *(_INT_VECNO),AR2         ;եåͤAR2˥å
        STM    #IMR,AR3                  ;Ʊߤ٤⤫ʤ褦
        LD     *AR2(__kernel_int_mask_table),A   ;            
        AND    *AR3,A                    ;            
        STL    A,*AR3                    ;ߤγߤޥ 
        LD     *AR2(__kernel_int_table),A        ;ߥϥɥΥɥ쥹
        RSBX   INTM                      ;ʹ߳ߤդ
        CALA   A                         ;ߥϥɥ
        SSBX   INTM                      ;ߤػ
        ADDM   #-1,*(__kernel_nest)              ;ǥ
        POPM   IMR
        POPM   SP                        ;褬ʤΤǥå᤹
        LD     *(__kernel_reqflg),A
        BC     _ret_to_task_int,AEQ      ;reqflgFALSEʤ饸
        ST     #0,*(__kernel_reqflg)
        B      ret_int

_interrupt_from_int:
        LDM    SP,A
        ANDM   #0xFFFE,*(SP)
        NOP
        NOP
        PSHM   AL
        PSHM   IMR
        MVDM   *(_INT_VECNO),AR2         ;եåͤAR2˥å
        STM    #IMR,AR3                  ;Ʊߤ٤⤫ʤ褦
        LD     *AR2(__kernel_int_mask_table),A   ;            
        AND    *AR3,A                    ;            
        STL    A,*AR3                    ;ߤγߤޥ 
        LD     *AR2(__kernel_int_table),A        ;ߥϥɥΥɥ쥹
        RSBX   INTM                      ;ʹ߳ߤդ
        CALA   A                         ;ߥϥɥ
        SSBX   INTM                      ;߶ػ
        POPM   IMR
        POPM   SP
        ADDM   #-1,*(__kernel_nest)              ;ߤΥͥȲǥ
_ret_to_task_int:                        ;쥸߸롣
        POPM   PMST
        POPM   REA
        POPM   RSA
        POPM   BRC
        POPM   BK
        POPM   TRN
        POPM   T
        POPM   AR5
        POPM   AR4
        POPM   AR3
        POPM   AR2
        POPM   AR0
        POPM   ST1
        POPM   BG
        POPM   BH
        POPM   BL
        POPM   AG
        POPM   AH
        POPM   AL
        POPM   ST0
        RETE
        
        .global ret_int
ret_int:
        LD     *(__kernel_enadsp),A
        BC     ret_int_1,AEQ
        MVDM    *(__kernel_runtsk),AR0
        MVDM    *(__kernel_schedtsk),AR2
        NOP
        CMPR   EQ,AR2                    ;runtskschedtsk 
        BC     ret_int_1,TC
        PSHM   AR1
        PSHM   AR6
        PSHM   AR7
        LDM    SP,A
        STL    A,*AR0(TCB_sp)
        ST     #ret_int_r,*AR0(TCB_pc)
        B      dispatcher_1
ret_int_r:
        POPM   AR7
        POPM   AR6
        POPM   AR1
ret_int_1:
        LDM    SP,A
        ANDM   #0xFFFE,*(SP)
        NOP
        NOP
        PSHM   AL
        FRAME  #-1
        LD     #__kernel_calltex,A
        CALA   A
        FRAME  #1
        POPM   SP
        NOP
        POPM   PMST
        POPM   REA
        POPM   RSA
        POPM   BRC
        POPM   BK
        POPM   TRN
        POPM   T
        POPM   AR5
        POPM   AR4
        POPM   AR3
        POPM   AR2
        POPM   AR0
        POPM   ST1
        POPM   BG
        POPM   BH
        POPM   BL
        POPM   AG
        POPM   AH
        POPM   AL
        POPM   ST0
        RETE

;
;   Ԥ
;
        .global	_sil_dly_nse
_sil_dly_nse:
        SSBX      SXM
        NOP
        LD	*(AL), A
        SUB	#SIL_DLY_TIM1, A, A
        BC	_sil_dly_nse1, AGT
        RET
_sil_dly_nse1:
        SUB	#SIL_DLY_TIM2, A, A
        BC	_sil_dly_nse1, AGT
        RET

