/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2010 by Cronus Computer Works, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id
 */

/*
 *	ޥɥ饤
 *  CMT
 */

#ifndef _SH726XCMT_H_
#define _SH726XCMT_H_

/*
 *   ޤؤϥåʬ
 *   	f/8ǥ
 */
//#define TCR_CKS         0x0   /* sys_def.h ذư */

/*
 *   ޤ˶뤵륯åȿ[kHz]
 */
#if TCR_CKS == 0
#define TIMER_CLOCK     ((PCLOCK / 1000) / 8)
#elif TCR_CKS == 1
#define TIMER_CLOCK     ((PCLOCK / 1000) / 32)
#elif TCR_CKS == 2
#define TIMER_CLOCK     ((PCLOCK / 1000) / 128)
#elif TCR_CKS == 3
#define TIMER_CLOCK     ((PCLOCK / 1000) / 512)
#endif


/*
 *  ͤɽη
 */
typedef UH CLOCK;

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *
 */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)
#define CLOCK_PER_TICK	((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define	MAX_CLOCK	((CLOCK) 0xffff)

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define	GET_TOLERANCE	100		/* ٤θѤ͡ñ̤ɽ */
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ȥ쥸Υɥ쥹
 */
#ifndef CMSTR
#define CMSTR	(VH *)0xfffec000
#define CMCSR_0	(VH *)0xfffec002
#define CMCNT_0	(VH *)0xfffec004
#define CMCOR_0	(VH *)0xfffec006
#endif


#ifndef _MACRO_ONLY
/*
 *  ޥ
 */
Inline void
sh2_timer_start ()
{
	sil_wrh_mem (CMSTR, sil_reh_mem (CMSTR) | 0x0001);
}

/*
 *  ް
 */
Inline void
sh2_timer_stop ()
{
    	/* ޤ 	  */
	sil_wrh_mem (CMSTR, sil_reh_mem (CMSTR) & ~0x0001);
}

/*
 *  ޳׵Υꥢ
 *	TCR쥸IMFAӥåȤ1ɤ߽Фˣ񤭹
 */
Inline void
sh2_timer_int_clear ()
{
	/* ׵򥯥ꥢ     */
	sil_wrh_mem (CMCSR_0, sil_reh_mem (CMCSR_0) & ~0x0080);
				/* CMFڥޥåե饰Υꥢ */
}


/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
sh2_timer_initialize ()
{
	CLOCK cyc = TO_CLOCK (TIC_NUME, TIC_DENO);

#if defined(SH7203) || defined(SH7263)
	sil_wrb_mem (STBCR4, (sil_reb_mem(STBCR4)& ~0x04));
#endif
#if defined(SH7262) || defined(SH7264)
	sil_wrb_mem (STBCR7, (sil_reb_mem(STBCR7)& ~0x04));
#endif
	/*
	 *  ޴Ϣ
	 */
	sh2_timer_stop ();			/*  */
	/* ޾ͤΥå */
	assert (cyc <= MAX_CLOCK);

	/*  ʬ  clock 1/8  ߶ػ */
    sil_wrh_mem(CMCSR_0,0x0000);
	/*  CMCOR0쥸ʥɸ͡      */
	sil_wrh_mem (CMCOR_0,(VH)CLOCK_PER_TICK);
	/* 󥿤򥯥ꥢ             */
	sil_wrh_mem (CMCNT_0,0x0000);
	sil_wrh_mem (CMCSR_0, sil_reh_mem(CMCSR_0) | 0x0040);	/* ߵ */
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
sh2_timer_terminate ()
{
	sh2_timer_stop ();			/* ޤ     */
	sh2_timer_int_clear ();		/* ׵򥯥ꥢ */

	sil_wrh_mem (CMCSR_0, sil_reh_mem(CMCSR_0) & ~0x0040);	//Ե
	sil_wrh_mem (CMCNT_0,0x0000);
	sil_wrh_mem (CMCOR_0,0x0000);
#if defined(SH7203) || defined(SH7263)
	sil_wrb_mem (STBCR4, (sil_reb_mem(STBCR4) | 0x04));
#endif
#if defined(SH7262) || defined(SH7264)
	sil_wrb_mem (STBCR7, (sil_reb_mem(STBCR7) | 0x04));
#endif
}

/*
 *  ޤθͤɽФ
 *ޤưŪߤͤɤ߽Ф
 */
Inline CLOCK
sh2_timer_get_current ()
{
	CLOCK	clk;
/* SH1Ʊ */
	sh2_timer_stop ();			/*    */

	/*  Ԥ֤٤  */

	clk = sil_reh_mem(CMCNT_0);
	sh2_timer_start();			/*  ޥ  */
	
	return(clk);
}

/*
 *  ޳׵Υå
 */
Inline BOOL
sh2_timer_fetch_interrupt ()
{
	return (sil_reh_mem (CMCSR_0) & 0x0080);
}

#endif /* _MACRO_ONLY */
#endif /* _SH726XCMT_H_ */
