/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sh7145sci.c,v 1.3 2005/07/06 00:45:07 honda Exp $
 */

/*
 *   SH2¢ꥢ륳ߥ˥󥤥󥿥եSCI ʰץɥ饤
 */

#include <s_services.h>
#include "sh7145sci.h"

/*
 * ꥢI/OݡȽ֥å
 */
#ifndef GDB_STUB
const SIOPINIB siopinib_table[TNUM_PORT] = {
	{0xffff81b0, BRR9600, 0x0, 6}, /* SCI1 */
#if TNUM_PORT >= 2
	{0xffff81a0, BRR9600, 0x0, 6}, /* SCI0 */
#endif /* TNUM_PORT >= 2 */
};
#else /* GDB_STUB */
const SIOPINIB siopinib_table[TNUM_PORT] = {
	{0xffff81a0, BRR9600, 0x0, 6}, /* SCI0 */
};
#endif /* GDB_STUB */


/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
static SIOPCB siopcb_table[TNUM_PORT];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
				/*  ݡIDǥХֹޥ  */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  ʸǤ뤫
 */
Inline BOOL
sh2sci_getready (SIOPCB * siopcb)
{
	/*  쥷֥ǡ쥸ե롦ե饰Υå  */
	return (sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SSR)) &
			SSR_RDRF);
}

/*
 *  ʸǤ뤫
 */
Inline BOOL
sh2sci_putready (SIOPCB * siopcb)
{
	/*  ȥ󥹥ߥåȥǡ쥸ץƥե饰Υå */
	return (sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SSR)) &
			SSR_TDRE);
}

/*
 *  ʸμФ
 */
Inline char
sh2sci_getchar (SIOPCB * siopcb)
{
	char data;

	data = sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_RDR));
	/*  쥷֥ǡ쥸ե롦ե饰Υꥢ  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SSR),
				 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
									  SCI_SSR)) & ~SSR_RDRF);
	return data;
}

/*
 *  ʸν
 */
Inline void
sh2sci_putchar (SIOPCB * siopcb, char c)
{
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_TDR), c);
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SSR),
				 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
									  SCI_SSR)) & ~SSR_TDRE);
}

/*
 *  SIOɥ饤Фν롼
 */
void
sh2sci_initialize ()
{
	SIOPCB *siopcb;
	UINT i;

	/*
	 *  ꥢI/Oݡȴ֥åν
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_PORT; siopcb++, i++) {
		siopcb->openflag = FALSE;
		siopcb->siopinib = (&siopinib_table[i]);
	}
}

/*
 *  ץ󤷤ƤݡȤ뤫
 */
BOOL
sh2sci_openflag (ID siopid)
{
	return (siopcb_table[siopid - 1].openflag);
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
sh2sci_opn_por (ID siopid, VP_INT exinf)
{
	SIOPCB *siopcb = get_siopcb (siopid);

	/*    */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR), 0x00);

	/*  SCIǡϥݡȤ  */
	/*  ԥ󥢥 */
	/* sys_initialize */

	/*  եޥå  */
	/*  ĴƱ  */
	/*  8ӥåȡѥƥʤ  */
	/*  ȥåץӥåȥ󥰥1   */
	/*  å쥯 */

	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SMR),
				 siopcb->siopinib->smr);
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_BRR),
				 (VB) siopcb->siopinib->brr);

	/*
	 * ܡ졼Ȥ塢1ʬԤʤФʤʤ
	 */
	sil_dly_nse (sh2sci_DELAY);	/* ͤϣ裱Ʊ */

	/* 顼ե饰򥯥ꥢ */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SSR),
				 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
									  SCI_SSR)) & ~(SSR_ORER | SSR_FER |
													SSR_PER));
	/*ġߵ */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR),
				 (VB) (SCI_RIE | SCI_TE | SCI_RE));

	siopcb->exinf = exinf;
	siopcb->openflag = TRUE;
	return (siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
sh2sci_cls_por (SIOPCB * siopcb)
{
	/*  ߡ߶ػ  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR),
				 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
									  SCI_SCR)) & (VB) ~ (SCI_TIE | SCI_RIE |
														  SCI_TE | SCI_RE));
	siopcb->openflag = FALSE;
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
sh2sci_snd_chr (SIOPCB * siopcb, char c)
{
	if (sh2sci_putready (siopcb)) {
		sh2sci_putchar (siopcb, c);
		return (TRUE);
	}
	return (FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
sh2sci_rcv_chr (SIOPCB * siopcb)
{
	if (sh2sci_getready (siopcb)) {
		return ((INT) (UB) sh2sci_getchar (siopcb));
		/*  (UB)ǥ㥹ȤΤϥĥˤ뤿  */
	}
	return (-1);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
sh2sci_ena_cbr (SIOPCB * siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:			/* ׵ */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCI_SCR)) | SCI_TIE);
		break;
	case SIO_ERDY_RCV:			/* ׵ */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCI_SCR)) | SCI_RIE);
		break;
	}
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
sh2sci_dis_cbr (SIOPCB * siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:			/* ׵ػ */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCI_SCR)) & ~SCI_TIE);
		break;
	case SIO_ERDY_RCV:			/* ׵ػ */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCI_SCR)) & ~SCI_RIE);
		break;
	}
}

/*
 *  ꥢI/OݡȤФ߽
 */
Inline void
sh2sci_isr_siop_out (SIOPCB * siopcb)
{
	VB scr0 = sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR));

	if ((scr0 & SCI_TIE) != 0 && sh2sci_putready (siopcb)) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		sh2sci_ierdy_snd (siopcb->exinf);
	}
}

/*
 *  ꥢI/OݡȤФ߽
 */
Inline void
sh2sci_isr_siop_in (SIOPCB * siopcb)
{
	VB scr0 = sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR));

	if ((scr0 & SCI_RIE) != 0 && sh2sci_getready (siopcb)) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		sh2sci_ierdy_rcv (siopcb->exinf);
	}
}

/*
 *  ꥢI/OݡȤФ顼߽
 */
Inline void
sh2sci_isr_siop_err (SIOPCB * siopcb)
{
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SSR),
				 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
									  SCI_SSR)) & ~(SSR_ORER | SSR_FER |
													SSR_PER));
}

/*
 *  SCIߥӥ롼
 *  
 */
void
sh2sci_isr_out (void)
{
	if (siopcb_table[0].openflag) {
		sh2sci_isr_siop_out (get_siopcb (1));
	}
}

/*
 *  SIOߥӥ롼
 *  
 */
void
sh2sci_isr_in (void)
{
	if (siopcb_table[0].openflag) {
		sh2sci_isr_siop_in (get_siopcb (1));
	}
}

/*
 *  SIO顼ߥӥ롼
 */
void
sh2sci_isr_error (void)
{
	if (siopcb_table[0].openflag) {
		sh2sci_isr_siop_err (get_siopcb (1));
	}
}

/*
 * ݡ󥰤ˤʸ
 */
void
sh2sci_putc_pol (ID portid, char c)
{
	while (!sh2sci_putready (&siopcb_table[portid - 1]));
	sh2sci_putchar (&siopcb_table[portid - 1], c);
}


#if TNUM_PORT >= 2
/*
 *  SIOߥӥ롼
 *  
 */
void
sh2sci_isr2_in (void)
{
	if (siopcb_table[1].openflag) {
		sh2sci_isr_siop_in (get_siopcb (2));
	}
}

/*
 *  SCIߥӥ롼
 *  
 */
void
sh2sci_isr2_out (void)
{
	if (siopcb_table[1].openflag) {
		sh2sci_isr_siop_out (get_siopcb (2));
	}
}

/*
 *  SIO顼ߥӥ롼
 */
void
sh2sci_isr2_error (void)
{
	if (siopcb_table[1].openflag) {
		sh2sci_isr_siop_err (get_siopcb (2));
	}
}
#endif /* of #if TNUM_PORT >= 2 */
