/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2003-2004 by CHUO ELECTRIC WORKS Co.,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */
/*
 *	åȥƥ¸⥸塼
 *	()ITRONSH1CPUܡ
 */
 
#include <s_services.h>
#include "kernel_id.h"

#include <sh1.h>
#include "sys_support.h"

/*
 *  TINETѻ
 */
#ifdef	SUPPORT_INET4
#include <sh1_sil.h>
#include <tinet_sys_config.h>
/*
 *  NIC (RTL8019AS) ˴ؤ
 *  TINETѻtinet_sys_config.h ذư뤳
 */
/*#define ED_BASE_ADDRESS	0x06000000	*/	/* NIC Υ쥸١ɥ쥹 */
/*#define INHNO_IF_ED		IRQ5		*/	/* IRQ5 */
/*#define ED_PRI		7		*/	/* ͥ=7 */
/*#define ED_LEVEL0		0		*/	/* ߶ػ  */
/*#define ED_IPR		IPRB		*/	/* ͥ٥쥸̾ */
/*#define ED_IPR_SHIFT		8		*/	/* ͥ٥쥸ӥåȰ */
#endif	/* SUPPORT_INET4 */

/*
 *  ROMICEѤNMIޤǤROM٥ơ֥ΰ
 */
#define ROMVECT_START	0			/* ROMΥ٥ơ֥ϣϤ 	*/
#define ROMVECT_SIZE	((NMI+1)*sizeof(FP))	/* ROMΥ٥ơ֥륵 		*/

/*
 *  ٥Υåȥƥ¸ν _hardware_init_hook
 *
 *  ȥåץ⥸塼ǡν˸ƤӽФ롥
 */
void
hardware_init_hook(void)
{
	/* WCR3:ȥȥ쥸
	 * WPU=1    WAITüҥץ륢å
	 * A02LW=00 ꥢ0,21ێݎގ
	 * A6LW=00  ꥢ6  1ێݎގ
	 */
	sil_wrh_mem(BSC_WCR3, 0x8000); 
	
	/* BCR:Хȥ쥸
	 * DRANE=0   ؎1ϳ
	 * IOE=0     ؎6ϳ
	 * WARP=0    ɎώَӎĎ:􎱎􎱎Ʊ˹Ԥʤ
	 * RDDTY=0   RDHI T150%
	 * BAS=0     WRH,WRL,A0ͭ
	 */
	sil_wrh_mem(BSC_BCR, 0x0000);
	
	/* WCR1:ȥȥ쥸
	 * read cycle state
	 * waitüҥץ뤷ʤ
	 * RWx=0  ꥢ1,3,4,5,7 1Îĸ
	 * RWx=0  ꥢ0,2,6 1Î+ێݎގġʷ3Îġ
	 * WW1=1  ꥢ1Ҏӎ 2Î
	 */
	sil_wrh_mem(BSC_WCR1, 0x00ff);
	
	/* WCR2:ȥȥ쥸
	 * DMAʤΤǽͤΤޤ
	 */
	sil_wrh_mem(BSC_WCR2, 0xffff); 
	
	/*
	 * УУ½ϥХåե
	 */
	sil_wrh_mem(PA_DR, VAL_PA_DR);
	sil_wrh_mem(PB_DR, VAL_PB_DR); 

	/*
	 * УϽsys_support.hȡ
	 */
	sil_wrh_mem(PFC_PACR1, VAL_PFC_PACR1);
	sil_wrh_mem(PFC_PACR2, VAL_PFC_PACR2);
                                        
	sil_wrh_mem(PFC_PAIOR, VAL_PFC_PAIOR);
                    
	sil_wrh_mem(PFC_PBCR1, VAL_PFC_PBCR1);
	sil_wrh_mem(PFC_PBCR2, VAL_PFC_PBCR2);
	sil_wrh_mem(PFC_PBIOR, VAL_PFC_PBIOR);

	sil_wrh_mem(PFC_CASCR, VAL_PFC_CASCR);

}

/*
 *  եȥĶä˥饤֥ˤ˰¸ɬפʽ software_init_hook
 *
 *  ȥåץ⥸塼ǡͥư˸ƤӽФ롥
 */
#ifdef	PARTNER
void
software_init_hook(void)
{
	/*
	 *  ROMICEѻROM٥ơ֥ž
	 */
	extern FP vector_table[];
	memcpy(vector_table, ROMVECT_START, ROMVECT_SIZE);
}
#endif

/*
 *  NIC ϡɥߵ
 *  TINETѻɬ
 */
#ifdef	SUPPORT_INET4
void
ed_ena_inter(void)
{
	SIL_PRE_LOC;
	SIL_LOC_INT();
	define_int_plevel(ED_IPR, ED_PRI, ED_IPR_SHIFT);// ͥ=ED_PRI
	SIL_UNL_INT();
}

/*
 *  NIC ϡɥ߶ػ
 *  TINETѻɬ
 */
void
ed_dis_inter(void)
{
	SIL_PRE_LOC;
	SIL_LOC_INT();
	define_int_plevel(ED_IPR, ED_LEVEL0, ED_IPR_SHIFT);// ͥ=0
	SIL_UNL_INT();
}
#endif	/* SUPPORT_INET4 *//* end */

