/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */

/*
 *  ϡɥ񸻤
 *  definitions of hardware resource.
 */
#ifndef _DMT33209_H_
#define _DMT33209_H_

#include "s1c33.h"

#ifndef _MACRO_ONLY
extern int __START_bss[];			/* 󥫥ץȤ	*/
extern int __END_bss[];				/* ܥ			*/
extern int __START_data[];
extern int __END_data[];
extern int __START_vector[];
extern int __END_vector[];
extern int __START_data_lma[];
extern int __END_data_lma[];
extern int __START_vector_lma[];
extern int __END_vector_lma[];
#endif /* _MACRO_ONLY */

/*
 *	ꥢƬ/üɥ쥹
 *  Top/tail address of each area.
 */
#define STACKTOP	((void *)0x00002000)

#define BSS_START	__START_bss		/* RAMΰƬ 		*/
#define BSS_END		__END_bss		/* RAMΰνü		*/
#define DATA_START	__START_data		/* RAMνѿΰƬ	*/
#define IDATA_START	__START_data_lma	/* ROMνѿΰƬ	*/
#define IDATA_END	__END_data_lma		/* ROMνѿΰ轪ü	*/
#define VECTOR_START	__START_vector		/* RAMΥ٥ơ֥ΰƬ*/
#define IVECTOR_START	__START_vector_lma	/* ROMΥ٥ơ֥ΰƬ*/
#define IVECTOR_END	__END_vector_lma	/* ROMΥ٥ơ֥ΰ轪ü*/

#endif /*  _DMT33209_H_ */
