/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: rx63nsci.c,v 1.3 2015/06/28 15:32:12 ssuzuki Exp $
 */

/*
 *	RX63N¢SCI ʰSIOɥ饤
 */

#include <s_services.h>
#include "rx63n.h"
#include "rx63nsci.h"

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_initialization_block {
	UINT	ch;		/* ֹͥ */
	VP	rdr;		/* 쥷֥ǡ쥸 */
	VP	tdr;		/* ȥ󥹥ߥåȥǡ쥸 */
	VP	scr;		/* ꥢ륳ȥ쥸 */
	VP	ssr;		/* ꥢ륹ơ쥸 */
	VP	smr;		/* ꥢ⡼ɥ쥸 */
	VP	scmr;		/* ޡȥɥ⡼ɥ쥸 */
	VP	spmr;		/* SPI⡼ɥ쥸 */
	VP	semr;		/* ꥢĥ⡼ɥ쥸 */
	VP	simr1;		/* I2C⡼ɥ쥸1 */
	VP	brr;		/* ӥåȥ졼ȥ쥸 */
	VP	ir_txi;		/* ׵쥸(TXIʬ) */
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 */
struct sio_port_control_block {
	const SIOPINIB	*siopinib;	/* ꥢI/OݡȽ֥å */
	VP_INT		exinf;		/* ĥ */
	BOOL		openflag;	/* ץѤߥե饰 */
	BOOL		getready;	/* ʸ */
	BOOL		putready;	/* ʸǤ */
};

/*
 *  ꥢI/OݡȽ֥å
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
#ifdef	USE_RX63N_SCI0
	{
		0,
		(VP) RX63N_SCI0_RDR,
		(VP) RX63N_SCI0_TDR,
		(VP) RX63N_SCI0_SCR,
		(VP) RX63N_SCI0_SSR,
		(VP) RX63N_SCI0_SMR,
		(VP) RX63N_SCI0_SCMR,
		(VP) RX63N_SCI0_SPMR,
		(VP) RX63N_SCI0_SEMR,
		(VP) RX63N_SCI0_SIMR1,
		(VP) RX63N_SCI0_BRR,
		(VP) RX63N_IR215
	},
#endif	/* USE_RX63N_SCI0 */
#ifdef	USE_RX63N_SCI1
	{
		1,
		(VP) RX63N_SCI1_RDR,
		(VP) RX63N_SCI1_TDR,
		(VP) RX63N_SCI1_SCR,
		(VP) RX63N_SCI1_SSR,
		(VP) RX63N_SCI1_SMR,
		(VP) RX63N_SCI1_SCMR,
		(VP) RX63N_SCI1_SPMR,
		(VP) RX63N_SCI1_SEMR,
		(VP) RX63N_SCI1_SIMR1,
		(VP) RX63N_SCI1_BRR,
		(VP) RX63N_IR218
	},
#endif	/* USE_RX63N_SCI1 */
#ifdef	USE_RX63N_SCI2
	{
		2,
		(VP) RX63N_SCI2_RDR,
		(VP) RX63N_SCI2_TDR,
		(VP) RX63N_SCI2_SCR,
		(VP) RX63N_SCI2_SSR,
		(VP) RX63N_SCI2_SMR,
		(VP) RX63N_SCI2_SCMR,
		(VP) RX63N_SCI2_SPMR,
		(VP) RX63N_SCI2_SEMR,
		(VP) RX63N_SCI2_SIMR1,
		(VP) RX63N_SCI2_BRR,
		(VP) RX63N_IR221
	},
#endif	/* USE_RX63N_SCI2 */
#ifdef	USE_RX63N_SCI3
	{
		3,
		(VP) RX63N_SCI3_RDR,
		(VP) RX63N_SCI3_TDR,
		(VP) RX63N_SCI3_SCR,
		(VP) RX63N_SCI3_SSR,
		(VP) RX63N_SCI3_SMR,
		(VP) RX63N_SCI3_SCMR,
		(VP) RX63N_SCI3_SPMR,
		(VP) RX63N_SCI3_SEMR,
		(VP) RX63N_SCI3_SIMR1,
		(VP) RX63N_SCI3_BRR,
		(VP) RX63N_IR224
	},
#endif	/* USE_RX63N_SCI3 */
#ifdef	USE_RX63N_SCI4
	{
		4,
		(VP) RX63N_SCI4_RDR,
		(VP) RX63N_SCI4_TDR,
		(VP) RX63N_SCI4_SCR,
		(VP) RX63N_SCI4_SSR,
		(VP) RX63N_SCI4_SMR,
		(VP) RX63N_SCI4_SCMR,
		(VP) RX63N_SCI4_SPMR,
		(VP) RX63N_SCI4_SEMR,
		(VP) RX63N_SCI4_SIMR1,
		(VP) RX63N_SCI4_BRR,
		(VP) RX63N_IR227
	},
#endif	/* USE_RX63N_SCI4 */
#ifdef	USE_RX63N_SCI5
	{
		5,
		(VP) RX63N_SCI5_RDR,
		(VP) RX63N_SCI5_TDR,
		(VP) RX63N_SCI5_SCR,
		(VP) RX63N_SCI5_SSR,
		(VP) RX63N_SCI5_SMR,
		(VP) RX63N_SCI5_SCMR,
		(VP) RX63N_SCI5_SPMR,
		(VP) RX63N_SCI5_SEMR,
		(VP) RX63N_SCI5_SIMR1,
		(VP) RX63N_SCI5_BRR,
		(VP) RX63N_IR230
	},
#endif	/* USE_RX63N_SCI5 */
#ifdef	USE_RX63N_SCI6
	{
		6,
		(VP) RX63N_SCI6_RDR,
		(VP) RX63N_SCI6_TDR,
		(VP) RX63N_SCI6_SCR,
		(VP) RX63N_SCI6_SSR,
		(VP) RX63N_SCI6_SMR,
		(VP) RX63N_SCI6_SCMR,
		(VP) RX63N_SCI6_SPMR,
		(VP) RX63N_SCI6_SEMR,
		(VP) RX63N_SCI6_SIMR1,
		(VP) RX63N_SCI6_BRR,
		(VP) RX63N_IR233
	},
#endif	/* USE_RX63N_SCI6 */
#ifdef	USE_RX63N_SCI7
	{
		7,
		(VP) RX63N_SCI7_RDR,
		(VP) RX63N_SCI7_TDR,
		(VP) RX63N_SCI7_SCR,
		(VP) RX63N_SCI7_SSR,
		(VP) RX63N_SCI7_SMR,
		(VP) RX63N_SCI7_SCMR,
		(VP) RX63N_SCI7_SPMR,
		(VP) RX63N_SCI7_SEMR,
		(VP) RX63N_SCI7_SIMR1,
		(VP) RX63N_SCI7_BRR,
		(VP) RX63N_IR236
	},
#endif	/* USE_RX63N_SCI7 */
#ifdef	USE_RX63N_SCI8
	{
		8,
		(VP) RX63N_SCI8_RDR,
		(VP) RX63N_SCI8_TDR,
		(VP) RX63N_SCI8_SCR,
		(VP) RX63N_SCI8_SSR,
		(VP) RX63N_SCI8_SMR,
		(VP) RX63N_SCI8_SCMR,
		(VP) RX63N_SCI8_SPMR,
		(VP) RX63N_SCI8_SEMR,
		(VP) RX63N_SCI8_SIMR1,
		(VP) RX63N_SCI8_BRR,
		(VP) RX63N_IR239
	},
#endif	/* USE_RX63N_SCI8 */
#ifdef	USE_RX63N_SCI9
	{
		9,
		(VP) RX63N_SCI9_RDR,
		(VP) RX63N_SCI9_TDR,
		(VP) RX63N_SCI9_SCR,
		(VP) RX63N_SCI9_SSR,
		(VP) RX63N_SCI9_SMR,
		(VP) RX63N_SCI9_SCMR,
		(VP) RX63N_SCI9_SPMR,
		(VP) RX63N_SCI9_SEMR,
		(VP) RX63N_SCI9_SIMR1,
		(VP) RX63N_SCI9_BRR,
		(VP) RX63N_IR242
	},
#endif	/* USE_RX63N_SCI9 */
#ifdef	USE_RX63N_SCI10
	{
		10,
		(VP) RX63N_SCI10_RDR,
		(VP) RX63N_SCI10_TDR,
		(VP) RX63N_SCI10_SCR,
		(VP) RX63N_SCI10_SSR,
		(VP) RX63N_SCI10_SMR,
		(VP) RX63N_SCI10_SCMR,
		(VP) RX63N_SCI10_SPMR,
		(VP) RX63N_SCI10_SEMR,
		(VP) RX63N_SCI10_SIMR1,
		(VP) RX63N_SCI10_BRR,
		(VP) RX63N_IR245
	},
#endif	/* USE_RX63N_SCI10 */
#ifdef	USE_RX63N_SCI11
	{
		11,
		(VP) RX63N_SCI11_RDR,
		(VP) RX63N_SCI11_TDR,
		(VP) RX63N_SCI11_SCR,
		(VP) RX63N_SCI11_SSR,
		(VP) RX63N_SCI11_SMR,
		(VP) RX63N_SCI11_SCMR,
		(VP) RX63N_SCI11_SPMR,
		(VP) RX63N_SCI11_SEMR,
		(VP) RX63N_SCI11_SIMR1,
		(VP) RX63N_SCI11_BRR,
		(VP) RX63N_IR248
	},
#endif	/* USE_RX63N_SCI11 */
#ifdef	USE_RX63N_SCI12
	{
		12,
		(VP) RX63N_SCI12_RDR,
		(VP) RX63N_SCI12_TDR,
		(VP) RX63N_SCI12_SCR,
		(VP) RX63N_SCI12_SSR,
		(VP) RX63N_SCI12_SMR,
		(VP) RX63N_SCI12_SCMR,
		(VP) RX63N_SCI12_SPMR,
		(VP) RX63N_SCI12_SEMR,
		(VP) RX63N_SCI12_SIMR1,
		(VP) RX63N_SCI12_BRR,
		(VP) RX63N_IR251
	}
#endif	/* USE_RX63N_SCI12 */
};

/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  SIOɥ饤Фν롼
 */
void	rx63nsci_initialize(void)
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  ꥢI/Oݡȴ֥åν
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->openflag = FALSE;
	}
}

/*
 *  ץ󤷤ƤݡȤ뤫
 */
BOOL	rx63nsci_openflag(ID siopid)
{
	return(siopcb_table[(UINT)(siopid - 1)].openflag);
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB	*rx63nsci_opn_por(ID siopid, VP_INT exinf)
{
	const SIOPINIB	*siopinib;
	SIOPCB		*siopcb;

	siopinib = &siopinib_table[(UINT)(siopid) - 1];
	siopcb = &siopcb_table[(UINT)(siopid) - 1];
	
	/* SCR ν */
	sil_wrb_mem(siopinib->scr, 0x00);

	/* ¢ܡ졼ȥͥ졼Ѥ */
	sil_wrb_mem(siopinib->scr, sil_reb_mem(siopinib->scr) & ~0x03);

	/* ꥢ륤󥿥ե⡼ɤư */
	sil_wrb_mem(siopinib->simr1, sil_reb_mem(siopinib->simr1) & ~0x01);

	/* clear the SPMR.CKPH and CKPOL bits to 0 */
	sil_wrb_mem(siopinib->spmr, sil_reb_mem(siopinib->spmr) & ~0xc0);

	/* եޥåȤ8bitѥƥʤ1ȥåץӥåȤꤹ */
	sil_wrb_mem(siopinib->smr, 0x00);
	sil_wrb_mem(siopinib->scmr, 0xf2);
	sil_wrb_mem(siopinib->semr, 0x00);

	/* ܡ졼Ȥ9,600bpsꤹ */
	sil_wrb_mem(siopinib->brr, PCLK / (32 * SYSTEM_BAUD_RATE) - 1);

	/* ͭˤ */
	sil_wrb_mem((VP) siopinib->scr, 0x50);

	siopcb->exinf = exinf;
	siopcb->getready = FALSE;
	siopcb->putready = FALSE;
	siopcb->openflag = TRUE;

	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void	rx63nsci_cls_por(SIOPCB *siopcb)
{
	/* Ӽ̵ˤ */
	sil_wrb_mem(siopcb->siopinib->scr, 0x00);
	siopcb->openflag = FALSE;
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL	rx63nsci_snd_chr(SIOPCB *siopcb, char c)
{
	if (siopcb->putready) {
		sil_wrb_mem(siopcb->siopinib->tdr, c);
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  ꥢI/OݡȤؤʸ(ݡ)
 */
BOOL	rx63nsci_snd_chr_pol(ID siopid, char c)
{

	SIOPCB	*siopcb = &siopcb_table[(UINT)(siopid - 1)];

	sil_wrb_mem(siopcb->siopinib->scr,
			sil_reb_mem(siopcb->siopinib->scr) | 0xa0);
	while (!sil_reb_mem(siopcb->siopinib->ir_txi)) ;

	sil_wrb_mem(siopcb->siopinib->tdr, c);
	while (sil_reb_mem(siopcb->siopinib->ssr) & 0x04) ;
	while (!(sil_reb_mem(siopcb->siopinib->ssr) & 0x04)) ;

	sil_wrb_mem(siopcb->siopinib->scr,
			sil_reb_mem(siopcb->siopinib->scr) & ~0xa0);

	return(TRUE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT	rx63nsci_rcv_chr(SIOPCB *siopcb)
{
	if (siopcb->getready) {
		siopcb->getready = FALSE;
		return((char) sil_reb_mem(siopcb->siopinib->rdr));
	}
	return(-1);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void	rx63nsci_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:	/* ׵ */
		sil_wrb_mem(siopcb->siopinib->scr,
				sil_reb_mem(siopcb->siopinib->scr) | 0xa0);
		break;
	case SIO_ERDY_RCV:	/* ׵ */
		sil_wrb_mem(siopcb->siopinib->scr,
				sil_reb_mem(siopcb->siopinib->scr) | 0x40);
		break;
	}
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void	rx63nsci_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:	/* ׵ػ */
		sil_wrb_mem(siopcb->siopinib->scr,
			(sil_reb_mem(siopcb->siopinib->scr) & ~0x80) | 0x04);
		break;
	case SIO_ERDY_RCV:	/* ׵ػ */
		sil_wrb_mem(siopcb->siopinib->scr,
			sil_reb_mem(siopcb->siopinib->scr) & ~0x40);
		break;
	}
}

/*
 *  SIOγߥӥ롼
 */
void	rx63nsci_isr_rxi(ID siopid)
{
	SIOPCB	*siopcb = &siopcb_table[(UINT)(siopid - 1)];

	if (siopcb->openflag) {
		/*
		 *  rx63nsci_rcv_chr() ˤ RDR ɤ߽Фϡ
		 *  RXI ߥϥɥǤΤߵĤ롥
		 */
		siopcb->getready = TRUE;

		/*
		 *  ΥХå롼ƤӽФ
		 */
		rx63nsci_ierdy_rcv(siopcb->exinf);

		/*
		 *  rx63nsci_rcv_chr() ˤ RDR ɤ߽Фػߤ롥
		 */
		siopcb->getready = FALSE;
	}
}

void	rx63nsci_isr_txi(ID siopid)
{
	SIOPCB	*siopcb = &siopcb_table[(UINT)(siopid - 1)];

	if (siopcb->openflag) {
		/*
		 *  rx63nsci_snd_chr() ˤ TDR ؤν񤭹ߤϡ
		 *  TXI ߥϥɥǤΤߵĤ롥
		 */
		siopcb->putready = TRUE;

		/*
		 *  ǽХå롼ƤӽФ
		 */
		rx63nsci_ierdy_snd(siopcb->exinf);

		/*
		 *  rx63nsci_snd_chr() ˤ TDR ؤν񤭹ߤػߤ롥
		 */
		siopcb->putready = FALSE;
	}
}

void	rx63nsci_isr_tei(ID siopid)
{
	const SIOPINIB	*siopinib = &siopinib_table[(UINT)(siopid - 1)];
	SIOPCB	*siopcb = &siopcb_table[(UINT)(siopid - 1)];
	UB scr;

	if (siopcb->openflag) {
		/*
		 *  öTETIETEIE򥯥ꥢ塢
		 *  ɬפ˱ƥåȤʤ
		 */
		scr = sil_reb_mem(siopinib->scr);
		sil_wrb_mem(siopinib->scr, scr & ~0xa4);
		if (scr & 0x80)
			sil_wrb_mem(siopinib->scr, scr | 0xa0);
	}
}

void	rx63nsci_isr_eri(void)
{
	const SIOPINIB	*siopinib;
	UB ssr;
	UW grp12;
	ID siopid;

	grp12 = sil_rew_mem((VP) RX63N_GRP12);
	for (siopid = 1; siopid <= TNUM_SIOP; siopid++) {
		siopinib = &siopinib_table[(UINT)(siopid - 1)];

		if (!(grp12 & (0x00000001 << siopinib->ch)))
			continue;

		ssr = sil_reb_mem(siopinib->ssr);
		if (ssr & 0x20) {
			/* Х󥨥顼򥯥ꥢ */
			(void)sil_reb_mem(siopinib->rdr);
		}
		/* SSR 顼򥯥ꥢ */
		sil_wrb_mem(siopinib->ssr, (ssr & ~0x38) | 0xc0);
		while ((sil_reb_mem(siopinib->ssr) & 0x38) != 0x00) ;
		while ((sil_rew_mem((VP) RX63N_GRP12) & 0x01) != 0x00) ;
	}
}
