/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.c,v 1.5 2015/06/28 16:47:12 ssuzuki Exp $
 */

/*
 *	åȥƥ¸⥸塼GR-SAKURAѡ
 */

#include <s_services.h>
#include "jsp_kernel.h"
#include "rx63n.h"
#include "rx63nsci.h"

/*
 *  åȥƥ¸ 롼
 */
void
sys_initialize()
{
	UW prcr_bak;

	/* MSTPCRB 쥸ؤν񤭹ߤĤ */
	prcr_bak = sil_reh_mem((VP) RX63N_PRCR) & 0x00ff;
	sil_wrh_mem((VP) RX63N_PRCR, 0xa502 | prcr_bak);

	/* SCIn Υȥå׾֤β */
	sil_wrw_mem((VP) RX63N_MSTPCRB,
			sil_rew_mem((VP) RX63N_MSTPCRB) & ~(1 << 31));

	/* PFS 쥸ؤν񤭹ߤĤ */
	sil_wrb_mem((VP) RX63N_PWPR, sil_reb_mem((VP) RX63N_PWPR) & ~0x80);
	sil_wrb_mem((VP) RX63N_PWPR, sil_reb_mem((VP) RX63N_PWPR) | 0x40);

	/* üҤ TXDn  RXDn ȤƻѤ */
	sil_wrb_mem((VP) RX63N_P21PFS, 0x0a);
	sil_wrb_mem((VP) RX63N_P20PFS, 0x0a);

	/* PFS 쥸ؤν񤭹ߤػߤ */
	sil_wrb_mem((VP) RX63N_PWPR, sil_reb_mem((VP) RX63N_PWPR) | 0x80);
	sil_wrb_mem((VP) RX63N_PWPR, sil_reb_mem((VP) RX63N_PWPR) & ~0x40);

	/* PRCR.PRC1 ͤ򸵤᤹ */
	sil_wrh_mem((VP) RX63N_PRCR, 0xa500 | prcr_bak);

	/* üҤյǽȤƻѤ */
	sil_wrb_mem((VP) RX63N_PORT2_PMR,
			sil_reb_mem((VP) RX63N_PORT2_PMR) | (0x01 << 1));
	sil_wrb_mem((VP) RX63N_PORT2_PMR,
			sil_reb_mem((VP) RX63N_PORT2_PMR) | (0x01 << 0));

	/*
	 *  ХʡɽѥꥢݡȤν
	 */
	rx63nsci_initialize();
	rx63nsci_opn_por(1, NULL);
}


/*
 *  åȥƥνλ
 */
void
sys_exit()
{
	while (1) ;
}


/*
 *  åȥƥʸ
 */
void
sys_putc(char c)
{
	if (c == '\n') {
		rx63nsci_snd_chr_pol(LOGTASK_PORTID, '\r');
	}
	rx63nsci_snd_chr_pol(LOGTASK_PORTID, c);
}
