/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.c,v 1.2 2015/06/26 16:01:47 ssuzuki Exp $
 */

/*
 *	ץå¸⥸塼RXѡ
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/*
 *  ƥȤǤγߥޥ
 */
#ifdef SUPPORT_CHG_IPM
UW	task_intmask;
#endif /* SUPPORT_CHG_IPM */

/*
 *  ߥͥȥ
 */
UB intnest = 0;

/*
 *  ץå¸ν
 */
void
cpu_initialize()
{
	/*
	 *  ƥȤǤγߥޥν
	 */
#ifdef SUPPORT_CHG_IPM
	task_intmask = 0x0000;
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  ץå¸νλ
 */
void
cpu_terminate()
{
}

#ifdef SUPPORT_CHG_IPM

/*
 *  ߥޥѹ
 *
 *  chg_ipm Ȥä IPM  15ʤ٤Ƥγߤػߡˤѹ
 *  뤳ȤϤǤʤNMI ʳΤ٤Ƥγߤػߤˤϡ
 *  loc_cpu ˤCPUå֤ˤФ褤
 *  IPM  0 ʳλˤ⡤ǥѥåαʤIPM ϡ
 *  ǥѥåˤäơ¹Ծ֤ˤʤäذѤ
 *  롥Τᡤ¹ˡ̤Υˤä IPM ѹ
 *  礬롥JSPͥǤϡIPM ѹϥ㳰롼
 *  ˤäƤⵯΤǡ̤Υˤä IPM ѹ뤳Ȥ
 *  äơ񤷤ʤϾʤȻפ롥IPM ͤˤäƥ
 *  ǥѥåػߤˤϡdis_dsp ʻѤФ褤
 */
SYSCALL ER
chg_ipm(IPM ipm)
{
	ER	ercd;

	LOG_CHG_IPM_ENTER(ipm);
	CHECK_TSKCTX_UNL();
	CHECK_PAR(0 <= ipm && ipm <= 14);

	t_lock_cpu();
	task_intmask = (ipm << 24);
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_CHG_IPM_LEAVE(ercd);
	return(ercd);
}

/*
 *  ߥޥλ
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
	ER	ercd;

	LOG_GET_IPM_ENTER(p_ipm);
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	*p_ipm = (task_intmask >> 24);
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_GET_IPM_LEAVE(ercd, *p_ipm);
	return(ercd);
}

#endif /* SUPPORT_CHG_IPM */

/*****ʲȤΥ󥿡ե˴ޤޤʤʬ*********/

/*
 * ̤ȯΥ顼
 * ϿƤʤߤȯȸƤӽФ
 * 
 * å¤
 * +0:acc
 * +8:r1
 *+12:r2
 *+16:r3
 *+20:r4
 *+24:r5
 *+28:r6
 *+32:r7
 *+36:r8
 *+40:r9
 *+44:r10
 *+48:r11
 *+52:r12
 *+56:r13
 *+60:r14
 *+64:r15
 *+68:pc
 *+72:psw
 *+76:˻ѤƤåΰ
 */

/*
 * ȯľΥåݥ󥿤ޤǤΥեå
 */
#define OFFSET_SP	76u

void cpu_experr(EXCSTACK *sp)
{
    syslog(LOG_EMERG, "Unexpected interrupt.");
    syslog(LOG_EMERG, "PC = 0x%08x SP = 0x%08x PSW  = 0x%08x",
                       sp->pc, (UW)sp + OFFSET_SP, sp->psw);
    syslog(LOG_EMERG, "ACC = 0x%08x%08x",
                       sp->acchi, sp->acclo);
    syslog(LOG_EMERG, "R1 = 0x%08x R2 = 0x%08x R3 = 0x%08x R4 = 0x%08x",
                       sp->r1, sp->r2, sp->r3, sp->r4);
    syslog(LOG_EMERG, "R5 = 0x%08x R6 = 0x%08x R7 = 0x%08x R8 = 0x%08x",
                       sp->r5, sp->r6, sp->r7, sp->r8);
    syslog(LOG_EMERG, "R9 = 0x%08x R10 = 0x%08x R11 = 0x%08x R12 = 0x%08x",
                       sp->r9, sp->r10, sp->r11, sp->r12);
    syslog(LOG_EMERG, "R13 = 0x%08x R14 = 0x%08x R15 = 0x%08x",
                       sp->r13, sp->r14, sp->r15);
    while(1)
    	;
}
