/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _MIPS3_SIL_H_
#define _MIPS3_SIL_H_

#include <kz_vr4131pci_01.h>	/* VR4131_BASE_ADDR */

#ifndef _MACRO_ONLY
#include <sil.h>
#endif /* _MACRO_ONLY */

/*
 *  VR4131Ѱ̥󥿥ե
 */
#define vr4131_reb_mem(x)	sil_reb_mem( (VP)(VR4131_BASE_ADDR + x) )
#define vr4131_wrb_mem(x, y)	sil_wrb_mem( (VP)(VR4131_BASE_ADDR + x), y )

#define vr4131_reh_mem(x)	sil_reh_mem( (VP)(VR4131_BASE_ADDR + x) )
#define vr4131_wrh_mem(x, y)	sil_wrh_mem( (VP)(VR4131_BASE_ADDR + x), y )

/* ֥ SIL */
#define ASM_SIL(x)	(VR4131_BASE_ADDR + x)

/*
 *  VR4131Ѱ̥쥸ؿ
 */
#define vr4131_orb( mem, val )	vr4131_wrb_mem( mem, vr4131_reb_mem( mem ) | val )
#define vr4131_andb( mem, val )	vr4131_wrb_mem( mem, vr4131_reb_mem( mem ) & val )

#define vr4131_orh( mem, val )	vr4131_wrh_mem( mem, vr4131_reh_mem( mem ) | val )
#define vr4131_andh( mem, val )	vr4131_wrh_mem( mem, vr4131_reh_mem( mem ) & val )

#endif /* _MIPS3_SIL_H_ */
