/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2002 by Monami software, Limited Partners.
 *  Copyright (C) 2002 by MURANAKA Masaki
 *  Copyright (C) 2008-     by Monami Software Limited Partnership, JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id: sys_config.h,v 1.1 2004/07/21 02:49:37 monaka Exp $
 */

/*
 *	åȥƥ¸⥸塼PC/ATѡ
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <sys_rename.h>

/*
 *  ưåΥåȥƥ̾
 */
#define	TARGET_NAME	"IA-32(PC/AT)"

/*
 *  vxget_tim 򥵥ݡȤ뤫ɤ
 */
#if 0
#define	SUPPORT_VXGET_TIM
#endif

/*
 * 󥿥ƥѤΥåν
 */
#define	STACKTOP	$(stack + STACKSIZE)
#define	STACKSIZE	8192

/*
 *  ꥢݡȿ
 */
#define TNUM_PORT	2	/* ݡȤ륷ꥢݡȤο */
#define	TNUM_SIOP	2	/* ݡȤ륷ꥢI/OݡȤο */

/*
 *  ꥢݡֹ˴ؤ
 */
#ifndef LOGTASK_PORTID
#define	LOGTASK_PORTID	1	/* ƥѤ륷ꥢݡֹ */
#endif


#define PIT_INHNO 0x20

#define PCAT_COM1_INHNO 0x24
#define PCAT_COM2_INHNO 0x23
#define PCAT_COM1_BASE (0x03F8)
#define PCAT_COM2_BASE (0x02F8)

#define	IRQ0_VECTOR	0x20
#define	IRQ8_VECTOR	0x28
#define	IRQ_VECTOR(x)	(IRQ0_VECTOR + (x))

#define TO_INTNO(a) ((a) - 0x20)

#ifndef _MACRO_ONLY

/*
 *  åȥƥ¸ν
 */
extern void	sys_initialize(void);

/*
 *  åȥƥνλ
 */
extern void	sys_exit(void);

/*
 *  åȥƥʸ
 */
extern void	sys_putc(char c);

/*
 *  ߥϥɥ
 */

/*
 *  ߥϥɥνsys_support.S
 */
extern void interrupt0(void);
extern void interrupt1(void);
extern void interrupt2(void);
extern void interrupt3(void);
extern void interrupt4(void);
extern void interrupt5(void);
extern void interrupt6(void);
extern void interrupt7(void);
extern void interrupt8(void);
extern void interrupt9(void);
extern void interrupt10(void);
extern void interrupt11(void);
extern void interrupt12(void);
extern void interrupt13(void);
extern void interrupt14(void);
extern void interrupt15(void);

/*
 *  ߥϥɥΥơ֥sys_config.c
 *
 *  ߥϥɥϰöΥơ֥Ͽ졢̤Ѱդ줿
 *  ƤӽФ
 */
extern FP int_table[0x10];

/*
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 */
extern void define_inh(INHNO inhno, FP inthdr);

/*
 *  ߥϥɥν
 */

/*
 *  ߥϥɥνޥ
 */

#define INTHDR_ENTRY(inthdr) extern void inthdr(void)

#define INT_ENTRY(inthdr) inthdr

#endif /* _MACRO_ONLY */
#endif /* _SYS_CONFIG_H_ */
