/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2002 by Monami software, Limited Partners.
 *  Copyright (C) 2002 by MURANAKA Masaki
 *  Copyright (C) 2008-     by Monami Software Limited Partnership, JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2004/07/21 02:49:36 monaka Exp $
 */

/*
 *	åȰ¸ޥ⥸塼PC/ATѡ
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <irc.h>

/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define	INHNO_TIMER	PIT_INHNO

#ifndef _MACRO_ONLY

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
  	static const int count = (UD)14318180 * TIC_NUME / 12 / 1000 / TIC_DENO;
	assert(2 <= count && count <= 0x10000);
	sil_wrb_iop((VP)0x43, 0x34);
	sil_wrb_iop((VP)0x40, count & 0xff);
	sil_wrb_iop((VP)0x40, count >> 8);

	irc_ena_irq(TO_INTNO(PIT_INHNO));
}

/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
hw_timer_terminate()
{
	irc_dis_irq(TO_INTNO(PIT_INHNO));
}

#endif /* _MACRO_ONLY */

#endif /* _HW_TIMER_H_ */
