/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

/*
 *  ץå˰¸H8Sѡ
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥
 *  롼ɤˡt_stddef.h  itron.h 󥯥롼ɤΤǡ
 *  ˰¸Ƥ褤
 */

#define H8S

/*
 *  ١ɥ쥹
 */
#ifndef H8S_NORMAL_MODE
#define H8S_BASE_ADDR	0xff0000	/* ɥХ󥹥ɥ⡼ */
#else /* H8S_NORMAL_MODE */
#define H8S_BASE_ADDR	0x000000	/* Ρޥ⡼ */
#endif /* H8S_NORMAL_MODE */

/* ͥ뵯ưΥå */
#define COPYRIGHT_CPU \
"Copyright (C) 2001-2004 by Industrial Technology Institute,\n" \
"                            Miyagi Prefectural Government, JAPAN\n" \
"Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering,\n" \
"                 Tomakomai National College of Technology, JAPAN\n"

#ifndef _MACRO_ONLY

/*
 *  ߡCPU㳰ϥɥֹη
 */
typedef	UINT	INHNO;			/* ߥϥɥֹ */
typedef	UINT	EXCNO;			/* CPU㳰ϥɥֹ */

/*
 *  ߥޥηȳߥޥѹ
 */

/* ߥޥη */
typedef	UB	IPM;			/* ߥޥ */

/* ߥޥѤδؿ */
extern ER	chg_ipm(IPM ipm) throw();	/* ߥޥѹ */
extern ER	get_ipm(IPM *p_ipm) throw();	/* ߥޥμ */

#if 0		/*  ǤϥݡȤƤʤ  */
/*
 *  INTNOȳߤζػ/
 */
typedef	UINT	INTNO;			/* ֹ */

extern ER	dis_int(INTNO intno) throw();
extern ER	ena_int(INTNO intno) throw();
#endif

#endif /* _MACRO_ONLY */

/*
 *  ߥå֤
 */
#define	SIL_PRE_LOC	IPM _intmask_ = current_intmask()
#define	SIL_LOC_INT()	_disint_()
#define	SIL_UNL_INT()	set_intmask(_intmask_)

/*
 *  ץåΥǥ
 */
#define	SIL_ENDIAN	SIL_ENDIAN_BIG		/* ӥåǥ */

#endif /* _CPU_DEFS_H_ */
