/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: cpu_defs.h,v 1.7 2007/03/23 07:58:33 honda Exp $
 */

/*
 *      ץå˰¸H8ѡ
 *ץꥱɬפȤ
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥
 *  롼ɤˡt_stddef.h  itron.h 󥯥롼ɤΤǡ
 *  ˰¸Ƥ褤
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

/*
 *  桼
 */
#include <user_config.h>        /*  SUPPORT_VXGET_TIMޥ  */

#include <h8.h>

#define H8

/* ͥ뵯ưΥå */
#define COPYRIGHT_CPU \
"Copyright (C) 2001-2007 by Industrial Technology Institute,\n" \
"                            Miyagi Prefectural Government, JAPAN\n" \
"Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering,\n" \
"                 Tomakomai National College of Technology, JAPAN\n"

/*
 *  CPU ΥХȽ˴ؤ
 */

#define SIL_ENDIAN              SIL_ENDIAN_BIG

#ifndef _MACRO_ONLY

typedef UINT    INHNO;                  /* ߥϥɥֹ */
typedef UINT    EXCNO;                  /* CPU㳰ϥɥֹ */

/*
 *  åȥƥ¸Υӥ
 */

/*
 *  ߥޥηȳߥޥѹ
 */
typedef UB              IPM;            /* ߥޥ */

#endif /* _MACRO_ONLY */
/*
 *  ٥룰٤Ƥγߤդ
 */
#define IPM_LEVEL0      0u

/*
 *  ٥룱NMIӥץ饤ƥ٥룱γߤΤߤդ
 */
#define IPM_LEVEL1      CCR_I

/*
 *  ٥룲NMIʳγߤդʤ
 */
#define IPM_LEVEL2      (CCR_I | CCR_UI)

#ifndef _MACRO_ONLY

#ifdef SUPPORT_CHG_IPM
extern ER       chg_ipm(IPM ipm) throw();
extern ER       get_ipm(IPM *p_ipm) throw();
#endif  /*  SUPPORT_CHG_IPM  */


/*
 *  ץ饤ƥ٥ѤΥǡ¤
 */
typedef struct {
        UB *ipr;        /* ꤹIPR쥸 */
        UB bit;         /* IPR쥸γӥåֹ */
        IPM ipm;        /* ꤹߥ٥ */
                        /* IPM_LEVEL0,IPM_LEVEL1Τ줫 */
} IRC;                  /* IRC:Interrupt Request Controller */


/*
 *  ǽɾѥƥ¬ǽ
 */
#ifdef SUPPORT_VXGET_TIM

typedef UW  SYSUTIM;    /* ǽɾѥƥ */

extern ER   vxget_tim(SYSUTIM *pk_sysutim) throw();

#endif  /*  SUPPORT_VXGET_TIM  */

/*
 *  ƥǽ
 */
Inline void
kernel_abort(void)
{
        while (1) {}
}

/*
 * Ԥ
 * ջࡧ
 * ɸǤdlytimUINT16ӥåȤʤΤǡ
 * UWѹƤ롣
 * sil_dly_nse()sil_dly_nse_long()ƤӽФ
 */
extern void sil_dly_nse_long(UW dlytim) throw();


/*
 *  ǥȿž
 */
#define	SIL_REV_ENDIAN_H(data) \
	((VH)((((UH)(data) & 0xff) << 8) | (((UH)(data) >> 8) & 0xff)))

#define	SIL_REV_ENDIAN_W(data) \
	((VW)((((UW)(data) & 0xff) << 24) | (((UW)(data) & 0xff00) << 8) \
		| (((UW)(data)>> 8) & 0xff00) | (((UW)(data) >> 24) & 0xff)))

/*
 *  ֥ؿ
 *  
 *  ѥηٹ򤹤뤿ᡢ¸ǥؿѰդ롣
 *  Ƥjsp/include/sil.hȤޤäƱ
 *  ֤Թ塢嵭Ρ֥ǥȿžפ֤äƤ롣
 */
#define OMIT_SIL_ACCESS

/*
 *  8ӥåñ̤ɽФ
 */
Inline VB
sil_reb_mem(VP mem)
{
	VB data = *((volatile VB *) mem);
	return(data);
}

Inline void
sil_wrb_mem(VP mem, VB data)
{
	*((volatile VB *) mem) = data;
}

/*
 *  16ӥåñ̤ɽФ
 */
Inline VH
sil_reh_mem(VP mem)
{
	VH data = *((volatile VH *) mem);
	return(data);
}

Inline void
sil_wrh_mem(VP mem, VH data)
{
	*((volatile VH *) mem) = data;
}

#define	sil_reh_bem(mem)	sil_reh_mem(mem)
#define	sil_wrh_bem(mem, data)	sil_wrh_mem(mem, data)

Inline VH
sil_reh_lem(VP mem)
{
	VH data = *((volatile VH *) mem);
	return(SIL_REV_ENDIAN_H(data));
}

Inline void
sil_wrh_lem(VP mem, VH data)
{
	*((volatile VH *) mem) = SIL_REV_ENDIAN_H(data);
}

/*
 *  32ӥåñ̤ɽФ
 */
Inline VW
sil_rew_mem(VP mem)
{
	VW data = *((volatile VW *) mem);
	return(data);
}

Inline void
sil_wrw_mem(VP mem, VW data)
{
	*((volatile VW *) mem) = data;
}

#define	sil_rew_bem(mem)	sil_rew_mem(mem)
#define	sil_wrw_bem(mem, data)	sil_wrw_mem(mem, data)

Inline VW
sil_rew_lem(VP mem)
{
	VW data= *((volatile VW *) mem);
	return(SIL_REV_ENDIAN_W(data));
}

Inline void
sil_wrw_lem(VP mem, VW data)
{
	*((volatile VW *) mem) = SIL_REV_ENDIAN_W(data);
}

#endif /* _MACRO_ONLY */

#endif /* _CPU_DEFS_H_ */
