/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2007 by KURUSUGAWA Electronics Technology Inc
 *  Copyright (C) 2008 by Takahisa Yokota
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_serial.h,v 1.9 2003/07/08 14:57:15 hiro Exp $
 */

/*
 *	ꥢI/OǥХSIO/MCFUART)ɥ饤СM52235EVBѡ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>

#ifndef _MACRO_ONLY
#include "mcfuart.h"

/* ϥݡȤsys_config.c */
/* ߥ٥ֹhw_serial.h */
/* ֥åmcfuart.c */

#ifndef GDB_STUB

#define INHNO_SERIAL	 MCF_UART0
#if TNUM_PORT >= 2
#define INHNO_SERIAL2	 MCF_UART1
#endif /* TNUM_PORT >= 2 */

#else	/*  GDB_STUB  */

#define INHNO_SERIAL	 MCF_UART0

#endif	/*  GDB_STUB  */

/*
 *  SIOɥ饤Фν롼
 */
#define	sio_initialize	mcfuart_initialize

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

        /*
	 *  ץ󤷤ݡȤ뤫 openflag ɤǤ
	 */
	openflag = mcfuart_openflag(siopid);

	/*
	 *  ǥХ¸Υץ
	 */
	siopcb = mcfuart_opn_por(siopid, exinf);

	/*
	 *  ꥢI/Oߤγߥ٥ꤷޥ롥
	 */
	if (!openflag) {
            if (siopcb->siopinib->reg_base == (IPSBAR + 0x00000200)) {
                sil_wrb_mem (MCF_INTC_ICR(MCF_INTC0, 13), siopcb->siopinib->int_level);
            } else if (siopcb->siopinib->reg_base == (IPSBAR + 0x00000240)) {
                sil_wrb_mem (MCF_INTC_ICR(MCF_INTC0, 14), siopcb->siopinib->int_level);
            }
        }
	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  ǥХ¸Υ
	 */
	mcfuart_cls_por(siopcb);

	/*
	 *  ꥢI/Oߤޥ롥
	 */
        if (siopcb->siopinib->reg_base == (IPSBAR + 0x00000200)) {
          sil_wrb_mem (MCF_INTC_ICR(MCF_INTC0, 13), 0);
        } else if (siopcb->siopinib->reg_base == (IPSBAR + 0x00000240)) {
          sil_wrb_mem (MCF_INTC_ICR(MCF_INTC0, 14), 0);
        }
}

/*
 *  SIOγߥϥɥ
 */
#define	sio_handler	mcfuart_isr
#if TNUM_PORT >= 2
#define	sio_handler2	mcfuart_isr2
#endif /* TNUM_PORT >= 2 */

/*
 *  ꥢI/OݡȤؤʸ
 */
#define	sio_snd_chr	mcfuart_snd_chr

/*
 *  ꥢI/OݡȤʸ
 */
#define	sio_rcv_chr	mcfuart_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define	sio_ena_cbr	mcfuart_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define	sio_dis_cbr	mcfuart_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 */
#define	sio_ierdy_snd	mcfuart_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 */
#define	sio_ierdy_rcv	mcfuart_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
