/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2006 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2006 by Logic Research Co., Ltd.
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 *  CPU¸ޥ⥸塼FRK_ADuCѡ
 *  TIMER1(41.78MHz)
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include "frk_aduc.h"


/*
 *  ޳ߤγֹ
 */
#define    INHNO_TIMER    IRQ_TIM1_BIT

#ifndef _MACRO_ONLY


/*
 *  ͤɽη
 */
typedef UW    CLOCK;


/*
 *  ͤɽȥߥáñ̤ȤѴ
 *  TIMER_CLOCK ϥåȥܡ
 */
#define TO_CLOCK(nume, deno) (TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)       ((clock) * 1000 / TIMER_CLOCK)

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define MAX_CLOCK    ((CLOCK) 0xffffffff)
/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define GET_TOLERANCE    100
#define BEFORE_IREQ(clock) \
        ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)


/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
    CLOCK    cyc = TO_CLOCK(TIC_NUME, TIC_DENO);
        
    /*
     *  ޴Ϣ
     */
    /*  */
    sil_wrw_mem((VP)T1CON, 0);
    /* ޾ͤΥå */
    assert(cyc <= MAX_CLOCK);       
    /* ߤΥꥢ  */
    sil_wrw_mem((VP)T1CLRI, 0x01);
    /* ͤ򥻥å */
    sil_wrw_mem((VP)T1LD,cyc);
    /* ȥ   */
    sil_wrw_mem((VP)T1CON, (T1CON_CLS_CORE|T1CON_ENA|
							T1CON_MOD|T1CON_FMT_BIN|T1CON_PSC_1));
    /* ߵ */        
    sil_wrw_mem((VP)IRQEN, IRQ_TIMER1);
}


/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
  sil_wrw_mem((VP)T1CLRI, 0x01);
}


/*
 *  ޤ߽
 */
Inline void
hw_timer_terminate()
{
    /* ڥǥ󥰥ӥåȤ򥯥ꥢ */
    sil_wrw_mem((VP)T1CLRI, 0x01);    
    /*  */
    sil_wrw_mem((VP)T1CON, (sil_rew_mem((VP)T1CON)&~T1CON_ENA));
    /* Ե*/
    sil_wrw_mem((VP)IRQEN, (sil_rew_mem((VP)IRQEN)&~IRQ_TIMER1));
}


/*
 *  ޤθͤɤߤ
 *
 *  ߶ػ߶ǸƤӽФȡ
 */
Inline CLOCK
hw_timer_get_current(void)
{
    return(TO_CLOCK(TIC_NUME, TIC_DENO) - sil_rew_mem((VP)T1VAL));
}


/*
 * ޳ߤȯƤ뤫Ƚ
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
    return(sil_rew_mem((VP)IRQSTA) & IRQ_TIMER1);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */

