/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.util.ConnectionDialog;

public class Transfer
extends Applet
implements WindowListener,
ActionListener,
ItemListener {
    Connection cSource;
    Connection cTarget;
    DatabaseMetaData dSourceMeta;
    DatabaseMetaData dTargetMeta;
    Statement sSourceStatement;
    Frame fMain;
    Image imgEmpty;
    Table tCurrent;
    int iMaxRows;
    int iSelectionStep;
    Vector tTable;
    List lTable;
    String sDatabaseToConvert;
    String[] sSchemas;
    TextField tSourceTable;
    TextField tDestTable;
    TextField tDestDropIndex;
    TextField tDestCreateIndex;
    TextField tDestDrop;
    TextField tDestCreate;
    TextField tDestDelete;
    TextField tDestAlter;
    TextField tSourceSelect;
    TextField tDestInsert;
    Checkbox cTransfer;
    Checkbox cDrop;
    Checkbox cCreate;
    Checkbox cDelete;
    Checkbox cInsert;
    Checkbox cAlter;
    Checkbox cCreateIndex;
    Checkbox cDropIndex;
    Checkbox cFKForced;
    Checkbox cIdxForced;
    Button bStart;
    Button bContinue;
    Hashtable hTypes;
    TextField tMessage;
    static boolean bMustExit;
    int CurrentTransfer;
    int CurrentAlter;
    String SrcDriverName;
    String DestDriverName;
    String quote;
    final int SELECT_SCHEMA = 1;
    final int SELECT_TABLES = 2;
    String sLast;

    public void init() {
        Transfer transfer = new Transfer();
        transfer.main();
    }

    public static void work() {
        Transfer transfer = new Transfer();
        transfer.main();
    }

    public static void main(String[] stringArray) {
        bMustExit = true;
        Transfer.work();
    }

    boolean SchemaToSelect() {
        try {
            this.lTable.removeAll();
            ResultSet resultSet = this.dSourceMeta.getSchemas();
            this.lTable.setMultipleMode(true);
            this.bStart.setLabel("Start Parsing");
            this.bStart.invalidate();
            this.bStart.setEnabled(true);
            while (resultSet.next()) {
                this.lTable.add(resultSet.getString(1));
            }
            resultSet.close();
            this.lTable.repaint();
            this.trace("Select correct Schema or load Settings file");
        }
        catch (SQLException sQLException) {
            this.lTable.removeAll();
            this.trace("SQL Exception reading Metadata: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        return this.lTable.getItemCount() > 0;
    }

    void main() {
        this.fMain = new Frame("Hypersonic Transfer Tool");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        this.fMain.setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        ((Component)this.fMain).setSize(640, 480);
        this.fMain.add("Center", this);
        MenuBar menuBar = new MenuBar();
        String[] stringArray = new String[]{"Insert 10 rows only", "Insert 1000 rows only", "Insert all rows", "-", "Load Settings...", "Save Settings...", "-", "Exit"};
        Menu menu = new Menu("Options");
        this.addMenuItems(menu, stringArray);
        menuBar.add(menu);
        this.fMain.setMenuBar(menuBar);
        this.initGUI();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fMain.getSize();
        ((Component)this.fMain).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)this.fMain).setVisible(true);
        this.CurrentAlter = 0;
        this.CurrentTransfer = 0;
        this.cSource = ConnectionDialog.createConnection(this.fMain, "Source Database");
        if (this.cSource == null) {
            return;
        }
        try {
            this.dSourceMeta = this.cSource.getMetaData();
            this.sSourceStatement = this.cSource.createStatement();
            this.sDatabaseToConvert = this.cSource.getCatalog();
            this.SrcDriverName = this.dSourceMeta.getDriverName();
        }
        catch (Exception exception) {
            this.trace(exception.toString());
            exception.printStackTrace();
        }
        this.cTarget = ConnectionDialog.createConnection(this.fMain, "Target Database");
        if (this.cTarget == null) {
            return;
        }
        try {
            this.dTargetMeta = this.cTarget.getMetaData();
            this.DestDriverName = this.dTargetMeta.getDriverName();
            this.quote = this.dTargetMeta.getIdentifierQuoteString();
        }
        catch (Exception exception) {
            this.trace(exception.toString());
            exception.printStackTrace();
        }
        this.iSelectionStep = 1;
        this.sSchemas = null;
        if (this.SchemaToSelect()) {
            this.fMain.show();
            return;
        }
        this.lTable.removeAll();
        this.lTable.repaint();
        this.RefreshMainDisplay();
        this.iSelectionStep = 2;
    }

    void InithTypes() {
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        hashtable.put(new Integer(-5), "BIGINT");
        hashtable.put(new Integer(-2), "BINARY");
        hashtable.put(new Integer(-7), "BIT");
        hashtable.put(new Integer(2003), "ARRAY");
        hashtable.put(new Integer(2004), "BLOB");
        hashtable.put(new Integer(2005), "CLOB");
        hashtable.put(new Integer(2001), "DISTINCT");
        hashtable.put(new Integer(2000), "JAVA_OBJECT");
        hashtable.put(new Integer(2006), "REF");
        hashtable.put(new Integer(2002), "STRUCT");
        hashtable.put(new Integer(1), "CHAR");
        hashtable.put(new Integer(91), "DATE");
        hashtable.put(new Integer(3), "DECIMAL");
        hashtable.put(new Integer(8), "DOUBLE");
        hashtable.put(new Integer(6), "FLOAT");
        hashtable.put(new Integer(4), "INTEGER");
        hashtable.put(new Integer(-4), "LONGVARBINARY");
        hashtable.put(new Integer(-1), "LONGVARCHAR");
        hashtable.put(new Integer(0), "NULL");
        hashtable.put(new Integer(2), "NUMERIC");
        hashtable.put(new Integer(1111), "OTHER");
        hashtable.put(new Integer(7), "REAL");
        hashtable.put(new Integer(5), "SMALLINT");
        hashtable.put(new Integer(92), "TIME");
        hashtable.put(new Integer(93), "TIMESTAMP");
        hashtable.put(new Integer(-6), "TINYINT");
        hashtable.put(new Integer(-3), "VARBINARY");
        hashtable.put(new Integer(12), "VARCHAR");
        try {
            this.hTypes = new Hashtable();
            this.trace("Building target type info");
            ResultSet resultSet = this.dTargetMeta.getTypeInfo();
            while (resultSet.next()) {
                Integer n = new Integer(resultSet.getShort(2));
                if (this.hTypes.get(n) != null) continue;
                this.hTypes.put(n, hashtable.get(n));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            this.trace("SQL Exception reading Metadata: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
    }

    String FormatIdentifier(String string) {
        if (string == null) {
            return string;
        }
        if (string.equals("")) {
            return string;
        }
        char c = string.charAt(0);
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            return string;
        }
        return this.quote + string + this.quote;
    }

    void GetTableStructure(Table table) {
        try {
            String string = "CREATE TABLE " + this.FormatIdentifier(table.sSourceTable) + "(";
            String string2 = "INSERT INTO " + this.FormatIdentifier(table.sSourceTable) + " VALUES(";
            ResultSet resultSet = this.dSourceMeta.getImportedKeys(this.sDatabaseToConvert, table.sSchema, table.sSourceTable);
            boolean bl = false;
            String string3 = new String("");
            String string4 = new String("");
            String string5 = new String("");
            String string6 = new String("");
            String string7 = new String("");
            String string8 = new String("");
            while (resultSet.next()) {
                bl = true;
                if (!resultSet.getString(12).equals(string5)) {
                    if (!string5.equals("")) {
                        string3 = string3 + string8.substring(0, string8.length() - 1) + ") REFERENCES " + string6;
                        if (string7.length() > 0) {
                            string3 = string3 + " (" + string7.substring(0, string7.length() - 1) + ")";
                        }
                        string3 = string3 + ";";
                        string4 = string4.substring(0, string4.length() - 1) + ";";
                        string7 = "";
                        string8 = "";
                    }
                    string6 = resultSet.getString(3);
                    string5 = resultSet.getString(12);
                    string3 = string3 + "ALTER TABLE " + this.FormatIdentifier(table.sSourceTable) + " ADD CONSTRAINT ";
                    string3 = table.bFKForced && !string5.startsWith("FK_") ? string3 + "FK_" + string5 + " " : string3 + this.FormatIdentifier(string5) + " ";
                    string3 = string3 + "FOREIGN KEY (";
                    string4 = string4 + "ALTER TABLE " + this.FormatIdentifier(table.sSourceTable) + " DROP CONSTRAINT ";
                    string4 = table.bFKForced && !string5.startsWith("FK_") ? string4 + "FK_" + string5 + " " : string4 + this.FormatIdentifier(string5) + " ";
                }
                string8 = string8 + resultSet.getString(8) + ",";
                string7 = string7 + resultSet.getString(4) + ",";
            }
            resultSet.close();
            if (bl) {
                string3 = string3 + string8.substring(0, string8.length() - 1) + ") REFERENCES " + string6;
                if (string7.length() > 0) {
                    string3 = string3 + " (" + string7.substring(0, string7.length() - 1) + ")";
                }
                string3 = string3 + ";";
                string4 = string4.substring(0, string4.length() - 1) + ";";
                table.sDestDrop = string4 + table.sDestDrop;
            }
            boolean bl2 = false;
            String string9 = new String();
            string9 = "";
            ResultSet resultSet2 = this.dSourceMeta.getPrimaryKeys(this.sDatabaseToConvert, table.sSchema, table.sSourceTable);
            while (resultSet2.next()) {
                if (bl2) {
                    string9 = string9 + ", ";
                } else {
                    if (resultSet2.getString(6) != null) {
                        string9 = " CONSTRAINT " + this.FormatIdentifier(resultSet2.getString(6));
                    }
                    string9 = string9 + " PRIMARY KEY (";
                }
                string9 = string9 + this.FormatIdentifier(resultSet2.getString(4));
                bl2 = true;
            }
            resultSet2.close();
            if (bl2) {
                string9 = string9 + ") ";
            }
            boolean bl3 = false;
            ResultSet resultSet3 = this.dSourceMeta.getIndexInfo(this.sDatabaseToConvert, table.sSchema, table.sSourceTable, false, false);
            String string10 = new String("");
            String string11 = new String("");
            String string12 = new String("");
            while (resultSet3.next()) {
                if (!resultSet3.getString(6).equals(string10)) {
                    if (!string10.equals("")) {
                        string11 = string11.substring(0, string11.length() - 1) + ");";
                        string12 = string12 + ";";
                    }
                    string10 = resultSet3.getString(6);
                    string12 = string12 + "DROP INDEX ";
                    string12 = table.bIdxForced && !string10.startsWith("Idx_") ? string12 + "Idx_" + string10 : string12 + this.FormatIdentifier(string10);
                    string11 = string11 + "CREATE ";
                    if (!resultSet3.getBoolean(4)) {
                        string11 = string11 + "UNIQUE ";
                    }
                    string11 = string11 + "INDEX ";
                    string11 = table.bIdxForced && !string10.startsWith("Idx_") ? string11 + "Idx_" + string10 : string11 + this.FormatIdentifier(string10);
                    string11 = string11 + " ON " + this.FormatIdentifier(table.sSourceTable) + "(";
                }
                string11 = string11 + this.FormatIdentifier(resultSet3.getString(9)) + ",";
                bl3 = true;
            }
            resultSet3.close();
            if (bl3) {
                string11 = string11.substring(0, string11.length() - 1) + ");";
                string12 = string12 + ";";
            }
            Vector<Integer> vector = new Vector<Integer>();
            this.trace("Reading source columns for table " + table.sSourceTable);
            ResultSet resultSet4 = this.dSourceMeta.getColumns(this.sDatabaseToConvert, table.sSchema, table.sSourceTable, null);
            int n = 1;
            Statement statement = this.cSource.createStatement();
            ResultSet resultSet5 = statement.executeQuery("SELECT * FROM " + this.FormatIdentifier(table.sSourceTable));
            ResultSetMetaData resultSetMetaData = resultSet5.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            while (resultSet4.next()) {
                String string13 = this.FormatIdentifier(resultSet4.getString(4));
                int n3 = resultSet4.getShort(5);
                String string14 = resultSet4.getString(6);
                short s = resultSet4.getShort(7);
                String string15 = resultSet4.getString(13);
                boolean bl4 = resultSetMetaData.isNullable(n) == 0;
                boolean bl5 = resultSetMetaData.isAutoIncrement(n);
                int n4 = resultSetMetaData.getPrecision(n);
                int n5 = resultSetMetaData.getScale(n);
                ++n;
                if (n3 == 11 && string14.toUpperCase().equals("DATETIME")) {
                    this.trace("Converted DATETIME (type 11) to TIMESTAMP");
                    n3 = 93;
                } else if (n3 == -9 && string14.toUpperCase().equals("NVARCHAR")) {
                    this.trace("Converted NVARCHAR (type -9) to VARCHAR");
                    n3 = 12;
                } else if (n3 == -8 && string14.toUpperCase().equals("NCHAR")) {
                    this.trace("Converted NCHAR (type -8) to VARCHAR");
                    n3 = 12;
                } else if (n3 == -10 && string14.toUpperCase().equals("NTEXT")) {
                    this.trace("Converted NTEXT (type -10) to VARCHAR");
                    n3 = 12;
                } else if (n3 == -1 && string14.toUpperCase().equals("LONGTEXT")) {
                    this.trace("Converted LONGTEXT (type -1) to LONGVARCHAR");
                    n3 = -1;
                }
                if (n3 == 93 && this.SrcDriverName.indexOf("Informix") != -1) {
                    n3 = 92;
                    this.trace("Converted INFORMIX TIMESTAMP to TIME");
                } else if (n3 == 92 && this.SrcDriverName.indexOf("Informix") != -1) {
                    n3 = 93;
                    this.trace("Converted INFORMIX TIME to TIMESTAMP");
                }
                Integer n6 = new Integer(n3);
                String string16 = (String)this.hTypes.get(n6);
                if (string16 == null) {
                    if (n3 == 3 && this.DestDriverName.indexOf("PostgreSQL") != -1) {
                        n6 = null;
                        n3 = 2;
                        n6 = new Integer(2);
                        string16 = (String)this.hTypes.get(n6);
                        this.trace("Converted DECIMAL to NUMERIC");
                    } else {
                        string16 = string14;
                        this.trace("No mapping for type: " + string13 + " type: " + n3 + " source: " + string14);
                    }
                }
                if (n3 == 2) {
                    string16 = string16 + "(" + Integer.toString(n4);
                    if (n5 > 0) {
                        string16 = string16 + "," + Integer.toString(n5);
                    }
                    string16 = string16 + ")";
                } else if (n3 == 1) {
                    string16 = string16 + "(" + Integer.toString(s) + ")";
                } else if (bl5) {
                    string16 = " SERIAL ";
                    if (this.DestDriverName.indexOf("PostgreSQL") != -1) {
                        String string17 = new String("_" + resultSet4.getString(4) + "_seq");
                        int n7 = 31 - string17.length();
                        string17 = table.sDestTable.length() > n7 ? table.sDestTable.substring(0, n7) + string17 : table.sDestTable + string17;
                        String string18 = "DROP SEQUENCE " + string17 + ";";
                        table.sDestDrop = table.sDestDrop + string18;
                    }
                }
                if (bl4) {
                    string16 = string16 + " NOT NULL ";
                }
                if (string15 != null) {
                    if (n3 == 1 || n3 == -1) {
                        string15 = "\"" + string15 + "\"";
                    }
                    string16 = string16 + " DEFAULT " + string15;
                }
                vector.addElement(n6);
                string = string + string13 + " " + string16 + ",";
                string2 = string2 + "?,";
            }
            resultSet5.close();
            statement.close();
            resultSet4.close();
            if (bl2) {
                string = string + string9 + ",";
            }
            table.sDestCreate = string.substring(0, string.length() - 1) + ")";
            table.sDestInsert = string2.substring(0, string2.length() - 1) + ")";
            if (bl) {
                table.bAlter = true;
                table.sDestAlter = string3;
            } else {
                table.bAlter = false;
            }
            if (bl3) {
                table.bCreateIndex = true;
                table.bDropIndex = true;
                table.sDestCreateIndex = string11;
                table.sDestDropIndex = string12;
            } else {
                table.bCreateIndex = false;
                table.bDropIndex = false;
            }
            table.iColumnType = new int[vector.size()];
            int n8 = 0;
            while (n8 < vector.size()) {
                table.iColumnType[n8] = (Integer)vector.elementAt(n8);
                ++n8;
            }
        }
        catch (SQLException sQLException) {
            this.trace("SQL Exception reading Metadata: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
    }

    void RefreshMainDisplay() {
        String[] stringArray = new String[]{"TABLE"};
        this.lTable.removeAll();
        this.lTable.repaint();
        this.tTable = new Vector();
        this.InithTypes();
        try {
            Object object;
            this.trace("Reading source tables");
            int n = 0;
            int n2 = 1;
            if (this.sSchemas != null) {
                n2 = this.sSchemas.length;
            }
            int n3 = 0;
            while (n3 < n2) {
                ResultSet resultSet = this.sSchemas != null ? this.dSourceMeta.getTables(this.sDatabaseToConvert, this.sSchemas[n3], null, stringArray) : this.dSourceMeta.getTables(this.sDatabaseToConvert, null, null, stringArray);
                while (resultSet.next()) {
                    Table table = new Table();
                    object = resultSet.getString(3);
                    table.bTransfer = true;
                    table.sSchema = this.sSchemas != null ? this.sSchemas[n3] : null;
                    table.sSourceTable = object;
                    table.sDestTable = object;
                    table.sDestDrop = "DROP TABLE " + this.FormatIdentifier((String)object) + ";";
                    table.sDestCreateIndex = "";
                    table.sDestDropIndex = "";
                    table.sSourceSelect = "SELECT * FROM " + this.FormatIdentifier((String)object) + ";";
                    table.sDestDelete = "DELETE FROM " + this.FormatIdentifier((String)object) + ";";
                    table.sDestAlter = "";
                    table.bCreate = true;
                    table.bDelete = true;
                    table.bDrop = true;
                    table.bCreateIndex = true;
                    table.bDropIndex = true;
                    table.bInsert = true;
                    table.bAlter = true;
                    table.bFKForced = false;
                    table.bIdxForced = false;
                    table.iTableIndex = n++;
                    this.tTable.addElement(table);
                    this.lTable.add((String)object);
                }
                resultSet.close();
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.tTable.size()) {
                object = (Table)this.tTable.elementAt(n4);
                this.GetTableStructure((Table)object);
                this.lTable.select(((Table)object).iTableIndex);
                this.displayTable((Table)object);
                ++n4;
            }
            this.bStart.setEnabled(true);
            this.trace("Edit definitions and press [Start Transfer]");
        }
        catch (SQLException sQLException) {
            this.trace("SQL Exception reading Metadata: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        this.fMain.show();
    }

    void addMenuItems(Menu menu, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            MenuItem menuItem = new MenuItem(stringArray[n]);
            menuItem.addActionListener(this);
            menu.add(menuItem);
            ++n;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.lTable) {
            if (this.iSelectionStep == 2) {
                String string = this.lTable.getSelectedItem();
                int n = 0;
                while (n < this.tTable.size()) {
                    Table table = (Table)this.tTable.elementAt(n);
                    if (table != null && table.sSourceTable.equals(string)) {
                        this.saveTable();
                        this.displayTable(table);
                        this.updateEnabled(true);
                    }
                    ++n;
                }
            }
        } else {
            this.saveTable();
            this.displayTable(this.tCurrent);
            this.updateEnabled(true);
            this.trace("Edit definitions and press [Start Transfer]");
        }
    }

    void saveTable() {
        if (this.tCurrent == null) {
            return;
        }
        Table table = this.tCurrent;
        table.sSourceTable = this.tSourceTable.getText();
        table.sDestTable = this.tDestTable.getText();
        table.sDestDrop = this.tDestDrop.getText();
        table.sDestCreateIndex = this.tDestCreateIndex.getText();
        table.sDestDropIndex = this.tDestDropIndex.getText();
        table.sDestCreate = this.tDestCreate.getText();
        table.sDestDelete = this.tDestDelete.getText();
        table.sSourceSelect = this.tSourceSelect.getText();
        table.sDestInsert = this.tDestInsert.getText();
        table.bTransfer = this.cTransfer.getState();
        table.bDrop = this.cDrop.getState();
        table.bCreate = this.cCreate.getState();
        table.bDelete = this.cDelete.getState();
        table.bInsert = this.cInsert.getState();
        table.bAlter = this.cAlter.getState();
        boolean bl = table.bFKForced != this.cFKForced.getState() || table.bIdxForced != this.cIdxForced.getState();
        table.bFKForced = this.cFKForced.getState();
        table.bIdxForced = this.cIdxForced.getState();
        if (bl) {
            this.GetTableStructure(table);
        }
    }

    void displayTable(Table table) {
        this.tCurrent = table;
        if (table == null) {
            return;
        }
        this.tSourceTable.setText(table.sSourceTable);
        this.tDestTable.setText(table.sDestTable);
        this.tDestDrop.setText(table.sDestDrop);
        this.tDestCreateIndex.setText(table.sDestCreateIndex);
        this.tDestDropIndex.setText(table.sDestDropIndex);
        this.tDestCreate.setText(table.sDestCreate);
        this.tDestDelete.setText(table.sDestDelete);
        this.tSourceSelect.setText(table.sSourceSelect);
        this.tDestInsert.setText(table.sDestInsert);
        this.tDestAlter.setText(table.sDestAlter);
        this.cTransfer.setState(table.bTransfer);
        this.cDrop.setState(table.bDrop);
        this.cCreate.setState(table.bCreate);
        this.cDropIndex.setState(table.bDropIndex);
        this.cCreateIndex.setState(table.bCreateIndex);
        this.cDelete.setState(table.bDelete);
        this.cInsert.setState(table.bInsert);
        this.cAlter.setState(table.bAlter);
        this.cFKForced.setState(table.bFKForced);
        this.cIdxForced.setState(table.bIdxForced);
    }

    void updateEnabled(boolean bl) {
        boolean bl2 = this.cTransfer.getState();
        this.tDestTable.setEnabled(bl && bl2);
        this.tDestDrop.setEnabled(bl && bl2 && this.cDrop.getState());
        this.tDestCreate.setEnabled(bl && bl2 && this.cCreate.getState());
        this.tDestDelete.setEnabled(bl && bl2 && this.cDelete.getState());
        this.tDestCreateIndex.setEnabled(bl && bl2 && this.cCreateIndex.getState());
        this.tDestDropIndex.setEnabled(bl && bl2 && this.cDropIndex.getState());
        this.tSourceSelect.setEnabled(bl && bl2);
        this.tDestInsert.setEnabled(bl && bl2 && this.cInsert.getState());
        this.tDestAlter.setEnabled(bl && bl2 && this.cAlter.getState());
        this.cDrop.setEnabled(bl && bl2);
        this.cCreate.setEnabled(bl && bl2);
        this.cDelete.setEnabled(bl && bl2);
        this.cCreateIndex.setEnabled(bl && bl2);
        this.cDropIndex.setEnabled(bl && bl2);
        this.cInsert.setEnabled(bl && bl2);
        this.cAlter.setEnabled(bl && bl2);
        this.cFKForced.setEnabled(this.cAlter.getState());
        this.cIdxForced.setEnabled(this.cCreateIndex.getState());
        this.bStart.setEnabled(bl);
        this.bContinue.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        MenuItem menuItem = new MenuItem();
        if (string == null && actionEvent.getSource() instanceof MenuItem) {
            menuItem = (MenuItem)actionEvent.getSource();
            string = menuItem.getLabel();
        }
        if (string.equals("Start Transfer") || string.equals("ReStart Transfer")) {
            this.bStart.setLabel("ReStart Transfer");
            this.bStart.invalidate();
            this.CurrentTransfer = 0;
            this.CurrentAlter = 0;
            this.transfer();
        } else if (string.equals("Continue Transfer")) {
            this.transfer();
        } else if (string.equals("Quit")) {
            this.cleanup();
            this.fMain.dispose();
            if (bMustExit) {
                System.exit(0);
            }
        } else if (string.equals("Start Parsing")) {
            this.bStart.setLabel("Start Transfer");
            this.bStart.invalidate();
            this.bStart.setEnabled(false);
            this.sSchemas = this.lTable.getSelectedItems();
            if (this.sSchemas.length > 0) {
                this.lTable.setMultipleMode(false);
                this.RefreshMainDisplay();
            }
        } else if (string.equals("Insert 10 rows only")) {
            this.iMaxRows = 10;
        } else if (string.equals("Insert 1000 rows only")) {
            this.iMaxRows = 1000;
        } else if (string.equals("Insert all rows")) {
            this.iMaxRows = 0;
        } else if (string.equals("Load Settings...")) {
            FileDialog fileDialog = new FileDialog(this.fMain, "Open Settings", 0);
            fileDialog.show();
            String string2 = fileDialog.getFile();
            if (string2 != null) {
                this.LoadPrefs(string2);
                this.displayTable(this.tCurrent);
            }
        } else if (string.equals("Save Settings...")) {
            FileDialog fileDialog = new FileDialog(this.fMain, "Save Settings", 1);
            fileDialog.show();
            String string3 = fileDialog.getFile();
            if (string3 != null) {
                this.SavePrefs(string3);
            }
        } else if (string.equals("Exit")) {
            this.windowClosing(null);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    void cleanup() {
        try {
            if (this.cSource != null) {
                this.cSource.close();
            }
            if (this.cTarget != null) {
                this.cTarget.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.fMain.dispose();
        if (bMustExit) {
            System.exit(0);
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    void initGUI() {
        Font font = new Font("Dialog", 0, 12);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setBackground(SystemColor.control);
        panel.setLayout(new GridLayout(16, 1));
        this.tSourceTable = new TextField();
        this.tSourceTable.setEnabled(false);
        this.tDestTable = new TextField();
        this.tDestDrop = new TextField();
        this.tDestCreate = new TextField();
        this.tDestDelete = new TextField();
        this.tDestCreateIndex = new TextField();
        this.tDestDropIndex = new TextField();
        this.tSourceSelect = new TextField();
        this.tDestInsert = new TextField();
        this.tDestAlter = new TextField();
        this.cTransfer = new Checkbox("Transfer to destination table", true);
        this.cTransfer.addItemListener(this);
        this.cDrop = new Checkbox("Drop destination table (ignore error)", true);
        this.cDrop.addItemListener(this);
        this.cCreate = new Checkbox("Create destination table", true);
        this.cCreate.addItemListener(this);
        this.cDropIndex = new Checkbox("Drop destination index (ignore error)", true);
        this.cDropIndex.addItemListener(this);
        this.cIdxForced = new Checkbox("force Idx_ prefix for indexes names", false);
        this.cIdxForced.addItemListener(this);
        this.cCreateIndex = new Checkbox("Create destination index", true);
        this.cCreateIndex.addItemListener(this);
        this.cDelete = new Checkbox("Delete rows in destination table", true);
        this.cDelete.addItemListener(this);
        this.cInsert = new Checkbox("Insert into destination", true);
        this.cInsert.addItemListener(this);
        this.cFKForced = new Checkbox("force FK_ prefix for foreign key names", false);
        this.cFKForced.addItemListener(this);
        this.cAlter = new Checkbox("Alter destination table", true);
        this.cAlter.addItemListener(this);
        panel.add(this.createLabel("Source table"));
        panel.add(this.tSourceTable);
        panel.add(this.cTransfer);
        panel.add(this.tDestTable);
        panel.add(this.cDrop);
        panel.add(this.tDestDrop);
        panel.add(this.cCreate);
        panel.add(this.tDestCreate);
        panel.add(this.cDropIndex);
        panel.add(this.tDestDropIndex);
        panel.add(this.cCreateIndex);
        panel.add(this.tDestCreateIndex);
        panel.add(this.cDelete);
        panel.add(this.tDestDelete);
        panel.add(this.cAlter);
        panel.add(this.tDestAlter);
        panel.add(this.createLabel("Select source records"));
        panel.add(this.tSourceSelect);
        panel.add(this.cInsert);
        panel.add(this.tDestInsert);
        panel.add(this.createLabel(""));
        panel.add(this.createLabel(""));
        panel.add(this.cIdxForced);
        panel.add(this.cFKForced);
        panel.add(this.createLabel(""));
        panel.add(this.createLabel(""));
        this.bStart = new Button("Start Transfer");
        this.bContinue = new Button("Continue Transfer");
        this.bStart.addActionListener(this);
        panel.add(this.bStart);
        this.bContinue.addActionListener(this);
        panel.add(this.bContinue);
        this.bContinue.setEnabled(false);
        this.bStart.setEnabled(false);
        this.fMain.add("Center", this.createBorderPanel(panel));
        this.lTable = new List(10);
        this.lTable.addItemListener(this);
        this.fMain.add("West", this.createBorderPanel(this.lTable));
        this.tMessage = new TextField();
        Panel panel2 = this.createBorderPanel(this.tMessage);
        this.fMain.add("South", panel2);
    }

    Panel createBorderPanel(Component component) {
        Panel panel = new Panel();
        panel.setBackground(SystemColor.control);
        panel.setLayout(new BorderLayout());
        panel.add("Center", component);
        panel.add("South", this.createLabel(""));
        panel.add("East", this.createLabel(""));
        panel.add("West", this.createLabel(""));
        panel.setBackground(SystemColor.control);
        return panel;
    }

    Label createLabel(String string) {
        Label label = new Label(string);
        label.setBackground(SystemColor.control);
        return label;
    }

    void trace(String string) {
        this.tMessage.setText(string);
        System.out.println(string);
    }

    void transfer() {
        this.saveTable();
        this.updateEnabled(false);
        this.trace("Start Transfer");
        int n = this.CurrentTransfer;
        int n2 = this.CurrentAlter;
        if (this.DestDriverName.indexOf("PostgreSQL") == -1) {
            try {
                this.cTarget.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            int n3 = n;
            while (n3 < this.tTable.size()) {
                this.CurrentTransfer = n3;
                this.transfer((Table)this.tTable.elementAt(n3));
                this.cTarget.commit();
                ++n3;
            }
            int n4 = n2;
            while (n4 < this.tTable.size()) {
                this.CurrentAlter = n4;
                this.transferAlter((Table)this.tTable.elementAt(n4));
                this.cTarget.commit();
                ++n4;
            }
            this.trace("Transfer finished successfully");
            this.bContinue.setLabel("Quit");
            this.bContinue.setEnabled(true);
            this.bContinue.invalidate();
        }
        catch (SQLException sQLException) {
            try {
                if (!this.cTarget.getAutoCommit()) {
                    this.cTarget.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = this.tMessage.getText();
            this.trace("Transfer stopped - " + string + " / " + this.sLast + " / Error: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            try {
                if (!this.cTarget.getAutoCommit()) {
                    this.cTarget.rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            String string = this.tMessage.getText();
            this.trace("Transfer stopped - " + string + " / " + this.sLast + " / Error: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            this.cTarget.setAutoCommit(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bContinue.setEnabled(this.CurrentAlter < this.tTable.size());
        this.updateEnabled(true);
    }

    void transfer(Table table) throws SQLException {
        this.lTable.select(table.iTableIndex);
        this.displayTable(table);
        Statement statement = this.cTarget.createStatement();
        if (!table.bTransfer) {
            this.trace("Table " + table.sSourceTable + " not transfered");
            return;
        }
        this.trace("Table " + table.sSourceTable + ": start transfer");
        try {
            int n;
            int n2;
            Object object;
            if (table.bDelete) {
                object = new String("");
                if (table.sDestDrop.charAt(table.sDestDrop.length() - 1) != ';') {
                    table.sDestDrop = table.sDestDrop + ";";
                }
                n2 = 0;
                n = table.sDestDrop.indexOf(59);
                while (n > n2) {
                    object = table.sDestDrop.substring(n2, n);
                    try {
                        this.trace("Executing " + (String)object);
                        statement.execute((String)object);
                    }
                    catch (SQLException sQLException) {
                        this.trace("Ignoring error " + sQLException.getMessage());
                    }
                    n2 = n + 1;
                    n = n2 + table.sDestDrop.substring(n2).indexOf(59);
                }
            }
            if (table.bCreate) {
                this.trace("Executing " + table.sDestCreate);
                statement.execute(table.sDestCreate);
            }
            if (table.bDropIndex) {
                object = new String("");
                if (table.sDestDropIndex.charAt(table.sDestDropIndex.length() - 1) != ';') {
                    table.sDestDropIndex = table.sDestDropIndex + ";";
                }
                n2 = 0;
                n = table.sDestDropIndex.indexOf(59);
                while (n > n2) {
                    object = table.sDestDropIndex.substring(n2, n);
                    try {
                        this.trace("Executing " + (String)object);
                        statement.execute((String)object);
                    }
                    catch (SQLException sQLException) {
                        this.trace("Ignoring error " + sQLException.getMessage());
                    }
                    n2 = n + 1;
                    n = n2 + table.sDestDropIndex.substring(n2).indexOf(59);
                }
            }
            if (table.bCreateIndex) {
                this.trace("Executing " + table.sDestCreateIndex);
                statement.execute(table.sDestCreateIndex);
            }
            if (table.bDelete) {
                this.trace("Executing " + table.sDestDelete);
                statement.execute(table.sDestDelete);
            }
            if (table.bInsert) {
                this.trace("Executing " + table.sDestInsert);
                object = this.cTarget.prepareStatement(table.sDestInsert);
                this.trace("Executing " + table.sSourceSelect);
                ResultSet resultSet = this.sSourceStatement.executeQuery(table.sSourceSelect);
                n = 0;
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int[] nArray = new int[resultSetMetaData.getColumnCount()];
                int n3 = 0;
                while (n3 < resultSetMetaData.getColumnCount()) {
                    nArray[n3] = resultSetMetaData.getColumnType(n3 + 1);
                    ++n3;
                }
                this.trace("Start transfering data...");
                while (resultSet.next()) {
                    this.transferRow(nArray, resultSet, (PreparedStatement)object);
                    if (this.iMaxRows != 0 && n == this.iMaxRows) break;
                    if (this.iMaxRows == 0 && ++n % 100 != 0) continue;
                    this.trace("Transfered " + n + " rows");
                }
                this.trace("Finished");
            }
        }
        catch (SQLException sQLException) {
            statement.close();
            throw sQLException;
        }
    }

    void transferAlter(Table table) throws SQLException {
        Statement statement = this.cTarget.createStatement();
        this.lTable.select(table.iTableIndex);
        this.displayTable(table);
        if (!table.bTransfer) {
            this.trace("Table " + table.sSourceTable + " not transfered");
            return;
        }
        this.trace("Table " + table.sSourceTable + ": start alter");
        if (table.bAlter) {
            try {
                this.trace("Executing " + table.sDestAlter);
                statement.execute(table.sDestAlter);
            }
            catch (SQLException sQLException) {
                this.trace("Ignoring error " + sQLException.getMessage());
            }
        }
        statement.close();
    }

    void transferRow(int[] nArray, ResultSet resultSet, PreparedStatement preparedStatement) throws SQLException {
        this.sLast = null;
        preparedStatement.clearParameters();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            int n3 = nArray[n2];
            this.sLast = "column=" + (n2 + 1) + " datatype=" + n3;
            if (n3 == 2004) {
                object = resultSet.getBlob(n2 + 1);
                if (null == object) {
                    preparedStatement.setNull(n2 + 1, nArray[n2]);
                    this.sLast = this.sLast + " value=<null blob>";
                } else {
                    preparedStatement.setBytes(n2 + 1, object.getBytes(1L, (int)object.length()));
                    this.sLast = this.sLast + " value=<blob>";
                }
            } else {
                object = resultSet.getObject(n2 + 1);
                if (object == null) {
                    this.sLast = this.sLast + " value=" + object;
                    preparedStatement.setNull(n2 + 1, nArray[n2]);
                } else {
                    if (n3 == 5 && object instanceof Integer) {
                        this.sLast = this.sLast + " SMALLINT: Converted Integer to Short";
                        object = new Short((short)((Integer)object).intValue());
                    } else if (n3 == -6 && object instanceof Integer) {
                        this.sLast = this.sLast + " TINYINT: Converted Integer to Byte";
                        object = new Byte((byte)((Integer)object).intValue());
                    }
                    this.sLast = this.sLast + " value=" + object;
                    preparedStatement.setObject(n2 + 1, object, nArray[n2]);
                }
            }
            ++n2;
        }
        preparedStatement.execute();
        this.sLast = null;
    }

    void SavePrefs(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.tTable);
        }
        catch (IOException iOException) {
            System.out.println("pb in SavePrefs : " + iOException.toString());
            iOException.printStackTrace();
        }
    }

    void LoadPrefs(String string) {
        this.trace("Parsing Settings file");
        this.bStart.setEnabled(false);
        this.bContinue.setEnabled(false);
        try {
            Table table;
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.tTable = (Vector)objectInputStream.readObject();
            this.iSelectionStep = 2;
            this.lTable.removeAll();
            int n = 0;
            while (n < this.tTable.size()) {
                table = (Table)this.tTable.elementAt(n);
                this.lTable.add(table.sSourceTable);
                ++n;
            }
            table = (Table)this.tTable.elementAt(0);
            this.displayTable(table);
            this.updateEnabled(true);
            this.lTable.invalidate();
            this.bStart.setLabel("Start Transfer");
            this.bStart.invalidate();
            this.trace("Edit definitions and press [Start Transfer]");
            this.bContinue.setEnabled(false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("class not found pb in LoadPrefs : " + classNotFoundException.toString());
        }
        catch (IOException iOException) {
            System.out.println("IO pb in LoadPrefs : actionPerformed" + iOException.toString());
        }
    }

    class Table
    implements Serializable {
        int iTableIndex;
        String sSchema;
        String sSourceTable;
        String sDestTable;
        String sDestDrop;
        String sDestCreate;
        String sDestDelete;
        String sDestDropIndex;
        String sDestCreateIndex;
        String sSourceSelect;
        String sDestInsert;
        String sDestAlter;
        boolean bTransfer;
        boolean bDrop;
        boolean bCreate;
        boolean bDelete;
        boolean bInsert;
        boolean bAlter;
        boolean bCreateIndex;
        boolean bDropIndex;
        boolean bFKForced;
        boolean bIdxForced;
        int[] iColumnType;

        Table() {
        }
    }
}

