/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import org.hsqldb.util.jdbcSystem;

public class ScriptTool {
    private static Properties pProperties = new Properties();
    private Connection cConn;
    private Statement sStatement;

    public static void main(String[] stringArray) {
        Object object;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if (((String)object).equals("-?")) {
                ScriptTool.printHelp();
            }
            if (((String)object).charAt(0) == '-') {
                ((Hashtable)pProperties).put(((String)object).substring(1), stringArray[n + 1]);
                ++n;
            }
            ++n;
        }
        object = new ScriptTool();
        ((ScriptTool)object).execute();
    }

    public void execute() {
        Properties properties = pProperties;
        String string = properties.getProperty("driver", "org.hsqldb.jdbcDriver");
        String string2 = properties.getProperty("url", "jdbc:hsqldb:");
        String string3 = properties.getProperty("database", "test");
        String string4 = properties.getProperty("user", "sa");
        String string5 = properties.getProperty("password", "");
        String string6 = properties.getProperty("script", "import.sql");
        boolean bl = properties.getProperty("log", "false").equalsIgnoreCase("true");
        try {
            if (bl) {
                this.trace("driver  =" + string);
                this.trace("url     =" + string2);
                this.trace("database=" + string3);
                this.trace("user    =" + string4);
                this.trace("password=" + string5);
                this.trace("script  =" + string6);
                this.trace("log     =" + bl);
                jdbcSystem.setLogToSystem(true);
            }
            Class.forName(string).newInstance();
            this.cConn = DriverManager.getConnection(string2 + string3, string4, string5);
        }
        catch (Exception exception) {
            System.out.println("QueryTool.init: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            this.sStatement = this.cConn.createStatement();
            String string7 = this.fileToString(string6);
            if (bl) {
                this.trace("SQL : " + string7);
            }
            this.sStatement.execute(string7);
            ResultSet resultSet = this.sStatement.getResultSet();
            int n = this.sStatement.getUpdateCount();
            if (n == -1) {
                this.trace(this.toString(resultSet));
            } else {
                this.trace("update count " + n);
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQL Error : " + sQLException);
        }
        System.exit(0);
    }

    private String toString(ResultSet resultSet) {
        try {
            if (resultSet == null) {
                return "No Result";
            }
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 1;
            while (n2 <= n) {
                stringBuffer = stringBuffer.append(resultSetMetaData.getColumnLabel(n2) + "\t");
                ++n2;
            }
            stringBuffer = stringBuffer.append("\n");
            while (resultSet.next()) {
                int n3 = 1;
                while (n3 <= n) {
                    stringBuffer = stringBuffer.append(resultSet.getString(n3) + "\t");
                    if (resultSet.wasNull()) {
                        stringBuffer = stringBuffer.append("(null)\t");
                    }
                    ++n3;
                }
                stringBuffer = stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private String fileToString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    private void trace(String string) {
        System.out.println(string);
    }

    private static void printHelp() {
        System.out.println("Usage: java ScriptTool [-options]\nwhere options include:\n    -driver <classname>  name of the driver class\n    -url <name>          first part of the jdbc url\n    -database <name>     second part of the jdbc url\n    -user <name>         username used for connection\n    -password <name>     password for this user\n    -log <true/false>    write log to system out\n    -script <script file>   reads from script file\n");
        System.exit(0);
    }
}

