/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.hsqldb.util.ConnectionDialogSwing;
import org.hsqldb.util.DBMTableModelSwing;
import org.hsqldb.util.TransferSwing;
import org.hsqldb.util.jdbcSystem;

public class DatabaseManagerSwing
extends JApplet
implements ActionListener,
WindowListener,
KeyListener {
    Connection cConn;
    DatabaseMetaData dMeta;
    Statement sStatement;
    JMenu mRecent;
    String[] sRecent;
    static int iMaxRecent = 24;
    int iRecent;
    JTextArea txtCommand;
    JScrollPane txtCommandScroll;
    JButton butExecute;
    JTree tTree;
    JScrollPane tScrollPane;
    DefaultTreeModel treeModel;
    DefaultMutableTreeNode rootNode;
    JPanel pResult;
    long lTime;
    int iResult;
    DBMTableModelSwing gResult;
    JTable gResultTable;
    JScrollPane gScrollPane;
    JTextArea txtResult;
    JScrollPane txtResultScroll;
    JSplitPane nsSplitPane;
    JSplitPane ewSplitPane;
    boolean bHelp;
    JFrame fMain;
    Image imgEmpty;
    static Random rRandom = new Random(100L);

    void connect(Connection connection) {
        if (connection == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.cConn = connection;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.sStatement = this.cConn.createStatement();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.refreshTree();
    }

    public void init() {
        DatabaseManagerSwing databaseManagerSwing = new DatabaseManagerSwing();
        databaseManagerSwing.main();
        try {
            databaseManagerSwing.connect(ConnectionDialogSwing.createConnection("org.hsqldb.jdbcDriver", "jdbc:hsqldb:.", "sa", ""));
            databaseManagerSwing.insertTestData();
            databaseManagerSwing.refreshTree();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ((Hashtable)System.getProperties()).put("sun.java2d.noddraw", "true");
        DatabaseManagerSwing databaseManagerSwing = new DatabaseManagerSwing();
        databaseManagerSwing.main();
        Connection connection = ConnectionDialogSwing.createConnection(databaseManagerSwing.fMain, "Connect");
        if (connection == null) {
            return;
        }
        databaseManagerSwing.connect(connection);
    }

    void insertTestData() {
        String[] stringArray = new String[]{"DROP TABLE Address", "DROP TABLE Product", "DROP TABLE Document", "DROP TABLE Position", "CREATE TABLE Address(ID INTEGER PRIMARY KEY,FirstName VARCHAR(255),LastName VARCHAR(255),Street VARCHAR(255),City VARCHAR(255))", "CREATE TABLE Product(ID INTEGER PRIMARY KEY,Name VARCHAR(255),Cost DECIMAL)", "CREATE TABLE Document(ID INTEGER PRIMARY KEY,AddressID INTEGER,Total DECIMAL)", "CREATE TABLE Position(DocumentID INTEGER,Position INTEGER,ProductID INTEGER,Quantity INTEGER,Price DECIMAL,PRIMARY KEY(DocumentID,Position))"};
        String[] stringArray2 = new String[]{"White", "Karsen", "Smith", "Ringer", "May", "King", "Fuller", "Miller", "Ott", "Sommer", "Schneider", "Steel", "Peterson", "Heiniger", "Clancy"};
        String[] stringArray3 = new String[]{"Mary", "James", "Anne", "George", "Sylvia", "Robert", "Janet", "Michael", "Andrew", "Bill", "Susanne", "Laura", "Bob", "Julia", "John"};
        String[] stringArray4 = new String[]{"Upland Pl.", "College Av.", "- 20th Ave.", "Seventh Av."};
        String[] stringArray5 = new String[]{"New York", "Dallas", "Boston", "Chicago", "Seattle", "San Francisco", "Berne", "Oslo", "Paris", "Lyon", "Palo Alto", "Olten"};
        String[] stringArray6 = new String[]{"Iron", "Ice Tea", "Clock", "Chair", "Telephone", "Shoe"};
        try {
            int n = 0;
            while (n < stringArray.length) {
                try {
                    this.sStatement.execute(stringArray[n]);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ++n;
            }
            this.refreshTree();
            int n2 = 50;
            int n3 = 0;
            while (n3 < n2) {
                this.sStatement.execute("INSERT INTO Address VALUES(" + n3 + ",'" + DatabaseManagerSwing.random(stringArray3) + "','" + DatabaseManagerSwing.random(stringArray2) + "','" + DatabaseManagerSwing.random(554) + " " + DatabaseManagerSwing.random(stringArray4) + "','" + DatabaseManagerSwing.random(stringArray5) + "')");
                this.sStatement.execute("INSERT INTO Product VALUES(" + n3 + ",'" + DatabaseManagerSwing.random(stringArray6) + " " + DatabaseManagerSwing.random(stringArray6) + "'," + (20 + 2 * DatabaseManagerSwing.random(120)) + ")");
                this.sStatement.execute("INSERT INTO Document VALUES(" + n3 + "," + DatabaseManagerSwing.random(n2) + ",0.0)");
                int n4 = DatabaseManagerSwing.random(20) + 2;
                while (n4 >= 0) {
                    this.sStatement.execute("INSERT INTO Position VALUES(" + n3 + "," + n4 + "," + DatabaseManagerSwing.random(n2) + "," + (1 + DatabaseManagerSwing.random(24)) + ",1.5)");
                    --n4;
                }
                ++n3;
            }
            this.sStatement.execute("UPDATE Product SET Cost=Cost*.1");
            this.sStatement.execute("UPDATE Position SET Price=Price*SELECT Cost FROM Product prod WHERE ProductID=prod.ID");
            this.sStatement.execute("UPDATE Document SET Total=SELECT SUM(Price*Quantity) FROM Position WHERE DocumentID=Document.ID");
            String[] stringArray7 = new String[]{"SELECT * FROM Product", "SELECT * FROM Document", "SELECT * FROM Position", "SELECT * FROM Address a\nINNER JOIN Document d ON a.ID=d.AddressID", "SELECT * FROM Document d\nINNER JOIN Position p ON d.ID=p.DocumentID", "SELECT * FROM Address WHERE Street LIKE '1%' ORDER BY Lastname"};
            int n5 = 0;
            while (n5 < stringArray7.length) {
                this.addToRecent(stringArray7[n5]);
                ++n5;
            }
            this.refreshTree();
            this.txtCommand.setText("SELECT * FROM Address");
            this.execute();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public static String random(String[] stringArray) {
        return stringArray[DatabaseManagerSwing.random(stringArray.length)];
    }

    public static int random(int n) {
        n = rRandom.nextInt() % n;
        return n < 0 ? -n : n;
    }

    void main() {
        this.fMain = new JFrame("Hypersonic Database Manager");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        ((Frame)this.fMain).setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        JMenuBar jMenuBar = new JMenuBar();
        String[] stringArray = new String[]{"-Connect...", "--", "-Open Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        this.addMenu(jMenuBar, "File", stringArray);
        String[] stringArray2 = new String[]{"RRefresh Tree", "--", "GResults in Grid", "TResults in Text"};
        this.addMenu(jMenuBar, "View", stringArray2);
        String[] stringArray3 = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "--", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "-CHECKPOINT", "-SCRIPT", "-SET", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(jMenuBar, "Command", stringArray3);
        this.mRecent = new JMenu("Recent");
        jMenuBar.add(this.mRecent);
        String[] stringArray4 = new String[]{"-AutoCommit on", "-AutoCommit off", "OCommit", "LRollback", "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", "-Logging on", "-Logging off", "--", "-Insert test data", "-Transfer"};
        this.addMenu(jMenuBar, "Options", stringArray4);
        this.fMain.setJMenuBar(jMenuBar);
        this.initGUI();
        this.sRecent = new String[iMaxRecent];
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fMain.getSize();
        ((Component)this.fMain).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.fMain.show();
        this.txtCommand.requestFocus();
    }

    void addMenu(JMenuBar jMenuBar, String string, String[] stringArray) {
        JMenu jMenu = new JMenu(string);
        this.addMenuItems(jMenu, stringArray);
        jMenuBar.add(jMenu);
    }

    void addMenuItems(JMenu jMenu, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("--")) {
                jMenu.addSeparator();
            } else {
                JMenuItem jMenuItem = new JMenuItem(stringArray[n].substring(1));
                char c = stringArray[n].charAt(0);
                if (c != '-') {
                    jMenuItem.setMnemonic(c);
                }
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            }
            ++n;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown()) {
            keyEvent.consume();
            this.execute();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null && actionEvent.getSource() instanceof JMenuItem) {
            string = ((JMenuItem)actionEvent.getSource()).getText();
        }
        if (string.equals("Execute")) {
            this.execute();
        } else if (string.equals("Exit")) {
            this.windowClosing(null);
        } else if (string.equals("Transfer")) {
            TransferSwing.work();
        } else if (string.equals("Logging on")) {
            jdbcSystem.setLogToSystem(true);
        } else if (string.equals("Logging off")) {
            jdbcSystem.setLogToSystem(false);
        } else if (string.equals("Refresh Tree")) {
            this.refreshTree();
        } else if (string.startsWith("#")) {
            int n = Integer.parseInt(string.substring(1));
            this.txtCommand.setText(this.sRecent[n]);
        } else if (string.equals("Connect...")) {
            this.connect(ConnectionDialogSwing.createConnection(this.fMain, "Connect"));
            this.refreshTree();
        } else if (string.equals("Results in Grid")) {
            this.iResult = 0;
            this.pResult.removeAll();
            this.pResult.add((Component)this.gScrollPane, "Center");
            this.pResult.doLayout();
            this.gResult.fireTableChanged(null);
            this.pResult.repaint();
        } else if (string.equals("Open Script...")) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Open Script...");
            int n = jFileChooser.showOpenDialog(this.fMain);
            if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                this.txtCommand.setText(this.readFile(file.getAbsolutePath()));
            }
        } else if (string.equals("Save Script...")) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Save Script");
            int n = jFileChooser.showSaveDialog(this.fMain);
            if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                this.writeFile(file.getAbsolutePath(), this.txtCommand.getText());
            }
        } else if (string.equals("Save Result...")) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Save Result...");
            int n = jFileChooser.showSaveDialog(this.fMain);
            if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                this.showResultInText();
                this.writeFile(file.getAbsolutePath(), this.txtResult.getText());
            }
        } else if (string.equals("Results in Text")) {
            this.iResult = 1;
            this.pResult.removeAll();
            this.pResult.add((Component)this.txtResultScroll, "Center");
            this.pResult.doLayout();
            this.showResultInText();
            this.pResult.repaint();
        } else if (string.equals("AutoCommit on")) {
            try {
                this.cConn.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("AutoCommit off")) {
            try {
                this.cConn.setAutoCommit(false);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Commit")) {
            try {
                this.cConn.commit();
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Insert test data")) {
            this.insertTestData();
        } else if (string.equals("Rollback")) {
            try {
                this.cConn.rollback();
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Disable MaxRows")) {
            try {
                this.sStatement.setMaxRows(0);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Set MaxRows to 100")) {
            try {
                this.sStatement.setMaxRows(100);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("SELECT")) {
            this.showHelp("SELECT * FROM ", "SELECT [LIMIT n m] [DISTINCT] \n{ selectExpression | table.* | * } [, ... ] \n[INTO [CACHED|TEMP|TEXT] newTable] \nFROM tableList \n[WHERE Expression] \n[ORDER BY selectExpression [{ASC | DESC}] [, ...] ] \n[GROUP BY Expression [, ...] ] \n[UNION [ALL] selectStatement]");
        } else if (string.equals("INSERT")) {
            this.showHelp("INSERT INTO ", "INSERT INTO table [ (column [,...] ) ] \n{ VALUES(Expression [,...]) | SelectStatement }");
        } else if (string.equals("UPDATE")) {
            this.showHelp("UPDATE ", "UPDATE table SET column = Expression [, ...] \n[WHERE Expression]");
        } else if (string.equals("DELETE")) {
            this.showHelp("DELETE FROM ", "DELETE FROM table [WHERE Expression]");
        } else if (string.equals("CREATE TABLE")) {
            this.showHelp("CREATE TABLE ", "CREATE [TEMP] [CACHED|MEMORY|TEXT] TABLE name \n( columnDefinition [, ...] ) \n\ncolumnDefinition: \ncolumn DataType [ [NOT] NULL] [PRIMARY KEY] \nDataType: \n{ INTEGER | DOUBLE | VARCHAR | DATE | TIME |... }");
        } else if (string.equals("DROP TABLE")) {
            this.showHelp("DROP TABLE ", "DROP TABLE table");
        } else if (string.equals("CREATE INDEX")) {
            this.showHelp("CREATE INDEX ", "CREATE [UNIQUE] INDEX index ON \ntable (column [, ...])");
        } else if (string.equals("DROP INDEX")) {
            this.showHelp("DROP INDEX ", "DROP INDEX table.index");
        } else if (string.equals("CHECKPOINT")) {
            this.showHelp("CHECKPOINT", "(Hypersonic SQL only)");
        } else if (string.equals("SCRIPT")) {
            this.showHelp("SCRIPT", "SCRIPT ['file']\n\n(Hypersonic SQL only)");
        } else if (string.equals("SHUTDOWN")) {
            this.showHelp("SHUTDOWN", "SHUTDOWN [COMPACT|IMMEDIATELY]\n\n(Hypersonic SQL only)");
        } else if (string.equals("SET")) {
            this.showHelp("SET ", "AUTOCOMMIT { TRUE | FALSE }\nIGNORECASE { TRUE | FALSE }\nLOGSIZE size\nMAXROWS maxrows\nPASSWORD password\nREADONLY { TRUE | FALSE }\nREFERENTIAL_INTEGRITY { TRUE | FALSE }\nTABLE table READONLY { TRUE | FALSE }\nWRITE_DELAY { TRUE | FALSE }\n");
        } else if (string.equals("Test Script")) {
            this.showHelp("-->>>TEST<<<-- ;\n--#1000;\nDROP TABLE Test ;\nCREATE TABLE Test(\n  Id INTEGER PRIMARY KEY,\n  FirstName VARCHAR(20),\n  Name VARCHAR(50),\n  ZIP INTEGER) ;\nINSERT INTO Test \n  VALUES(#,'Julia','Peterson-Clancy',#) ;\nUPDATE Test SET Name='Hans' WHERE Id=# ;\nSELECT * FROM Test WHERE Id=# ;\nDELETE FROM Test WHERE Id=# ;\nDROP TABLE Test", "This test script is parsed by the DatabaseManager\nIt may be changed manually. Rules:\n- it must start with -->>>TEST<<<--.\n- each line must end with ';' (no spaces after)\n- lines starting with -- are comments\n- lines starting with --#<count> means set new count\n");
        }
    }

    String readFile(String string) {
        try {
            int n;
            FileReader fileReader = new FileReader(string);
            char[] cArray = new char[1024];
            StringBuffer stringBuffer = new StringBuffer(4096);
            while ((n = fileReader.read(cArray, 0, 1024)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            fileReader.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return iOException.getMessage();
        }
    }

    void writeFile(String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(string2.toCharArray());
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void showHelp(String string, String string2) {
        this.txtCommand.setText(string);
        this.bHelp = true;
        this.pResult.removeAll();
        this.pResult.add((Component)this.txtResultScroll, "Center");
        this.pResult.doLayout();
        this.txtResult.setText(string2);
        this.pResult.repaint();
        this.txtCommand.requestFocus();
        this.txtCommand.setCaretPosition(string.length());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            this.cConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fMain.dispose();
        System.exit(0);
    }

    void trace(String string) {
        System.out.println(string);
    }

    void execute() {
        this.gResult.clear();
        String string = this.txtCommand.getText();
        if (string.startsWith("-->>>TEST<<<--")) {
            this.testPerformance();
            return;
        }
        String[] stringArray = new String[1];
        try {
            this.lTime = System.currentTimeMillis();
            this.sStatement.execute(string);
            int n = this.sStatement.getUpdateCount();
            if (n == -1) {
                this.formatResultSet(this.sStatement.getResultSet());
            } else {
                stringArray[0] = "update count";
                this.gResult.setHead(stringArray);
                stringArray[0] = "" + n;
                this.gResult.addRow(stringArray);
            }
            this.lTime = System.currentTimeMillis() - this.lTime;
            this.addToRecent(this.txtCommand.getText());
            this.gResult.fireTableChanged(null);
        }
        catch (SQLException sQLException) {
            this.lTime = System.currentTimeMillis() - this.lTime;
            stringArray[0] = "SQL Error";
            this.gResult.setHead(stringArray);
            String string2 = sQLException.getMessage();
            string2 = string2 + " / Error Code: " + sQLException.getErrorCode();
            stringArray[0] = string2 = string2 + " / State: " + sQLException.getSQLState();
            this.gResult.addRow(stringArray);
            this.gResult.fireTableChanged(null);
        }
        this.updateResult();
    }

    void updateResult() {
        if (this.iResult == 0) {
            if (this.bHelp) {
                this.pResult.removeAll();
                this.pResult.add((Component)this.gScrollPane, "Center");
                this.pResult.doLayout();
                this.gResult.fireTableChanged(null);
                this.pResult.repaint();
                this.bHelp = false;
            }
        } else {
            this.showResultInText();
        }
        this.txtCommand.selectAll();
        this.txtCommand.requestFocus();
    }

    void formatResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            String[] stringArray = new String[]{"Result"};
            this.gResult.setHead(stringArray);
            stringArray[0] = "(empty)";
            this.gResult.addRow(stringArray);
            return;
        }
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n];
            int n2 = 1;
            while (n2 <= n) {
                stringArray[n2 - 1] = resultSetMetaData.getColumnLabel(n2);
                ++n2;
            }
            this.gResult.setHead(stringArray);
            while (resultSet.next()) {
                int n3 = 1;
                while (n3 <= n) {
                    stringArray[n3 - 1] = resultSet.getString(n3);
                    if (resultSet.wasNull()) {
                        stringArray[n3 - 1] = "(null)";
                    }
                    ++n3;
                }
                this.gResult.addRow(stringArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    long testStatement(String string, int n) throws SQLException {
        long l = System.currentTimeMillis();
        if (string.indexOf(35) == -1) {
            n = 1;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            String string2 = string;
            while ((n3 = string2.indexOf(35)) != -1) {
                string2 = string2.substring(0, n3) + n2 + string2.substring(n3 + 1);
            }
            this.sStatement.execute(string2);
            ++n2;
        }
        return System.currentTimeMillis() - l;
    }

    void testPerformance() {
        String string = this.txtCommand.getText();
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '\n') {
                stringBuffer.append(c);
            }
            ++n;
        }
        string = stringBuffer.toString();
        String[] stringArray = new String[]{"ms", "count", "sql", "error"};
        this.gResult.setHead(stringArray);
        int n2 = 1;
        this.lTime = System.currentTimeMillis() - this.lTime;
        while (!string.equals("")) {
            String string2;
            int n3 = string.indexOf(59);
            if (n3 != -1) {
                string2 = string.substring(0, n3);
                string = string.substring(n3 + 1);
            } else {
                string2 = string;
                string = "";
            }
            if (string2.startsWith("--#")) {
                n2 = Integer.parseInt(string2.substring(3));
                continue;
            }
            if (string2.startsWith("--")) continue;
            stringArray[2] = string2;
            long l2 = 0L;
            try {
                l2 = this.testStatement(string2, n2);
                l += l2;
                stringArray[0] = "" + l2;
                stringArray[1] = "" + n2;
                stringArray[3] = "";
            }
            catch (SQLException sQLException) {
                stringArray[1] = "n/a";
                stringArray[0] = "n/a";
                stringArray[3] = sQLException.toString();
            }
            this.gResult.addRow(stringArray);
            System.out.println(l2 + " ms : " + string2);
        }
        stringArray[0] = "" + l;
        stringArray[1] = "total";
        stringArray[2] = "";
        this.gResult.addRow(stringArray);
        this.lTime = System.currentTimeMillis() - this.lTime;
        this.updateResult();
    }

    void showResultInText() {
        int n;
        int n2;
        int n3;
        String[] stringArray = this.gResult.getHead();
        int n4 = stringArray.length;
        Vector vector = this.gResult.getData();
        int[] nArray = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            nArray[n5] = stringArray[n5].length();
            ++n5;
        }
        int n6 = vector.size();
        int n7 = 0;
        while (n7 < n6) {
            stringArray = (String[])vector.elementAt(n7);
            int n8 = 0;
            while (n8 < n4) {
                n3 = stringArray[n8].length();
                if (n3 > nArray[n8]) {
                    nArray[n8] = n3;
                }
                ++n8;
            }
            ++n7;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringArray = this.gResult.getHead();
        n3 = 0;
        while (n3 < n4) {
            stringBuffer.append(stringArray[n3]);
            n2 = stringArray[n3].length();
            while (n2 <= nArray[n3]) {
                stringBuffer.append(' ');
                ++n2;
            }
            ++n3;
        }
        stringBuffer.append('\n');
        n2 = 0;
        while (n2 < n4) {
            n = 0;
            while (n < nArray[n2]) {
                stringBuffer.append('-');
                ++n;
            }
            stringBuffer.append(' ');
            ++n2;
        }
        stringBuffer.append('\n');
        n = 0;
        while (n < n6) {
            stringArray = (String[])vector.elementAt(n);
            int n9 = 0;
            while (n9 < n4) {
                stringBuffer.append(stringArray[n9]);
                int n10 = stringArray[n9].length();
                while (n10 <= nArray[n9]) {
                    stringBuffer.append(' ');
                    ++n10;
                }
                ++n9;
            }
            stringBuffer.append('\n');
            ++n;
        }
        stringBuffer.append("\n" + n6 + " row(s) in " + this.lTime + " ms");
        this.txtResult.setText(stringBuffer.toString());
    }

    private void addToRecent(String string) {
        int n = 0;
        while (n < iMaxRecent) {
            if (string.equals(this.sRecent[n])) {
                return;
            }
            ++n;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.mRecent.remove(this.iRecent);
        }
        this.sRecent[this.iRecent] = string;
        if (string.length() > 43) {
            string = string.substring(0, 40) + "...";
        }
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand("#" + this.iRecent);
        jMenuItem.addActionListener(this);
        this.mRecent.insert(jMenuItem, this.iRecent);
        this.iRecent = (this.iRecent + 1) % iMaxRecent;
    }

    private void initGUI() {
        JPanel jPanel = new JPanel();
        this.pResult = new JPanel();
        this.nsSplitPane = new JSplitPane(0, jPanel, this.pResult);
        jPanel.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font font = new Font("Dialog", 0, 12);
        this.txtCommand = new JTextArea(5, 40);
        this.txtCommand.setMargin(new Insets(5, 5, 5, 5));
        this.txtCommand.addKeyListener(this);
        this.txtCommandScroll = new JScrollPane(this.txtCommand);
        this.txtResult = new JTextArea(20, 40);
        this.txtResult.setMargin(new Insets(5, 5, 5, 5));
        this.txtResultScroll = new JScrollPane(this.txtResult);
        this.txtCommand.setFont(font);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        this.butExecute = new JButton("Execute");
        this.butExecute.addActionListener(this);
        jPanel.add((Component)this.butExecute, "East");
        jPanel.add((Component)this.txtCommandScroll, "Center");
        this.gResult = new DBMTableModelSwing();
        this.gResultTable = new JTable(this.gResult);
        this.gScrollPane = new JScrollPane(this.gResultTable);
        this.getContentPane().setLayout(new BorderLayout());
        this.pResult.add((Component)this.gScrollPane, "Center");
        this.rootNode = new DefaultMutableTreeNode("Connection");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tTree = new JTree(this.treeModel);
        this.tScrollPane = new JScrollPane(this.tTree);
        this.ewSplitPane = new JSplitPane(1, this.tScrollPane, this.nsSplitPane);
        this.fMain.getContentPane().add((Component)this.ewSplitPane, "Center");
        this.doLayout();
        this.fMain.pack();
    }

    private DefaultMutableTreeNode makeNode(Object object, MutableTreeNode mutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object);
        if (mutableTreeNode != null) {
            this.treeModel.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, mutableTreeNode.getChildCount());
        }
        return defaultMutableTreeNode;
    }

    private void refreshTree() {
        String[] stringArray;
        while (this.treeModel.getChildCount(this.rootNode) > 0) {
            stringArray = (String[])this.treeModel.getChild(this.rootNode, 0);
            this.treeModel.removeNodeFromParent((MutableTreeNode)stringArray);
            stringArray.removeAllChildren();
            stringArray.removeFromParent();
            this.treeModel.nodeStructureChanged(this.rootNode);
        }
        try {
            this.rootNode.setUserObject(this.dMeta.getURL());
            stringArray = new String[]{"TABLE"};
            ResultSet resultSet = this.dMeta.getTables(null, null, null, stringArray);
            Vector<String> vector = new Vector<String>();
            while (resultSet.next()) {
                vector.addElement(resultSet.getString(3));
            }
            resultSet.close();
            int n = 0;
            while (n < vector.size()) {
                String string;
                Object object;
                Object object2;
                String string2 = (String)vector.elementAt(n);
                DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode(string2, this.rootNode);
                ResultSet resultSet2 = this.dMeta.getColumns(null, null, string2, null);
                while (resultSet2.next()) {
                    object2 = resultSet2.getString(4);
                    object = this.makeNode(object2, defaultMutableTreeNode);
                    string = resultSet2.getString(6);
                    this.makeNode("Type: " + string, (MutableTreeNode)object);
                    boolean bl = resultSet2.getInt(11) != 0;
                    this.makeNode("Nullable: " + bl, (MutableTreeNode)object);
                }
                resultSet2.close();
                object2 = this.makeNode("Indices", defaultMutableTreeNode);
                object = this.dMeta.getIndexInfo(null, null, string2, false, false);
                string = null;
                while (object.next()) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                    boolean bl = object.getBoolean(4);
                    String string3 = object.getString(6);
                    if (string == null || !string.equals(string3)) {
                        defaultMutableTreeNode2 = this.makeNode(string3, (MutableTreeNode)object2);
                        this.makeNode("Unique: " + !bl, defaultMutableTreeNode2);
                        string = string3;
                    }
                    this.makeNode(object.getString(9), defaultMutableTreeNode2);
                }
                object.close();
                ++n;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Properties", this.rootNode);
            this.makeNode("User: " + this.dMeta.getUserName(), defaultMutableTreeNode);
            this.makeNode("ReadOnly: " + this.cConn.isReadOnly(), defaultMutableTreeNode);
            this.makeNode("AutoCommit: " + this.cConn.getAutoCommit(), defaultMutableTreeNode);
            this.makeNode("Driver: " + this.dMeta.getDriverName(), defaultMutableTreeNode);
            this.makeNode("Product: " + this.dMeta.getDatabaseProductName(), defaultMutableTreeNode);
            this.makeNode("Version: " + this.dMeta.getDatabaseProductVersion(), defaultMutableTreeNode);
        }
        catch (SQLException sQLException) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Error getting metadata:", this.rootNode);
            this.makeNode(sQLException.getMessage(), defaultMutableTreeNode);
            this.makeNode(sQLException.getSQLState(), defaultMutableTreeNode);
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
    }
}

