/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import java.util.Vector;

public class HsqlDeque {
    private Vector list = new Vector(10, 0);
    private int firstindex = 0;
    private int endindex = 0;
    private int usedsize = 0;

    public HsqlDeque() {
        this.list.setSize(this.list.capacity());
    }

    public int size() {
        return this.usedsize;
    }

    public Object getFirst() throws NoSuchElementException {
        if (this.usedsize == 0) {
            throw new NoSuchElementException();
        }
        return this.list.elementAt(this.firstindex);
    }

    public Object getLast() throws NoSuchElementException {
        if (this.usedsize == 0) {
            throw new NoSuchElementException();
        }
        return this.list.elementAt(this.endindex - 1);
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        int n2 = this.getInternalIndex(n);
        return this.list.elementAt(n2);
    }

    public Object set(int n, Object object) throws IndexOutOfBoundsException {
        int n2 = this.getInternalIndex(n);
        Object e = this.list.elementAt(n2);
        this.list.setElementAt(object, n2);
        return e;
    }

    public Object removeFirst() throws NoSuchElementException {
        if (this.usedsize == 0) {
            throw new NoSuchElementException();
        }
        Object e = this.list.elementAt(this.firstindex);
        this.list.setElementAt(null, this.firstindex);
        ++this.firstindex;
        --this.usedsize;
        if (this.usedsize == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.firstindex == this.list.size()) {
            this.firstindex = 0;
        }
        return e;
    }

    public Object removeLast() throws NoSuchElementException {
        if (this.usedsize == 0) {
            throw new NoSuchElementException();
        }
        --this.endindex;
        Object e = this.list.elementAt(this.endindex);
        this.list.setElementAt(null, this.endindex);
        --this.usedsize;
        if (this.usedsize == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.endindex == 0) {
            this.endindex = this.list.size();
        }
        return e;
    }

    public boolean add(Object object) {
        this.resetCapacity();
        if (this.endindex == this.list.size()) {
            this.endindex = 0;
        }
        this.list.setElementAt(object, this.endindex);
        ++this.usedsize;
        ++this.endindex;
        return true;
    }

    public boolean addLast(Object object) {
        return this.add(object);
    }

    public boolean addFirst(Object object) {
        this.resetCapacity();
        --this.firstindex;
        if (this.firstindex < 0) {
            this.firstindex = this.list.size() - 1;
            if (this.endindex == 0) {
                this.endindex = this.list.size();
            }
        }
        this.list.setElementAt(object, this.firstindex);
        ++this.usedsize;
        return true;
    }

    public void clear() {
        this.usedsize = 0;
        this.endindex = 0;
        this.firstindex = 0;
        this.list.setSize(0);
        this.list.setSize(this.list.capacity());
    }

    private int getInternalIndex(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.usedsize) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.firstindex + n;
        if (n2 > this.list.size()) {
            n2 -= this.list.size();
        }
        return n2;
    }

    private void resetCapacity() {
        if (this.usedsize < this.list.capacity()) {
            return;
        }
        this.list.ensureCapacity(this.list.capacity() * 2);
        this.list.setSize(this.list.capacity());
        if (this.endindex <= this.firstindex) {
            int n = this.firstindex + this.usedsize - this.endindex;
            int n2 = 0;
            while (n2 < this.endindex) {
                this.list.setElementAt(this.list.elementAt(n2), n + n2);
                this.list.setElementAt(null, n2);
                ++n2;
            }
            this.endindex = this.firstindex + this.usedsize;
        }
    }
}

