/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hsqldb.Trace;
import org.hsqldb.jdbcConnection;
import org.hsqldb.jdbcResultSet;

public class jdbcStatement
implements Statement {
    private jdbcConnection cConnection;
    private jdbcResultSet rSet;
    private boolean bEscapeProcessing = true;
    private int iMaxRows;
    private int rsType = 1004;

    public ResultSet executeQuery(String string) throws SQLException {
        this.fetchResult(string);
        return this.rSet;
    }

    public int executeUpdate(String string) throws SQLException {
        this.fetchResult(string);
        if (this.rSet == null) {
            return -1;
        }
        return this.rSet.getUpdateCount();
    }

    public void close() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.closeOldResult();
        this.rSet = null;
    }

    public int getMaxFieldSize() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return 0;
    }

    public void setMaxFieldSize(int n) {
        if (Trace.TRACE) {
            Trace.trace();
        }
    }

    public int getMaxRows() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.iMaxRows;
    }

    public void setMaxRows(int n) {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.iMaxRows = n;
    }

    public void setEscapeProcessing(boolean bl) {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.bEscapeProcessing = bl;
    }

    public int getQueryTimeout() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return 0;
    }

    public void setQueryTimeout(int n) {
        if (Trace.TRACE) {
            Trace.trace();
        }
    }

    public void cancel() {
        if (Trace.TRACE) {
            Trace.trace();
        }
    }

    public SQLWarning getWarnings() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return null;
    }

    public void clearWarnings() {
        if (Trace.TRACE) {
            Trace.trace();
        }
    }

    public void setCursorName(String string) {
        if (Trace.TRACE) {
            Trace.trace();
        }
    }

    public boolean execute(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.fetchResult(string);
        if (this.rSet == null) {
            return false;
        }
        return this.rSet.isResult();
    }

    public ResultSet getResultSet() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.rSet != null && this.rSet.isResult()) {
            return this.rSet;
        }
        return null;
    }

    public int getUpdateCount() {
        if (this.rSet == null) {
            return -1;
        }
        return this.rSet.getUpdateCount();
    }

    public boolean getMoreResults() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.rSet != null) {
            this.rSet.close();
            this.rSet = null;
        }
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (n != 1000) {
            throw Trace.error(20);
        }
    }

    public int getFetchDirection() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return 1000;
    }

    public void setFetchSize(int n) {
        if (Trace.TRACE) {
            Trace.trace();
        }
    }

    public int getFetchSize() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return 1;
    }

    public int getResultSetConcurrency() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return 1007;
    }

    public int getResultSetType() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.rsType;
    }

    public void addBatch(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw Trace.error(20);
    }

    public void clearBatch() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw Trace.error(20);
    }

    public int[] executeBatch() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw Trace.error(20);
    }

    public Connection getConnection() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.cConnection;
    }

    jdbcStatement(jdbcConnection jdbcConnection2) {
        this.cConnection = jdbcConnection2;
        this.rsType = 1004;
    }

    jdbcStatement(jdbcConnection jdbcConnection2, int n) {
        this.cConnection = jdbcConnection2;
        this.rsType = n;
    }

    private void fetchResult(String string) throws SQLException {
        if (this.bEscapeProcessing) {
            string = this.cConnection.nativeSQL(string);
        }
        this.closeOldResult();
        if (this.iMaxRows == 0) {
            this.rSet = this.cConnection.execute(string);
        } else {
            try {
                string = "SET MAXROWS " + this.iMaxRows + ";" + string;
                this.rSet = this.cConnection.execute(string);
                this.cConnection.execute("SET MAXROWS 0");
            }
            catch (SQLException sQLException) {
                this.cConnection.execute("SET MAXROWS 0");
                throw sQLException;
            }
        }
        if (this.rSet != null) {
            this.rSet.sqlStatement = this;
            this.rSet.rsType = this.rsType;
        }
    }

    private void closeOldResult() {
        if (this.rSet != null) {
            this.rSet.close();
            this.rSet = null;
        }
    }
}

