/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.hsqldb.ByteArray;
import org.hsqldb.Column;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;
import org.hsqldb.jdbcConnection;
import org.hsqldb.jdbcStatement;

public class jdbcPreparedStatement
extends jdbcStatement
implements PreparedStatement,
CallableStatement {
    private String sSql;
    private Vector vParameter;
    private static final String sdfdPattern = "yyyy-MM-dd";
    private SimpleDateFormat sdfd;
    private static final String sdftPattern = "yyyy-MM-dd";
    private SimpleDateFormat sdft;
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss.";
    private SimpleDateFormat sdfts;

    public ResultSet executeQuery() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return super.executeQuery(this.build());
    }

    public int executeUpdate() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return super.executeUpdate(this.build());
    }

    public void setNull(int n, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setNull(n);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, bl ? "TRUE" : "FALSE");
    }

    public void setByte(int n, byte by) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, String.valueOf(by));
    }

    public void setShort(int n, short s) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, String.valueOf(s));
    }

    public void setInt(int n, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, String.valueOf(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, String.valueOf(l));
    }

    public void setFloat(int n, float f) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            this.setNull(n);
        } else {
            this.setParameter(n, String.valueOf(f));
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            this.setNull(n);
        } else {
            this.setParameter(n, String.valueOf(d));
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, Column.createSQLString(bigDecimal, 3));
    }

    public void setString(int n, String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, Column.createSQLString(string));
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (byArray == null) {
            this.setNull(n);
        } else {
            this.setParameter(n, Column.createSQLString(StringConverter.byteToHex(byArray)));
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, Column.createSQLString(date, 91));
    }

    public void setTime(int n, Time time) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, Column.createSQLString(time, 92));
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, Column.createSQLString(timestamp, 93));
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (inputStream == null) {
            this.setNull(n);
        } else {
            this.setString(n, StringConverter.inputStreamToString(inputStream));
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setAsciiStream(n, inputStream, n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw Trace.error(34, iOException.getMessage());
        }
        this.setBytes(n, byArray);
    }

    public void clearParameters() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.vParameter.removeAllElements();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setObject(n, object, n2);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (object == null) {
            this.setNull(n);
            return;
        }
        object = Column.convertObject(object, n2);
        this.setObjectInType(n, object, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (object == null) {
            this.setNull(n);
            return;
        }
        int n2 = 1111;
        if (object instanceof String) {
            n2 = 12;
        } else if (object instanceof BigDecimal) {
            n2 = 2;
        } else if (object instanceof Integer) {
            n2 = 4;
        } else if (object instanceof Long) {
            n2 = -5;
        } else if (object instanceof Float) {
            n2 = 7;
        } else if (object instanceof Double) {
            n2 = 8;
        } else if (object instanceof byte[]) {
            n2 = -2;
        } else if (object instanceof Date) {
            n2 = 91;
        } else if (object instanceof Time) {
            n2 = 92;
        } else if (object instanceof Timestamp) {
            n2 = 93;
        } else if (object instanceof Boolean) {
            n2 = -7;
        } else if (object instanceof Byte) {
            n2 = -6;
        } else if (object instanceof Short) {
            n2 = 5;
        }
        this.setObjectInType(n, object, n2);
    }

    public boolean execute() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return super.execute(this.build());
    }

    private void setParameter(int n, String string) {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.vParameter.size() < n) {
            this.vParameter.setSize(n);
        }
        this.vParameter.setElementAt(string, --n);
    }

    private String getParameter(int n) {
        if (n >= this.vParameter.size()) {
            return null;
        }
        return (String)this.vParameter.elementAt(n);
    }

    private String build() {
        if (this.vParameter.isEmpty()) {
            return this.sSql;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = this.sSql.length();
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            char c = this.sSql.charAt(n3);
            if (c == '?' && !bl && !bl2) {
                stringBuffer.append(this.getParameter(n++));
            } else {
                if (c == '\'' && !bl2) {
                    bl = !bl;
                } else if (c == '\"' && !bl) {
                    bl2 = !bl2;
                }
                stringBuffer.append(c);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private void setNull(int n) {
        this.setParameter(n, "NULL");
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        throw this.getNotSupported();
    }

    public boolean wasNull() throws SQLException {
        throw this.getNotSupported();
    }

    public String getString(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public boolean getBoolean(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public byte getByte(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public short getShort(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public int getInt(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public long getLong(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public float getFloat(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public double getDouble(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public byte[] getBytes(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Date getDate(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Time getTime(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Object getObject(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw this.getNotSupported();
    }

    public Ref getRef(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Blob getBlob(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Clob getClob(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Array getArray(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        String string = this.getParameter(n);
        if (this.sdfd == null) {
            this.sdfd = new SimpleDateFormat("yyyy-MM-dd");
        }
        this.sdfd.setCalendar(calendar);
        try {
            java.util.Date date = this.sdfd.parse(string.substring(1, 1 + "yyyy-MM-dd".length()));
            return new Date(date.getTime());
        }
        catch (ParseException parseException) {
            throw this.invalidValue();
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        String string = this.getParameter(n);
        if (this.sdft == null) {
            this.sdft = new SimpleDateFormat("yyyy-MM-dd");
        }
        this.sdft.setCalendar(calendar);
        try {
            java.util.Date date = this.sdft.parse(string.substring(1, 1 + "yyyy-MM-dd".length()));
            return new Time(date.getTime());
        }
        catch (ParseException parseException) {
            throw this.invalidValue();
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        String string = this.getParameter(n);
        if (this.sdfts == null) {
            this.sdfts = new SimpleDateFormat(sdftsPattern);
        }
        this.sdfts.setCalendar(calendar);
        try {
            java.util.Date date = this.sdfts.parse(string.substring(1, 1 + sdftsPattern.length()));
            String string2 = string.substring(1 + sdftsPattern.length(), string.length() - 1);
            Timestamp timestamp = new Timestamp(date.getTime());
            timestamp.setNanos(Integer.parseInt(string2));
            return timestamp;
        }
        catch (ParseException parseException) {
            throw this.invalidValue();
        }
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw this.getNotSupported();
    }

    public void addBatch() throws SQLException {
        throw this.getNotSupported();
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (date == null) {
            this.setNull(n);
        } else {
            if (this.sdfd == null) {
                this.sdfd = new SimpleDateFormat("yyyy-MM-dd");
            }
            this.sdfd.setCalendar(calendar);
            this.setParameter(n, Column.createSQLString(this.sdfd.format(date)));
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (time == null) {
            this.setNull(n);
        } else {
            if (this.sdft == null) {
                this.sdft = new SimpleDateFormat("yyyy-MM-dd");
            }
            this.sdft.setCalendar(calendar);
            this.setParameter(n, Column.createSQLString(this.sdft.format(time)));
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (timestamp == null) {
            this.setNull(n);
        } else {
            if (this.sdfts == null) {
                this.sdfts = new SimpleDateFormat(sdftsPattern);
            }
            this.sdfts.setCalendar(calendar);
            this.setParameter(n, Column.createSQLString(this.sdfts.format(new java.util.Date(((java.util.Date)timestamp).getTime())) + timestamp.getNanos()));
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw this.getNotSupported();
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw this.getNotSupported();
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw this.getNotSupported();
    }

    public void setArray(int n, Array array) throws SQLException {
        throw this.getNotSupported();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw this.getNotSupported();
    }

    jdbcPreparedStatement(jdbcConnection jdbcConnection2, String string) {
        super(jdbcConnection2);
        this.sSql = string;
        this.vParameter = new Vector();
    }

    jdbcPreparedStatement(jdbcConnection jdbcConnection2, String string, int n) {
        super(jdbcConnection2, n);
        this.sSql = string;
        this.vParameter = new Vector();
    }

    private void setObjectInType(int n, Object object, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (object == null) {
            this.setNull(n);
            return;
        }
        switch (n2) {
            case -7: {
                this.setBoolean(n, (boolean)((Boolean)object));
                break;
            }
            case -6: {
                this.setByte(n, (byte)((Byte)object));
                break;
            }
            case 5: {
                this.setShort(n, (short)((Short)object));
                break;
            }
            case 4: {
                this.setInt(n, (int)((Integer)object));
                break;
            }
            case -5: {
                this.setLong(n, (long)((Long)object));
                break;
            }
            case 7: {
                this.setFloat(n, ((Float)object).floatValue());
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(n, (double)((Double)object));
                break;
            }
            case 2: {
                this.setBigDecimal(n, (BigDecimal)object);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(n, (String)object);
                break;
            }
            case 91: {
                this.setDate(n, (Date)object);
                break;
            }
            case 92: {
                this.setTime(n, (Time)object);
                break;
            }
            case 93: {
                this.setTimestamp(n, (Timestamp)object);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                if (object instanceof ByteArray) {
                    object = ((ByteArray)object).byteValue();
                }
                this.setBytes(n, (byte[])object);
                break;
            }
            case 1111: {
                this.setParameter(n, Column.createSQLString(ByteArray.serializeToString(object)));
                break;
            }
            default: {
                this.setParameter(n, object.toString());
            }
        }
    }

    private SQLException getNotSupported() {
        return Trace.error(20);
    }

    private SQLException invalidValue() {
        return Trace.error(11);
    }
}

