/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.hsqldb.Database;
import org.hsqldb.HsqlProperties;
import org.hsqldb.HsqlServerProperties;
import org.hsqldb.WebServerConnection;
import org.hsqldb.jdbcSystem;

public class WebServer {
    static final String mServerName = "HSQL/1.7.0";
    String mRoot;
    String mDefaultFile;
    char mPathSeparatorChar;
    Database mDatabase;
    HsqlServerProperties serverProperties;
    private boolean traceMessages;

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length > 0 && (object = stringArray[0]) != null && ((String)object).startsWith("-?")) {
            WebServer.printHelp();
            return;
        }
        object = new WebServer();
        HsqlProperties hsqlProperties = HsqlProperties.argArrayToProps(stringArray, "server");
        ((WebServer)object).setProperties(hsqlProperties);
        super.run();
    }

    void setProperties(HsqlProperties hsqlProperties) {
        this.serverProperties = new HsqlServerProperties("webserver.properties");
        this.serverProperties.addProperties(hsqlProperties);
        this.serverProperties.setPropertyIfNotExists("server.database", "test");
        this.serverProperties.setPropertyIfNotExists("server.port", "80");
        this.mRoot = this.serverProperties.setPropertyIfNotExists("server.root", "./");
        this.mDefaultFile = this.serverProperties.setPropertyIfNotExists("server.default_page", "index.html");
        if (this.serverProperties.isPropertyTrue("server.trace")) {
            jdbcSystem.setLogToSystem(true);
        }
        this.traceMessages = !this.serverProperties.isPropertyTrue("server.silent");
    }

    private void run() {
        Object object;
        ServerSocket serverSocket = null;
        try {
            int n = Integer.parseInt(this.serverProperties.getProperty("server.port"));
            object = this.serverProperties.getProperty("server.database");
            System.out.println("Opening database: " + (String)object);
            this.printTraceMessages();
            this.mPathSeparatorChar = File.separatorChar;
            this.mDatabase = new Database((String)object);
            serverSocket = new ServerSocket(n);
        }
        catch (Exception exception) {
            this.traceError("WebServer.run/init: " + exception);
            return;
        }
        try {
            while (true) {
                Socket socket = serverSocket.accept();
                object = new WebServerConnection(socket, this);
                ((Thread)object).start();
            }
        }
        catch (IOException iOException) {
            this.traceError("WebServer.run/loop: " + iOException.getMessage());
            return;
        }
    }

    static void printHelp() {
        System.out.println("Usage: java WebServer [-options]\nwhere options include:\n    -port <nr>            port where the server is listening\n    -database <name>      name of the database\n    -root <path>          root path for sending files\n    -default_page <file>  default pagewhen page name is missing\n    -silent <true/false>  false means display all queries\n    -trace <true/false>   display print JDBC trace messages\nThe command line arguments override the values in the webserver.properties file.");
        System.exit(0);
    }

    void printTraceMessages() {
        this.trace("server.port        =" + this.serverProperties.getProperty("server.port"));
        this.trace("server.database    =" + this.serverProperties.getProperty("server.database"));
        this.trace("server.root        =" + this.serverProperties.getProperty("server.root"));
        this.trace("server.default_page=" + this.serverProperties.getProperty("server.default_page"));
        this.trace("server.silent      =" + this.serverProperties.getProperty("server.silent"));
        System.out.println("HSQLDB server 1.7.0 is running");
        System.out.println("Press [Ctrl]+[C] to abort");
    }

    void trace(String string) {
        if (this.traceMessages) {
            System.out.println(string);
        }
    }

    void traceError(String string) {
        System.out.println(string);
    }
}

