/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;

class Select {
    boolean bDistinct;
    TableFilter[] tFilter;
    Expression eCondition;
    Expression[] eColumn;
    int iResultLen;
    int iGroupLen;
    int iOrderLen;
    Select sUnion;
    String sIntoTable;
    int intoType = 0;
    boolean intoTemp;
    boolean isIntoTableQuoted;
    int iUnionType;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;
    int limitStart = 0;
    int limitCount = 0;

    Select() {
    }

    void resolve() throws SQLException {
        int n = this.tFilter.length;
        int n2 = 0;
        while (n2 < n) {
            this.resolve(this.tFilter[n2], true);
            ++n2;
        }
    }

    void resolve(TableFilter tableFilter, boolean bl) throws SQLException {
        if (this.eCondition != null) {
            this.eCondition.resolve(tableFilter);
            if (tableFilter != null && bl) {
                tableFilter.setCondition(this.eCondition);
            }
        }
        int n = this.eColumn.length;
        int n2 = 0;
        while (n2 < n) {
            this.eColumn[n2].resolve(tableFilter);
            ++n2;
        }
    }

    void checkResolved() throws SQLException {
        if (this.eCondition != null) {
            this.eCondition.checkResolved();
        }
        int n = this.eColumn.length;
        int n2 = 0;
        while (n2 < n) {
            this.eColumn[n2].checkResolved();
            ++n2;
        }
    }

    Object getValue(int n) throws SQLException {
        this.resolve();
        Result result = this.getResult(2);
        int n2 = result.getSize();
        int n3 = result.getColumnCount();
        Trace.check(n2 == 1 && n3 == 1, 17);
        Object object = result.rRoot.data[0];
        if (result.colType[0] == n) {
            return object;
        }
        String string = Column.convertObject(object);
        return Column.convertString(string, n);
    }

    Result getResult(int n) throws SQLException {
        int n2;
        Object object;
        Object[] objectArray;
        this.resolve();
        this.checkResolved();
        if (this.sUnion != null && this.sUnion.iResultLen != this.iResultLen) {
            throw Trace.error(5);
        }
        int n3 = this.eColumn.length;
        Result result = new Result(n3);
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < n3) {
            objectArray = this.eColumn[n4];
            result.colType[n4] = objectArray.getDataType();
            result.colSize[n4] = objectArray.getColumnSize();
            result.colScale[n4] = objectArray.getColumnScale();
            if (objectArray.isAggregate()) {
                bl = true;
            }
            ++n4;
        }
        objectArray = null;
        if (bl) {
            objectArray = new Object[n3];
        }
        if (this.iGroupLen > 0) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (n == 0) {
            n = this.limitCount;
        } else if (this.limitCount == 0) {
            this.limitCount = n;
        } else {
            this.limitCount = n > this.limitCount ? this.limitCount : n;
            n = this.limitCount;
        }
        if (n != 0 && !this.bDistinct && !bl2 && this.sUnion == null && this.iOrderLen == 0) {
            bl3 = true;
        }
        int n5 = 0;
        int n6 = this.tFilter.length;
        boolean[] blArray = new boolean[n6];
        int n7 = 0;
        while (n7 >= 0) {
            boolean bl4;
            object = this.tFilter[n7];
            blArray[n7] = !blArray[n7] ? (bl4 = ((TableFilter)object).findFirst()) : (bl4 = ((TableFilter)object).next());
            if (!bl4) {
                --n7;
                continue;
            }
            if (n7 < n6 - 1) {
                ++n7;
                continue;
            }
            if (this.eCondition != null && !this.eCondition.test()) continue;
            Object[] objectArray2 = new Object[n3];
            n2 = 0;
            while (n2 < n3) {
                objectArray2[n2] = this.eColumn[n2].getValue();
                ++n2;
            }
            ++n5;
            if (bl) {
                this.updateAggregateRow(objectArray, objectArray2, n3);
                if (!bl2) continue;
                result.add(objectArray2);
                continue;
            }
            result.add(objectArray2);
            if (bl3 && n5 >= this.limitStart + n) break;
        }
        if (bl && !bl2) {
            this.addAggregateRow(result, objectArray, n3, n5);
        } else if (bl2) {
            object = new int[this.iGroupLen];
            int[] nArray = new int[this.iGroupLen];
            int n8 = this.iResultLen;
            n2 = 0;
            while (n2 < this.iGroupLen) {
                object[n2] = n8;
                nArray[n2] = 1;
                ++n8;
                ++n2;
            }
            result.sortResult((int[])object, nArray);
            Record record = result.rRoot;
            Result result2 = new Result(n3);
            int n9 = 0;
            while (n9 < n3) {
                result2.colType[n9] = result.colType[n9];
                ++n9;
            }
            do {
                Object[] objectArray3 = new Object[n3];
                n5 = 0;
                boolean bl5 = false;
                while (record != null && !bl5) {
                    ++n5;
                    int n10 = this.iResultLen;
                    while (n10 < this.iResultLen + this.iGroupLen) {
                        if (record.next == null) {
                            bl5 = true;
                        } else if (Column.compare(record.data[n10], record.next.data[n10], result.colType[n10]) != 0) {
                            bl5 = true;
                        }
                        ++n10;
                    }
                    this.updateAggregateRow(objectArray3, record.data, n3);
                    record = record.next;
                }
                if (!bl && n5 <= 0) continue;
                this.addAggregateRow(result2, objectArray3, n3, n5);
            } while (record != null);
            result = result2;
        }
        if (this.iOrderLen != 0) {
            object = new int[this.iOrderLen];
            int[] nArray = new int[this.iOrderLen];
            int n11 = this.iResultLen + (bl2 ? this.iGroupLen : 0);
            n2 = 0;
            while (n2 < this.iOrderLen) {
                object[n2] = n11;
                nArray[n2] = this.eColumn[n11].isDescending() ? -1 : 1;
                ++n11;
                ++n2;
            }
            result.sortResult((int[])object, nArray);
        }
        result.setColumnCount(this.iResultLen);
        if (this.bDistinct) {
            result.removeDuplicates();
        }
        int n12 = 0;
        while (n12 < this.iResultLen) {
            Expression expression = this.eColumn[n12];
            result.sLabel[n12] = expression.getAlias();
            result.sTable[n12] = expression.getTableName();
            result.sName[n12] = expression.getColumnName();
            ++n12;
        }
        result.trimResult(this.limitStart, this.limitCount);
        if (this.sUnion != null) {
            Result result3 = this.sUnion.getResult(0);
            if (this.iUnionType == 1) {
                result.append(result3);
                result.removeDuplicates();
            } else if (this.iUnionType == 2) {
                result.append(result3);
            } else if (this.iUnionType == 3) {
                result.removeDifferent(result3);
            } else if (this.iUnionType == 4) {
                result.removeSecond(result3);
            }
        }
        return result;
    }

    private void updateAggregateRow(Object[] objectArray, Object[] objectArray2, int n) throws SQLException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.eColumn[n2].getDataType();
            switch (this.eColumn[n2].getType()) {
                case 40: 
                case 41: 
                case 44: {
                    objectArray[n2] = Column.sum(objectArray[n2], objectArray2[n2], n3);
                    break;
                }
                case 42: {
                    objectArray[n2] = Column.min(objectArray[n2], objectArray2[n2], n3);
                    break;
                }
                case 43: {
                    objectArray[n2] = Column.max(objectArray[n2], objectArray2[n2], n3);
                    break;
                }
                default: {
                    objectArray[n2] = objectArray2[n2];
                }
            }
            ++n2;
        }
    }

    private void addAggregateRow(Result result, Object[] objectArray, int n, int n2) throws SQLException {
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.eColumn[n3].getType();
            if (n4 == 44) {
                objectArray[n3] = Column.avg(objectArray[n3], this.eColumn[n3].getDataType(), n2);
            } else if (n4 == 40 && objectArray[n3] == null) {
                objectArray[n3] = new Integer(0);
            }
            ++n3;
        }
        result.add(objectArray);
    }
}

