/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.sql.SQLException;
import org.hsqldb.BinaryDatabaseRowInput;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.Node;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class Row {
    static final int NO_POS = -1;
    private Object[] oData;
    private Table tTable;
    static int iCurrentAccess = 0;
    int iLastAccess;
    Row rLast;
    Row rNext;
    int iPos = -1;
    int iSize;
    private boolean bChanged;
    private Node nFirstIndex;

    Row(Table table, Object[] objectArray) throws SQLException {
        this.tTable = table;
        int n = this.tTable.getIndexCount();
        Node node = this.nFirstIndex = new Node(this, 0);
        int n2 = 1;
        while (n2 < n) {
            node = node.nNext = new Node(this, n2);
            ++n2;
        }
        this.oData = objectArray;
        this.iLastAccess = iCurrentAccess++;
        this.tTable.putRow(this);
        this.bChanged = true;
    }

    void setPos(int n) {
        this.iPos = n;
        Node node = this.nFirstIndex;
        while (node != null) {
            node.setKey(n);
            node = node.nNext;
        }
    }

    void changed() {
        this.bChanged = true;
        this.iLastAccess = iCurrentAccess++;
    }

    boolean hasChanged() {
        return this.bChanged;
    }

    Node getNode(int n) {
        Node node = this.nFirstIndex;
        while (n-- > 0) {
            node = node.nNext;
        }
        this.iLastAccess = iCurrentAccess++;
        return node;
    }

    Object[] getData() {
        this.iLastAccess = iCurrentAccess++;
        return this.oData;
    }

    Table getTable() {
        return this.tTable;
    }

    Row(Table table, BinaryDatabaseRowInput binaryDatabaseRowInput) throws IOException, SQLException {
        this.tTable = table;
        int n = this.tTable.getIndexCount();
        this.iPos = binaryDatabaseRowInput.getPos();
        Node node = this.nFirstIndex = new Node(this, binaryDatabaseRowInput, 0);
        int n2 = 1;
        while (n2 < n) {
            node = node.nNext = new Node(this, binaryDatabaseRowInput, n2);
            ++n2;
        }
        int[] nArray = this.tTable.getColumnTypes();
        this.oData = binaryDatabaseRowInput.readData(nArray);
        Trace.check(binaryDatabaseRowInput.readInt() == this.iPos, 34);
        this.iLastAccess = iCurrentAccess++;
    }

    void index() throws SQLException {
        Node node = this.tTable.indexRow(this);
        if (node != null) {
            this.nFirstIndex = node;
        }
    }

    void insert(Row row) {
        if (row == null) {
            this.rNext = this;
            this.rLast = this;
        } else {
            this.rNext = row;
            this.rLast = row.rLast;
            row.rLast = this;
            this.rLast.rNext = this;
        }
    }

    boolean isRoot() throws SQLException {
        Node node = this.nFirstIndex;
        while (node != null) {
            if (node.iParent == -1 && node.nParent == null) {
                return true;
            }
            node = node.nNext;
        }
        return false;
    }

    void write(DatabaseRowOutputInterface databaseRowOutputInterface) throws IOException, SQLException {
        databaseRowOutputInterface.writeSize(this.iSize);
        if (this.tTable.isIndexCached()) {
            Node node = this.nFirstIndex;
            while (node != null) {
                node.write(databaseRowOutputInterface);
                node = node.nNext;
            }
        }
        databaseRowOutputInterface.writeData(this.oData, this.tTable);
        databaseRowOutputInterface.writePos(this.iPos);
        this.bChanged = false;
    }

    void delete() throws SQLException {
        this.bChanged = false;
        this.tTable.removeRow(this);
        this.oData = null;
        this.rLast = null;
        this.rNext = null;
        this.tTable = null;
        this.nFirstIndex = null;
    }

    void free() throws SQLException {
        this.rLast.rNext = this.rNext;
        this.rNext.rLast = this.rLast;
        if (this.rNext == this) {
            this.rLast = null;
            this.rNext = null;
        }
    }
}

