/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.SQLException;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Trace;

public class HsqlDatabaseProperties
extends HsqlProperties {
    private final String fileName;
    private FileInputStream propsFileStream;

    HsqlDatabaseProperties(String string) {
        this.fileName = string;
        this.setProperty("jdbc.get_column_name", true);
        this.setProperty("sql.month", true);
        this.setProperty("sql.enforce_size", false);
        this.setProperty("sql.compare_in_locale", false);
        this.setProperty("sql.strict_fk", false);
        this.setProperty("sql.strong_fk", false);
        this.setProperty("version", "1.7.0");
        this.setProperty("readonly", false);
        this.setProperty("modified", "no");
    }

    protected void close() throws SQLException {
        try {
            if (this.propsFileStream != null) {
                if (Trace.TRACE) {
                    Trace.trace();
                }
                this.propsFileStream.close();
                this.propsFileStream = null;
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, this.fileName + ".properties " + exception);
        }
    }

    protected void load() throws SQLException {
        this.close();
        if (Trace.TRACE) {
            Trace.trace();
        }
        try {
            File file = new File(this.fileName + ".properties");
            this.propsFileStream = new FileInputStream(file);
            this.stringProps.load(this.propsFileStream);
        }
        catch (Exception exception) {
            throw Trace.error(29, this.fileName + ".properties " + exception);
        }
    }

    protected void save() throws SQLException {
        File file = new File(this.fileName + ".properties");
        this.close();
        if (Trace.TRACE) {
            Trace.trace();
        }
        try {
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.stringProps.store(fileOutputStream, "HSQL database");
            fileOutputStream.close();
            this.load();
        }
        catch (Exception exception) {
            throw Trace.error(29, this.fileName + ".properties " + exception);
        }
    }

    protected boolean isFileOpen() throws SQLException {
        this.close();
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (!new File(this.fileName + ".properties").delete()) {
            return true;
        }
        this.save();
        return false;
    }

    protected boolean checkFileExists() {
        return new File(this.fileName + ".properties").exists();
    }
}

