/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.ByteArray;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.Table;

abstract class DatabaseRowOutput
extends DataOutputStream
implements DatabaseRowOutputInterface {
    private boolean skipSystemId = false;

    public DatabaseRowOutput(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    abstract void writeType(int var1) throws IOException;

    public abstract void writeIntData(int var1) throws IOException;

    abstract void writeLongData(long var1) throws IOException;

    abstract void writeNull() throws IOException;

    abstract void writeVarNull() throws IOException;

    abstract void writeLongVarNull() throws IOException;

    abstract void writeString(String var1) throws IOException;

    abstract void writeVarString(String var1) throws IOException;

    abstract void writeLongVarString(String var1) throws IOException;

    abstract void writeByteArray(byte[] var1) throws IOException;

    abstract void writeVarByteArray(byte[] var1) throws IOException;

    abstract void writeLongVarByteArray(byte[] var1) throws IOException;

    public void writeData(Object[] objectArray, Table table) throws IOException {
        int[] nArray = table.getColumnTypes();
        int n = nArray.length;
        if (this.skipSystemId) {
            --n;
        }
        this.writeData(n, nArray, objectArray);
    }

    public void writeData(int n, int[] nArray, Object[] objectArray) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == null) {
                switch (nArray[n2]) {
                    case -3: 
                    case 12: 
                    case 100: {
                        this.writeVarNull();
                        break;
                    }
                    case -4: 
                    case -1: {
                        this.writeLongVarNull();
                        break;
                    }
                    default: {
                        this.writeNull();
                        break;
                    }
                }
            } else {
                int n3 = nArray[n2];
                this.writeType(n3);
                switch (n3) {
                    case 4: {
                        this.writeIntData((Integer)object);
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.writeLongData(Double.doubleToLongBits((Double)object));
                        break;
                    }
                    case -2: 
                    case 1111: {
                        this.writeByteArray(((ByteArray)object).byteValue());
                        break;
                    }
                    case -3: {
                        this.writeVarByteArray(((ByteArray)object).byteValue());
                        break;
                    }
                    case -4: {
                        this.writeLongVarByteArray(((ByteArray)object).byteValue());
                        break;
                    }
                    case 12: 
                    case 100: {
                        this.writeVarString(object.toString());
                        break;
                    }
                    case -1: {
                        this.writeLongVarString(object.toString());
                        break;
                    }
                    default: {
                        this.writeString(object.toString());
                    }
                }
            }
            ++n2;
        }
    }

    public abstract byte[] toByteArray() throws IOException;

    public abstract void writeSize(int var1) throws IOException;

    public abstract void writePos(int var1) throws IOException;
}

