/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Access;
import org.hsqldb.Channel;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.DatabaseInformation;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.Index;
import org.hsqldb.Library;
import org.hsqldb.Log;
import org.hsqldb.Parser;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.TextTable;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Trigger;
import org.hsqldb.TriggerDef;
import org.hsqldb.User;
import org.hsqldb.jdbcResultSet;

class Database {
    private String sName;
    private Access aAccess;
    private Vector tTable;
    private DatabaseInformation dInfo;
    private Logger logger;
    private boolean bReadOnly;
    private boolean bShutdown;
    private Hashtable hAlias;
    private boolean bIgnoreCase;
    private boolean bReferentialIntegrity;
    private Vector cChannel;
    private HsqlDatabaseProperties databaseProperties;
    private static final int CALL = 1;
    private static final int CHECKPOINT = 2;
    private static final int COMMIT = 3;
    private static final int CONNECT = 4;
    private static final int CREATE = 5;
    private static final int DELETE = 6;
    private static final int DISCONNECT = 7;
    private static final int DROP = 8;
    private static final int GRANT = 9;
    private static final int INSERT = 10;
    private static final int REVOKE = 11;
    private static final int ROLLBACK = 12;
    private static final int SAVEPOINT = 13;
    private static final int SCRIPT = 14;
    private static final int SELECT = 15;
    private static final int SET = 16;
    private static final int SHUTDOWN = 17;
    private static final int UPDATE = 18;
    private static final int SEMICOLON = 19;
    private static final Hashtable hCommands = new Hashtable(37);

    Database(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.sName = string;
        this.tTable = new Vector();
        this.aAccess = new Access();
        this.cChannel = new Vector();
        this.hAlias = new Hashtable();
        this.logger = new Logger();
        this.bReferentialIntegrity = true;
        Library.register(this.hAlias);
        this.dInfo = new DatabaseInformation(this, this.tTable, this.aAccess);
        boolean bl = false;
        Channel channel = new Channel(this, new User(null, null, true, null), true, false, 0);
        this.registerChannel(channel);
        this.databaseProperties = new HsqlDatabaseProperties(string);
        bl = string.equals(".") ? true : this.logger.openLog(this, channel, string);
        Library.setSqlMonth(this.databaseProperties.isPropertyTrue("sql.month"));
        Parser.setEnforceSize(this.databaseProperties.isPropertyTrue("sql.enforce_size"));
        Column.setCompareInLocal(this.databaseProperties.isPropertyTrue("sql.compare_in_locale"));
        jdbcResultSet.setGetColumnName(this.databaseProperties.isPropertyTrue("jdbc.get_column_name"));
        if (bl) {
            this.databaseProperties.setProperty("sql.strict_fk", true);
            this.execute("CREATE USER SA PASSWORD \"\" ADMIN", channel);
        }
        this.aAccess.grant("PUBLIC", "CLASS \"java.lang.Math\"", 15);
        this.aAccess.grant("PUBLIC", "CLASS \"org.hsqldb.Library\"", 15);
    }

    String getName() {
        return this.sName;
    }

    HsqlDatabaseProperties getProperties() {
        return this.databaseProperties;
    }

    boolean isShutdown() {
        return this.bShutdown;
    }

    synchronized Channel connect(String string, String string2) throws SQLException {
        int n;
        User user = this.aAccess.getUser(string.toUpperCase(), string2.toUpperCase());
        int n2 = n = this.cChannel.size();
        int n3 = 0;
        while (n3 < n) {
            if (this.cChannel.elementAt(n3) == null) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        Channel channel = new Channel(this, user, true, this.bReadOnly, n2);
        this.logger.writeToLog(channel, "CONNECT USER " + string + " PASSWORD \"" + string2 + "\"");
        this.registerChannel(channel);
        return channel;
    }

    void registerChannel(Channel channel) {
        int n = this.cChannel.size();
        int n2 = channel.getId();
        if (n2 >= n) {
            this.cChannel.setSize(n2 + 1);
        }
        this.cChannel.setElementAt(channel, n2);
    }

    byte[] execute(String string, String string2, String string3) {
        Result result = null;
        try {
            Channel channel = this.connect(string, string2);
            result = this.execute(string3, channel);
            this.execute("DISCONNECT", channel);
        }
        catch (SQLException sQLException) {
            result = new Result(sQLException.getMessage(), sQLException.getErrorCode());
        }
        catch (Exception exception) {
            result = new Result(exception.getMessage(), 40);
        }
        try {
            return result.getBytes();
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    synchronized Result execute(String string, Channel channel) {
        if (Trace.TRACE) {
            Trace.trace(string);
        }
        Result result = null;
        try {
            Tokenizer tokenizer = new Tokenizer(string);
            Parser parser = new Parser(this, tokenizer, channel);
            this.logger.cleanUp();
            Trace.check(channel != null, 33);
            Trace.check(!this.bShutdown, 4);
            while (true) {
                tokenizer.setPartMarker();
                channel.setScripting(false);
                String string2 = tokenizer.getString();
                if (string2.length() != 0) {
                    Integer n = (Integer)hCommands.get(string2);
                    if (n == null) {
                        throw Trace.error(11, string2);
                    }
                    int n2 = n;
                    switch (n2) {
                        case 15: {
                            result = parser.processSelect();
                            break;
                        }
                        case 10: {
                            result = parser.processInsert();
                            break;
                        }
                        case 18: {
                            result = parser.processUpdate();
                            break;
                        }
                        case 6: {
                            result = parser.processDelete();
                            break;
                        }
                        case 1: {
                            result = parser.processCall();
                            break;
                        }
                        case 16: {
                            result = this.processSet(tokenizer, channel);
                            break;
                        }
                        case 3: {
                            result = this.processCommit(tokenizer, channel);
                            channel.setScripting(true);
                            break;
                        }
                        case 12: {
                            result = this.processRollback(tokenizer, channel);
                            channel.setScripting(true);
                            break;
                        }
                        case 13: {
                            result = this.processSavepoint(tokenizer, channel);
                            channel.setScripting(true);
                            break;
                        }
                        case 5: {
                            result = this.processCreate(tokenizer, channel);
                            break;
                        }
                        case 8: {
                            result = this.processDrop(tokenizer, channel);
                            break;
                        }
                        case 9: {
                            result = this.processGrantOrRevoke(tokenizer, channel, true);
                            break;
                        }
                        case 11: {
                            result = this.processGrantOrRevoke(tokenizer, channel, false);
                            break;
                        }
                        case 4: {
                            result = this.processConnect(tokenizer, channel);
                            break;
                        }
                        case 7: {
                            result = this.processDisconnect(tokenizer, channel);
                            break;
                        }
                        case 14: {
                            result = this.processScript(tokenizer, channel);
                            break;
                        }
                        case 17: {
                            result = this.processShutdown(tokenizer, channel);
                            break;
                        }
                        case 2: {
                            result = this.processCheckpoint(channel);
                            break;
                        }
                    }
                    if (!channel.getScripting()) continue;
                    this.logger.writeToLog(channel, tokenizer.getLastPart());
                    continue;
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            result = new Result(Trace.getMessage(sQLException) + " in statement [" + string + "]", sQLException.getErrorCode());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string3 = Trace.getMessage(40) + " " + exception;
            result = new Result(string3 + " in statement [" + string + "]", 40);
        }
        return result == null ? new Result() : result;
    }

    void setReadOnly() {
        this.bReadOnly = true;
    }

    Vector getTables() {
        return this.tTable;
    }

    void setReferentialIntegrity(boolean bl) {
        this.bReferentialIntegrity = bl;
    }

    boolean isReferentialIntegrity() {
        return this.bReferentialIntegrity;
    }

    Hashtable getAlias() {
        return this.hAlias;
    }

    String getAlias(String string) {
        String string2 = (String)this.hAlias.get(string);
        return string2 == null ? string : string2;
    }

    Log getLog() {
        return this.logger.lLog;
    }

    Table getTable(String string, Channel channel) throws SQLException {
        Table table = null;
        int n = 0;
        int n2 = this.tTable.size();
        while (n < n2) {
            table = (Table)this.tTable.elementAt(n);
            if (table.equals(string, channel)) {
                return table;
            }
            ++n;
        }
        table = this.dInfo.getSystemTable(string, channel);
        if (table == null) {
            throw Trace.error(22, string);
        }
        return table;
    }

    Result getScript(boolean bl, boolean bl2, boolean bl3, Channel channel) throws SQLException {
        return this.dInfo.getScript(bl, bl2, bl3, channel);
    }

    void linkTable(Table table) throws SQLException {
        String string = table.getName();
        int n = 0;
        int n2 = this.tTable.size();
        while (n < n2) {
            Table table2 = (Table)this.tTable.elementAt(n);
            if (table2.getName().equals(string)) {
                throw Trace.error(21, string);
            }
            ++n;
        }
        this.tTable.addElement(table);
    }

    boolean isIgnoreCase() {
        return this.bIgnoreCase;
    }

    private Result processScript(Tokenizer tokenizer, Channel channel) throws SQLException {
        String string = tokenizer.getString();
        if (tokenizer.wasValue()) {
            string = (String)tokenizer.getAsValue();
            Log.scriptToFile(this, string, true, channel);
            return new Result();
        }
        tokenizer.back();
        return this.getScript(false, true, false, channel);
    }

    private Result processCreate(Tokenizer tokenizer, Channel channel) throws SQLException {
        channel.checkReadWrite();
        channel.checkAdmin();
        String string = tokenizer.getString();
        boolean bl = false;
        if (string.equals("TEMP")) {
            bl = true;
            string = tokenizer.getString();
            Trace.check(string.equals("TABLE") || string.equals("MEMORY") || string.equals("TEXT"), 11, string);
            channel.setScripting(false);
        } else {
            channel.checkReadWrite();
            channel.checkAdmin();
            channel.setScripting(true);
        }
        if (string.equals("TABLE")) {
            this.processCreateTable(tokenizer, channel, bl, 0);
        } else if (string.equals("MEMORY")) {
            tokenizer.getThis("TABLE");
            this.processCreateTable(tokenizer, channel, bl, 0);
        } else if (string.equals("CACHED")) {
            tokenizer.getThis("TABLE");
            this.processCreateTable(tokenizer, channel, bl, 1);
        } else if (string.equals("TEXT")) {
            tokenizer.getThis("TABLE");
            this.processCreateTable(tokenizer, channel, bl, 2);
        } else if (string.equals("TRIGGER")) {
            this.processCreateTrigger(tokenizer, channel);
        } else if (string.equals("USER")) {
            String string2 = tokenizer.getStringToken();
            tokenizer.getThis("PASSWORD");
            String string3 = tokenizer.getStringToken();
            boolean bl2 = tokenizer.getString().equals("ADMIN");
            this.aAccess.createUser(string2, string3, bl2);
        } else if (string.equals("ALIAS")) {
            String string4 = tokenizer.getString();
            string = tokenizer.getString();
            Trace.check(string.equals("FOR"), 11, string);
            string = tokenizer.getString();
            if (string.startsWith("org.hsql.Library.")) {
                string = "org.hsqldb.Library." + string.substring("org.hsql.Library.".length());
            } else if (string.equals("java.lang.Math.abs")) {
                string = "org.hsqldb.Library.abs";
            }
            this.hAlias.put(string4, string);
        } else {
            boolean bl3 = false;
            if (string.equals("UNIQUE")) {
                bl3 = true;
                string = tokenizer.getString();
            }
            if (!string.equals("INDEX")) {
                throw Trace.error(11, string);
            }
            String string5 = tokenizer.getName();
            tokenizer.getThis("ON");
            Table table = this.getTable(tokenizer.getString(), channel);
            this.addIndexOn(tokenizer, channel, string5, table, bl3);
        }
        return new Result();
    }

    private int[] processColumnList(Tokenizer tokenizer, Table table) throws SQLException {
        Vector<String> vector;
        block2: {
            String string;
            vector = new Vector<String>();
            tokenizer.getThis("(");
            do {
                vector.addElement(tokenizer.getString());
                string = tokenizer.getString();
                if (string.equals(")")) break block2;
            } while (string.equals(","));
            throw Trace.error(11, string);
        }
        int n = vector.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = table.getColumnNr((String)vector.elementAt(n2));
            ++n2;
        }
        return nArray;
    }

    private void addIndexOn(Tokenizer tokenizer, Channel channel, String string, Table table, boolean bl) throws SQLException {
        if (string.startsWith("SYSTEM_")) {
            string = "USER_" + string.substring("SYSTEM_".length());
        }
        if (this.findIndex(string) != null) {
            throw Trace.error(23, string);
        }
        channel.setScripting(!table.isTemp());
        int[] nArray = this.processColumnList(tokenizer, table);
        channel.commit();
        table.createIndex(nArray, string, bl);
    }

    private Index findIndex(String string) {
        int n = 0;
        int n2 = this.tTable.size();
        while (n < n2) {
            Table table = (Table)this.tTable.elementAt(n);
            if (table.getIndex(string) != null) {
                return table.getIndex(string);
            }
            ++n;
        }
        return null;
    }

    int getTableIndex(Table table) {
        int n = 0;
        int n2 = this.tTable.size();
        while (n < n2) {
            Table table2 = (Table)this.tTable.elementAt(n);
            if (table2 == table) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCreateTrigger(Tokenizer tokenizer, Channel channel) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        int n = TriggerDef.getDefaultQueueSize();
        String string = tokenizer.getName();
        String string2 = tokenizer.getString();
        String string3 = tokenizer.getString();
        tokenizer.getThis("ON");
        String string4 = tokenizer.getString();
        Table table = this.getTable(string4, channel);
        channel.setScripting(!table.isTemp());
        String string5 = tokenizer.getString();
        if (string5.equals("FOR")) {
            string5 = tokenizer.getString();
            if (!string5.equals("EACH")) throw Trace.error(12, string5);
            string5 = tokenizer.getString();
            if (!string5.equals("ROW")) throw Trace.error(12, string5);
            bl = true;
            string5 = tokenizer.getString();
        }
        if (string5.equals("NOWAIT")) {
            bl2 = true;
            string5 = tokenizer.getString();
        }
        if (string5.equals("QUEUE")) {
            n = Integer.parseInt(tokenizer.getString());
            string5 = tokenizer.getString();
        }
        if (!string5.equals("CALL")) {
            throw Trace.error(12, string5);
        }
        String string6 = tokenizer.getString();
        try {
            Class<?> clazz = Class.forName(string6);
            Trigger trigger = (Trigger)clazz.newInstance();
            TriggerDef triggerDef = new TriggerDef(string, string2, string3, bl, table, trigger, "\"" + string6 + "\"", bl2, n);
            if (!triggerDef.isValid()) {
                String string7 = "Error in parsing trigger command ";
                throw Trace.error(11, string7);
            }
            table.addTrigger(triggerDef);
            triggerDef.start();
            return;
        }
        catch (Exception exception) {
            String string8 = "Exception in loading trigger class " + exception.getMessage();
            throw Trace.error(13, string8);
        }
    }

    private boolean processCreateColumn(Tokenizer tokenizer, Table table) throws SQLException {
        String string;
        String string2;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = string2 = tokenizer.getString();
        boolean bl3 = tokenizer.wasQuotedIdentifier();
        int n = Column.getTypeNr(tokenizer.getString());
        if (n == 12 && this.bIgnoreCase) {
            n = 100;
        }
        string2 = tokenizer.getString();
        if (n == 8 && string2.equals("PRECISION")) {
            string2 = tokenizer.getString();
        }
        String string4 = "";
        if (string2.equals("(")) {
            do {
                if ((string2 = tokenizer.getString()).equals(")")) continue;
                string4 = string4 + string2;
            } while (!string2.equals(")"));
            string2 = tokenizer.getString();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = string4.indexOf(",");
        if (n4 != -1) {
            string = string4.substring(n4 + 1, string4.length());
            string4 = string4.substring(0, n4);
            try {
                n3 = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(11, string4);
            }
        }
        if (string4.trim().length() > 0) {
            try {
                n2 = Integer.parseInt(string4.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(11, string4);
            }
        }
        string = null;
        if (string2.equals("DEFAULT")) {
            String string5 = tokenizer.getString();
            if (tokenizer.wasValue()) {
                string = String.valueOf(tokenizer.getAsValue());
                try {
                    Column.convertString(string, n);
                }
                catch (Exception exception) {
                    throw Trace.error(46, string);
                }
            } else {
                throw Trace.error(46, string5);
            }
            String string6 = (String)Parser.enforceSize(string, n, n2, false);
            if (!string.equals(string6)) {
                throw Trace.error(46, string);
            }
            string2 = tokenizer.getString();
        }
        boolean bl4 = true;
        if (string2.equals("NULL")) {
            string2 = tokenizer.getString();
        } else if (string2.equals("NOT")) {
            tokenizer.getThis("NULL");
            bl4 = false;
            string2 = tokenizer.getString();
        }
        if (string2.equals("IDENTITY")) {
            bl = true;
            string2 = tokenizer.getString();
            bl2 = true;
        }
        if (string2.equals("PRIMARY")) {
            tokenizer.getThis("KEY");
            bl2 = true;
        } else {
            tokenizer.back();
        }
        table.addColumn(string3, bl3, n, n2, n3, bl4, bl, string);
        return bl2;
    }

    private void processCreateTable(Tokenizer tokenizer, Channel channel, boolean bl, int n) throws SQLException {
        String string = tokenizer.getName();
        boolean bl2 = tokenizer.wasQuotedIdentifier();
        if (DatabaseInformation.isSystemTable(string)) {
            throw Trace.error(21, string);
        }
        Table table = n == 2 ? new TextTable(this, bl, string) : (n == 1 && this.logger.hasLog() ? new Table(this, bl, string, bl2, true) : new Table(this, bl, string, bl2, false));
        tokenizer.getThis("(");
        int[] nArray = null;
        int n2 = 0;
        boolean bl3 = false;
        while (true) {
            string = tokenizer.getString();
            bl2 = tokenizer.wasQuotedIdentifier();
            if (string.equals("CONSTRAINT") || string.equals("PRIMARY") || string.equals("FOREIGN") || string.equals("UNIQUE")) {
                tokenizer.back();
                bl3 = true;
                break;
            }
            tokenizer.back();
            boolean bl4 = this.processCreateColumn(tokenizer, table);
            if (bl4) {
                Trace.check(nArray == null, 24, "column " + n2);
                nArray = new int[]{n2};
            }
            if ((string = tokenizer.getString()).equals(")")) break;
            if (!string.equals(",")) {
                throw Trace.error(11, string);
            }
            ++n2;
        }
        try {
            Object object;
            int n3;
            TempConstraint tempConstraint;
            Vector<TempConstraint> vector;
            block23: {
                vector = new Vector<TempConstraint>();
                tempConstraint = new TempConstraint(null, nArray, null, null, 1, false);
                vector.addElement(tempConstraint);
                if (bl3) {
                    n3 = 0;
                    do {
                        String string2;
                        int[] nArray2;
                        string = tokenizer.getString();
                        object = null;
                        ++n3;
                        if (string.equals("CONSTRAINT")) {
                            object = tokenizer.getString();
                            string = tokenizer.getString();
                        }
                        if (string.equals("PRIMARY")) {
                            tokenizer.getThis("KEY");
                            nArray2 = this.processColumnList(tokenizer, table);
                            string2 = "SYSTEM_CT_" + table.getName() + "_" + n3;
                            tempConstraint = new TempConstraint(string2, nArray2, null, null, 1, false);
                            vector.addElement(tempConstraint);
                        } else if (string.equals("UNIQUE")) {
                            nArray2 = this.processColumnList(tokenizer, table);
                            if (object == null) {
                                object = "SYSTEM_CT_" + table.getName() + "_" + n3;
                            }
                            tempConstraint = new TempConstraint((String)object, nArray2, null, null, 2, false);
                            vector.addElement(tempConstraint);
                        } else if (string.equals("FOREIGN")) {
                            tokenizer.getThis("KEY");
                            nArray2 = this.processColumnList(tokenizer, table);
                            tokenizer.getThis("REFERENCES");
                            string2 = tokenizer.getString();
                            Table table2 = table.getName().equals(string2) ? table : this.getTable(string2, channel);
                            int[] nArray3 = this.processColumnList(tokenizer, table2);
                            string = tokenizer.getString();
                            boolean bl5 = false;
                            if (string.equals("ON")) {
                                tokenizer.getThis("DELETE");
                                tokenizer.getThis("CASCADE");
                                bl5 = true;
                            } else {
                                tokenizer.back();
                            }
                            String string3 = "SYSTEM_FK_" + table.getName() + "_" + n3;
                            object = object != null ? object : string3;
                            tempConstraint = new TempConstraint((String)object, nArray2, table2, nArray3, 0, bl5);
                            vector.addElement(tempConstraint);
                        }
                        string = tokenizer.getString();
                        if (string.equals(")")) break block23;
                    } while (string.equals(","));
                    throw Trace.error(11, string);
                }
            }
            channel.commit();
            n3 = 1;
            while (n3 < vector.size()) {
                tempConstraint = (TempConstraint)vector.elementAt(n3);
                if (tempConstraint.type == 1) {
                    object = (TempConstraint)vector.elementAt(0);
                    Trace.check(((TempConstraint)object).colMain == null, 24);
                    vector.setElementAt(tempConstraint, 0);
                    vector.removeElementAt(n3);
                    --n3;
                }
                ++n3;
            }
            tempConstraint = (TempConstraint)vector.elementAt(0);
            table.createPrimaryKey(tempConstraint.colMain);
            int n4 = 1;
            while (n4 < vector.size()) {
                tempConstraint = (TempConstraint)vector.elementAt(n4);
                if (tempConstraint.type == 2) {
                    table.createUniqueConstraint(tempConstraint.colMain, tempConstraint.name);
                }
                if (tempConstraint.type == 0) {
                    table.createForeignKey(tempConstraint.colMain, tempConstraint.colRef, tempConstraint.name, tempConstraint.expTable, tempConstraint.cascade);
                }
                ++n4;
            }
            this.linkTable(table);
        }
        catch (SQLException sQLException) {
            this.removeExportedKeys(table);
            throw sQLException;
        }
    }

    private Result processDrop(Tokenizer tokenizer, Channel channel) throws SQLException {
        channel.checkReadWrite();
        channel.checkAdmin();
        channel.setScripting(true);
        String string = tokenizer.getString();
        if (string.equals("TABLE")) {
            String string2 = tokenizer.getString();
            boolean bl = false;
            string = tokenizer.getString();
            if (string.equals("IF")) {
                tokenizer.getThis("EXISTS");
                bl = true;
            } else {
                tokenizer.back();
                Table table = this.getTable(string2, channel);
                channel.setScripting(!table.isTemp());
            }
            this.dropTable(string2, bl);
            channel.commit();
        } else if (string.equals("USER")) {
            this.aAccess.dropUser(tokenizer.getStringToken());
        } else if (string.equals("TRIGGER")) {
            this.dropTrigger(tokenizer.getString(), channel);
        } else if (string.equals("INDEX")) {
            string = tokenizer.getString();
            if (!tokenizer.wasLongName()) {
                throw Trace.error(11, string);
            }
            String string3 = tokenizer.getLongNameFirst();
            String string4 = tokenizer.getLongNameLast();
            Table table = this.getTable(string3, channel);
            table.checkDropIndex(string4);
            channel.setScripting(!table.isTemp());
            table.dropIndex(string4);
            channel.commit();
        } else {
            throw Trace.error(11, string);
        }
        return new Result();
    }

    private Result processGrantOrRevoke(Tokenizer tokenizer, Channel channel, boolean bl) throws SQLException {
        Object object;
        String string;
        String string2;
        channel.checkReadWrite();
        channel.checkAdmin();
        channel.setScripting(true);
        int n = 0;
        do {
            string = tokenizer.getString();
            n |= Access.getRight(string);
        } while ((string2 = tokenizer.getString()).equals(","));
        if (!string2.equals("ON")) {
            throw Trace.error(11, string2);
        }
        string = tokenizer.getString();
        if (string.equals("CLASS")) {
            string = string + " \"" + tokenizer.getString() + "\"";
        } else {
            object = this.getTable(string, channel);
            channel.setScripting(!((Table)object).isTemp());
        }
        tokenizer.getThis("TO");
        object = tokenizer.getStringToken();
        if (bl) {
            this.aAccess.grant((String)object, string, n);
            String string3 = "GRANT";
        } else {
            this.aAccess.revoke((String)object, string, n);
            String string4 = "REVOKE";
        }
        return new Result();
    }

    private Result processConnect(Tokenizer tokenizer, Channel channel) throws SQLException {
        tokenizer.getThis("USER");
        String string = tokenizer.getStringToken();
        tokenizer.getThis("PASSWORD");
        String string2 = tokenizer.getStringToken();
        User user = this.aAccess.getUser(string, string2);
        channel.commit();
        channel.setUser(user);
        return new Result();
    }

    private Result processDisconnect(Tokenizer tokenizer, Channel channel) throws SQLException {
        if (!channel.isClosed()) {
            channel.disconnect();
            this.cChannel.setElementAt(null, channel.getId());
        }
        return new Result();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Result processSet(Tokenizer tokenizer, Channel channel) throws SQLException {
        channel.setScripting(true);
        String string = tokenizer.getString();
        if (string.equals("PASSWORD")) {
            channel.checkReadWrite();
            channel.setPassword(tokenizer.getStringToken());
            return new Result();
        } else if (string.equals("READONLY")) {
            channel.commit();
            channel.setReadOnly(this.processTrueOrFalse(tokenizer));
            return new Result();
        } else if (string.equals("LOGSIZE")) {
            channel.checkAdmin();
            int n = Integer.parseInt(tokenizer.getString());
            this.logger.setLogSize(n);
            return new Result();
        } else if (string.equals("IGNORECASE")) {
            channel.checkAdmin();
            this.bIgnoreCase = this.processTrueOrFalse(tokenizer);
            return new Result();
        } else if (string.equals("MAXROWS")) {
            int n = Integer.parseInt(tokenizer.getString());
            channel.setMaxRows(n);
            return new Result();
        } else if (string.equals("AUTOCOMMIT")) {
            channel.setAutoCommit(this.processTrueOrFalse(tokenizer));
            return new Result();
        } else if (string.equals("TABLE")) {
            channel.checkReadWrite();
            channel.checkAdmin();
            Table table = this.getTable(tokenizer.getString(), channel);
            channel.setScripting(!table.isTemp());
            string = tokenizer.getString();
            if (string.equals("READONLY")) {
                table.setDataReadOnly(this.processTrueOrFalse(tokenizer));
                return new Result();
            } else {
                if (!string.equals("INDEX")) throw Trace.error(11, string);
                tokenizer.getString();
                table.setIndexRoots((String)tokenizer.getAsValue());
            }
            return new Result();
        } else if (string.equals("REFERENCIAL_INTEGRITY") || string.equals("REFERENTIAL_INTEGRITY")) {
            channel.checkAdmin();
            this.bReferentialIntegrity = this.processTrueOrFalse(tokenizer);
            return new Result();
        } else {
            if (!string.equals("WRITE_DELAY")) throw Trace.error(11, string);
            channel.checkAdmin();
            boolean bl = this.processTrueOrFalse(tokenizer);
            this.logger.setWriteDelay(bl);
        }
        return new Result();
    }

    private boolean processTrueOrFalse(Tokenizer tokenizer) throws SQLException {
        String string = tokenizer.getString();
        if (string.equals("TRUE")) {
            return true;
        }
        if (string.equals("FALSE")) {
            return false;
        }
        throw Trace.error(11, string);
    }

    private Result processCommit(Tokenizer tokenizer, Channel channel) throws SQLException {
        String string = tokenizer.getString();
        if (!string.equals("WORK")) {
            tokenizer.back();
        }
        channel.commit();
        return new Result();
    }

    private Result processRollback(Tokenizer tokenizer, Channel channel) throws SQLException {
        String string = tokenizer.getString();
        if (string.equals("TO")) {
            String string2 = tokenizer.getString();
            if (!string2.equals("SAVEPOINT")) {
                throw Trace.error(11, string2);
            }
            string2 = tokenizer.getString();
            if (string2.length() == 0) {
                throw Trace.error(11, string2);
            }
            channel.rollbackToSavepoint(string2);
            return new Result();
        }
        if (!string.equals("WORK")) {
            tokenizer.back();
        }
        channel.rollback();
        return new Result();
    }

    private Result processSavepoint(Tokenizer tokenizer, Channel channel) throws SQLException {
        String string = tokenizer.getString();
        if (string.length() == 0) {
            throw Trace.error(11, string);
        }
        channel.savepoint(string);
        return new Result();
    }

    public void finalize() {
        try {
            this.close(0);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void close(int n) throws SQLException {
        this.logger.closeLog(n);
        this.bShutdown = true;
    }

    private Result processShutdown(Tokenizer tokenizer, Channel channel) throws SQLException {
        channel.checkAdmin();
        int n = 0;
        String string = tokenizer.getString();
        if (string.equals("IMMEDIATELY")) {
            n = -1;
        } else if (string.equals("COMPACT")) {
            n = 1;
        } else {
            tokenizer.back();
        }
        int n2 = 1;
        int n3 = this.cChannel.size();
        while (n2 < n3) {
            Channel channel2 = (Channel)this.cChannel.elementAt(n2);
            if (channel2 != null) {
                channel2.disconnect();
            }
            ++n2;
        }
        this.cChannel.removeAllElements();
        this.close(n);
        this.processDisconnect(tokenizer, channel);
        return new Result();
    }

    private Result processCheckpoint(Channel channel) throws SQLException {
        channel.checkAdmin();
        channel.checkReadWrite();
        this.logger.checkpoint();
        return new Result();
    }

    void dropTable(String string, boolean bl) throws SQLException {
        Table table = null;
        int n = -1;
        int n2 = -1;
        Enumeration enumeration = null;
        Constraint constraint = null;
        Table table2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        while (n3 < this.tTable.size()) {
            table = (Table)this.tTable.elementAt(n3);
            if (table.getName().equals(string)) {
                n = n3;
                break;
            }
            table = null;
            ++n3;
        }
        if (n == -1) {
            if (bl) {
                return;
            }
            throw Trace.error(22, string);
        }
        enumeration = table.getConstraints().elements();
        while (enumeration.hasMoreElements()) {
            constraint = (Constraint)enumeration.nextElement();
            if (constraint.getType() != 1) continue;
            table2 = constraint.getRef();
            bl2 = table2 != null;
            boolean bl4 = bl3 = bl2 && table.equals(table2);
            if (!bl2 || bl3) continue;
            int n4 = 0;
            while (n4 < this.tTable.size()) {
                if (table2.equals(this.tTable.elementAt(n4))) {
                    n2 = n4;
                    break;
                }
                ++n4;
            }
            if (n2 == -1) continue;
            throw Trace.error(8, string + " is referenced by " + table2.getName());
        }
        this.tTable.removeElementAt(n);
        this.removeExportedKeys(table);
    }

    void removeExportedKeys(Table table) {
        int n = 0;
        while (n < this.tTable.size()) {
            Vector vector = ((Table)this.tTable.elementAt(n)).getConstraints();
            int n2 = vector.size() - 1;
            while (n2 >= 0) {
                Constraint constraint = (Constraint)vector.elementAt(n2);
                Table table2 = constraint.getRef();
                if (table == table2) {
                    vector.removeElementAt(n2);
                }
                --n2;
            }
            ++n;
        }
    }

    private void dropTrigger(String string, Channel channel) throws SQLException {
        int n = 0;
        int n2 = this.tTable.size();
        while (n < n2) {
            Table table = (Table)this.tTable.elementAt(n);
            int n3 = TriggerDef.numTrigs();
            int n4 = 0;
            while (n4 < n3) {
                Vector vector = table.vTrigs[n4];
                int n5 = 0;
                while (n5 < vector.size()) {
                    TriggerDef triggerDef = (TriggerDef)vector.elementAt(n5);
                    if (triggerDef.name.equals(string)) {
                        channel.setScripting(!triggerDef.table.isTemp());
                        vector.removeElementAt(n5);
                        if (Trace.TRACE) {
                            Trace.trace("Trigger dropped " + string);
                        }
                        return;
                    }
                    ++n5;
                }
                ++n4;
            }
            ++n;
        }
        throw Trace.error(43, string);
    }

    static {
        hCommands.put("CALL", new Integer(1));
        hCommands.put("CHECKPOINT", new Integer(2));
        hCommands.put("COMMIT", new Integer(3));
        hCommands.put("CONNECT", new Integer(4));
        hCommands.put("CREATE", new Integer(5));
        hCommands.put("DELETE", new Integer(6));
        hCommands.put("DISCONNECT", new Integer(7));
        hCommands.put("DROP", new Integer(8));
        hCommands.put("GRANT", new Integer(9));
        hCommands.put("INSERT", new Integer(10));
        hCommands.put("REVOKE", new Integer(11));
        hCommands.put("ROLLBACK", new Integer(12));
        hCommands.put("SAVEPOINT", new Integer(13));
        hCommands.put("SCRIPT", new Integer(14));
        hCommands.put("SELECT", new Integer(15));
        hCommands.put("SET", new Integer(16));
        hCommands.put("SHUTDOWN", new Integer(17));
        hCommands.put("UPDATE", new Integer(18));
        hCommands.put(";", new Integer(19));
    }

    class Logger {
        private Log lLog;

        Logger() {
        }

        boolean openLog(Database database, Channel channel, String string) throws SQLException {
            this.lLog = new Log(database, channel, string);
            boolean bl = this.lLog.open();
            return bl;
        }

        void closeLog(int n) throws SQLException {
            if (this.lLog == null) {
                return;
            }
            this.lLog.stop();
            switch (n) {
                case -1: {
                    this.lLog.shutdown();
                    break;
                }
                case 0: {
                    this.lLog.close(false);
                    break;
                }
                case 1: {
                    this.lLog.close(true);
                }
            }
            this.lLog = null;
        }

        boolean hasLog() {
            return this.lLog != null;
        }

        void cleanUp() throws SQLException {
            if (this.lLog != null && this.lLog.getCache() != null) {
                this.lLog.getCache().cleanUp();
            }
        }

        void logConnectUser(Channel channel, String string, String string2) throws SQLException {
            if (this.lLog != null) {
                this.lLog.write(channel, "CONNECT USER " + string + " PASSWORD \"" + string2 + "\"");
            }
        }

        void writeToLog(Channel channel, String string) throws SQLException {
            if (this.lLog != null) {
                this.lLog.write(channel, string);
            }
        }

        void checkpoint() throws SQLException {
            if (this.lLog != null) {
                this.lLog.checkpoint();
            }
        }

        void setLogSize(int n) {
            if (this.lLog != null) {
                this.lLog.setLogSize(n);
            }
        }

        void setWriteDelay(boolean bl) {
            if (this.lLog != null) {
                this.lLog.setWriteDelay(bl);
            }
        }
    }

    private class TempConstraint {
        String name;
        int[] colMain;
        Table expTable;
        int[] colRef;
        int type;
        boolean cascade;

        TempConstraint(String string, int[] nArray, Table table, int[] nArray2, int n, boolean bl) {
            this.name = string;
            this.type = n;
            this.colMain = nArray;
            this.expTable = table;
            this.colRef = nArray2;
            this.cascade = bl;
        }
    }
}

