/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class Constraint {
    static final int FOREIGN_KEY = 0;
    static final int MAIN = 1;
    static final int UNIQUE = 2;
    private String sName;
    private int iType;
    private int iLen;
    private Table tMain;
    private int[] iColMain;
    private Index iMain;
    private Object[] oMain;
    private Table tRef;
    private int[] iColRef;
    private Index iRef;
    private Object[] oRef;
    private Object[] oColRef;
    private boolean bCascade;

    Constraint(String string, int n, Table table, int[] nArray) {
        this.sName = string;
        this.iType = n;
        this.tMain = table;
        this.iColMain = nArray;
        this.iLen = nArray.length;
    }

    Constraint(String string, int n, Table table, Table table2, int[] nArray, int[] nArray2, Index index, Index index2, boolean bl) throws SQLException {
        this.sName = string;
        this.iType = n;
        this.tMain = table;
        this.tRef = table2;
        this.iColMain = nArray;
        this.iColRef = nArray2;
        this.iLen = nArray.length;
        this.oMain = this.tMain.getNewRow();
        this.oRef = this.tRef.getNewRow();
        this.oColRef = new Object[this.iColRef.length];
        this.iMain = index;
        this.iRef = index2;
        this.bCascade = bl;
    }

    String getName() {
        return this.sName;
    }

    String getPkName() {
        return this.iMain == null ? null : this.iMain.getName();
    }

    String getFkName() {
        return this.iRef == null ? null : this.iRef.getName();
    }

    int getType() {
        return this.iType;
    }

    Table getMain() {
        return this.tMain;
    }

    Table getRef() {
        return this.tRef;
    }

    Index getRefIndex() {
        return this.iRef;
    }

    boolean isCascade() {
        return this.bCascade;
    }

    int[] getMainColumns() {
        return this.iColMain;
    }

    int[] getRefColumns() {
        return this.iColRef;
    }

    boolean isIndexFK(Index index) {
        return !(this.iType != 0 && this.iType != 1 || this.iMain != index && this.iRef != index);
    }

    boolean isEquivalent(Constraint constraint) {
        if (constraint.iType == this.iType && this.iType == 2 && this.tMain == constraint.tMain && this.iLen == constraint.iLen) {
            int n = 0;
            while (n < this.iLen) {
                if (this.iColMain[n] != constraint.iColMain[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    void replaceTable(Table table, Table table2) throws SQLException {
        if (table == this.tMain) {
            this.tMain = table2;
        } else if (table == this.tRef) {
            this.tRef = table2;
        } else {
            Trace.doAssert(false, "could not replace");
        }
    }

    void checkInsert(Object[] objectArray) throws SQLException {
        if (this.iType == 1 || this.iType == 2) {
            return;
        }
        int n = 0;
        while (n < this.iLen) {
            Object object = objectArray[this.iColRef[n]];
            if (object == null) {
                return;
            }
            this.oMain[this.iColMain[n]] = object;
            ++n;
        }
        Trace.check(this.iMain.find(this.oMain) != null, 8);
    }

    private void checkDelete(Object[] objectArray) throws SQLException {
        Object object;
        int n = 0;
        while (n < this.iLen) {
            object = objectArray[this.iColMain[n]];
            if (object == null) {
                return;
            }
            this.oRef[this.iColRef[n]] = object;
            ++n;
        }
        object = this.iRef.find(this.oRef);
        Trace.check(object == null, 8);
    }

    Node findFkRef(Object[] objectArray) throws SQLException {
        Object object;
        int n = 0;
        while (n < this.iLen) {
            object = objectArray[this.iColMain[n]];
            if (object == null) {
                return null;
            }
            this.oColRef[n] = object;
            ++n;
        }
        object = this.iRef.findSimple(this.oColRef, this.bCascade);
        Trace.check(object == null || this.bCascade, 8);
        return object;
    }

    void checkUpdate(int[] nArray, Result result, Result result2) throws SQLException {
        block7: {
            block6: {
                if (this.iType == 2) {
                    return;
                }
                if (this.iType != 1) break block6;
                if (!this.isAffected(nArray, this.iColMain, this.iLen)) {
                    return;
                }
                Record record = result.rRoot;
                while (record != null) {
                    if (this.iMain.find(record.data) == null) {
                        this.checkDelete(record.data);
                    }
                    record = record.next;
                }
                break block7;
            }
            if (this.iType != 0) break block7;
            if (!this.isAffected(nArray, this.iColMain, this.iLen)) {
                return;
            }
            Record record = result2.rRoot;
            while (record != null) {
                this.checkInsert(record.data);
                record = record.next;
            }
        }
    }

    private boolean isAffected(int[] nArray, int[] nArray2, int n) {
        if (this.iType == 2) {
            return false;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            int n4 = 0;
            while (n4 < n) {
                if (n3 == nArray2[n4]) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }
}

