/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Date;
import java.util.Hashtable;
import org.hsqldb.ByteArray;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;
import org.hsqldb.lib.HsqlDateTime;

class Column {
    static final int VARCHAR_IGNORECASE = 100;
    private static Hashtable hTypes;
    static final int[] TYPES;
    String colName;
    String statementName;
    boolean isNameQuoted;
    private int colType;
    private int colSize;
    private int colScale;
    private boolean isNullable;
    private boolean isIdentity;
    private String defaultValue;
    private static Collator i18nCollator;
    private static boolean sql_compare_in_locale;
    private static boolean sql_compare_in_locale_set;

    private static void addTypes(int n, String string, String string2, String string3) {
        Column.addType(n, string);
        Column.addType(n, string2);
        Column.addType(n, string3);
    }

    private static void addType(int n, String string) {
        if (string != null) {
            hTypes.put(string, new Integer(n));
        }
    }

    Column(String string, boolean bl, boolean bl2, int n, int n2, int n3, boolean bl3, String string2) {
        this.colName = string;
        this.statementName = string;
        this.isNameQuoted = bl;
        this.isNullable = bl2;
        this.colType = n;
        this.colSize = n2;
        this.colScale = n3;
        this.isIdentity = bl3;
        this.defaultValue = string2;
        if (bl) {
            this.statementName = StringConverter.toQuotedString(string, '\"', true);
        }
    }

    boolean isIdentity() {
        return this.isIdentity;
    }

    boolean isNullable() {
        return this.isNullable;
    }

    String getDefaultValue() {
        return this.defaultValue;
    }

    int getType() {
        return this.colType;
    }

    int getSize() {
        return this.colSize;
    }

    int getScale() {
        return this.colScale;
    }

    static int getTypeNr(String string) throws SQLException {
        Integer n = (Integer)hTypes.get(string);
        Trace.check(n != null, 16, string);
        return n;
    }

    static String getTypeString(int n) throws SQLException {
        switch (n) {
            case 0: {
                return "NULL";
            }
            case 4: {
                return "INTEGER";
            }
            case 8: {
                return "DOUBLE";
            }
            case 100: {
                return "VARCHAR_IGNORECASE";
            }
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 3: {
                return "DECIMAL";
            }
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case -5: {
                return "BIGINT";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 2: {
                return "NUMERIC";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 1111: {
                return "OBJECT";
            }
        }
        throw Trace.error(16, n);
    }

    static Object add(Object object, Object object2, int n) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return new Integer(n2 + n3);
            }
            case 6: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return new Double(d + d2);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return (String)object + (String)object2;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.add(bigDecimal2);
            }
            case -6: {
                byte by = ((Number)object).byteValue();
                byte by2 = ((Number)object2).byteValue();
                return new Byte((byte)(by + by2));
            }
            case 5: {
                short s = ((Number)object).shortValue();
                short s2 = ((Number)object2).shortValue();
                return new Short((short)(s + s2));
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return new Long(l + l2);
            }
            case 7: {
                float f = ((Number)object).floatValue();
                float f2 = ((Number)object2).floatValue();
                return new Float(f + f2);
            }
        }
        throw Trace.error(20, n);
    }

    static Object concat(Object object, Object object2) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        return Column.convertObject(object) + Column.convertObject(object2);
    }

    static Object negate(Object object, int n) throws SQLException {
        if (object == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                return new Integer(-((Integer)object).intValue());
            }
            case 6: 
            case 8: {
                return new Double(-((Double)object).doubleValue());
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).negate();
            }
            case -6: {
                return new Byte(-((Byte)object).byteValue());
            }
            case 5: {
                return new Short(-((Short)object).shortValue());
            }
            case -5: {
                return new Long(-((Long)object).longValue());
            }
            case 7: {
                return new Float(-((Float)object).floatValue());
            }
        }
        throw Trace.error(20, n);
    }

    static Object multiply(Object object, Object object2, int n) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return new Integer(n2 * n3);
            }
            case 6: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return new Double(d * d2);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.multiply(bigDecimal2);
            }
            case -6: {
                byte by = ((Number)object).byteValue();
                byte by2 = ((Number)object2).byteValue();
                return new Byte((byte)(by * by2));
            }
            case 5: {
                short s = ((Number)object).shortValue();
                short s2 = ((Number)object2).shortValue();
                return new Short((short)(s * s2));
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return new Long(l * l2);
            }
            case 7: {
                float f = ((Number)object).floatValue();
                float f2 = ((Number)object2).floatValue();
                return new Float(f * f2);
            }
        }
        throw Trace.error(20, n);
    }

    static Object divide(Object object, Object object2, int n) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                Trace.check(n3 != 0, 6);
                return new Integer(n2 / n3);
            }
            case 6: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return d2 == 0.0 ? null : new Double(d / d2);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal2.signum() == 0 ? null : bigDecimal.divide(bigDecimal2, 5);
            }
            case -6: {
                byte by = ((Number)object).byteValue();
                byte by2 = ((Number)object2).byteValue();
                return by2 == 0 ? null : new Byte((byte)(by / by2));
            }
            case 5: {
                short s = ((Number)object).shortValue();
                short s2 = ((Number)object2).shortValue();
                return s2 == 0 ? null : new Short((short)(s / s2));
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return l2 == 0L ? null : new Long(l / l2);
            }
            case 7: {
                float f = ((Number)object).floatValue();
                float f2 = ((Number)object2).floatValue();
                return f2 == 0.0f ? null : new Float(f / f2);
            }
        }
        throw Trace.error(20, n);
    }

    static Object subtract(Object object, Object object2, int n) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return new Integer(n2 - n3);
            }
            case 6: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return new Double(d - d2);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.subtract(bigDecimal2);
            }
            case -6: {
                byte by = ((Number)object).byteValue();
                byte by2 = ((Number)object2).byteValue();
                return new Byte((byte)(by - by2));
            }
            case 5: {
                short s = ((Number)object).shortValue();
                short s2 = ((Number)object2).shortValue();
                return new Short((short)(s - s2));
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return new Long(l - l2);
            }
            case 7: {
                float f = ((Number)object).floatValue();
                float f2 = ((Number)object2).floatValue();
                return new Float(f - f2);
            }
        }
        throw Trace.error(20, n);
    }

    static Object sum(Object object, Object object2, int n) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                return new Integer(((Number)object).intValue() + ((Number)object2).intValue());
            }
            case 6: 
            case 8: {
                return new Double(((Number)object).doubleValue() + ((Number)object2).doubleValue());
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).add((BigDecimal)object2);
            }
            case -6: {
                return new Byte((byte)(((Number)object).byteValue() + ((Number)object2).byteValue()));
            }
            case 5: {
                return new Short((short)(((Number)object).shortValue() + ((Number)object2).shortValue()));
            }
            case -5: {
                return new Long(((Number)object).longValue() + ((Number)object2).longValue());
            }
            case 7: {
                return new Float(((Number)object).floatValue() + ((Number)object2).floatValue());
            }
        }
        throw Trace.error(15);
    }

    static Object avg(Object object, int n, int n2) throws SQLException {
        if (object == null || n2 == 0) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                return new Integer((Integer)object / n2);
            }
            case 6: 
            case 8: {
                return new Double((Double)object / (double)n2);
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).divide(new BigDecimal((double)n2), 5);
            }
            case -6: {
                return new Byte((byte)((Byte)object / n2));
            }
            case 5: {
                return new Short((short)((Short)object / n2));
            }
            case -5: {
                return new Long((Long)object / (long)n2);
            }
            case 7: {
                return new Float(((Float)object).floatValue() / (float)n2);
            }
        }
        throw Trace.error(15);
    }

    static Object min(Object object, Object object2, int n) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        if (Column.compare(object, object2, n) < 0) {
            return object;
        }
        return object2;
    }

    static Object max(Object object, Object object2, int n) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        if (Column.compare(object, object2, n) > 0) {
            return object;
        }
        return object2;
    }

    static void setCompareInLocal(boolean bl) {
        if (!sql_compare_in_locale_set) {
            sql_compare_in_locale = bl;
            sql_compare_in_locale_set = true;
        }
    }

    static int compare(Object object, Object object2, int n) throws SQLException {
        int n2 = 0;
        if (object == null) {
            if (object2 == null) {
                return 0;
            }
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (n) {
            case 0: {
                return 0;
            }
            case 4: {
                int n3 = ((Number)object).intValue();
                int n4 = ((Number)object2).intValue();
                return n3 > n4 ? 1 : (n4 > n3 ? -1 : 0);
            }
            case 6: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return d > d2 ? 1 : (d2 > d ? -1 : 0);
            }
            case -1: 
            case 1: 
            case 12: {
                if (sql_compare_in_locale) {
                    n2 = i18nCollator.compare((String)object, (String)object2);
                    break;
                }
                n2 = ((String)object).compareTo((String)object2);
                break;
            }
            case 100: {
                if (sql_compare_in_locale) {
                    n2 = i18nCollator.compare(((String)object).toUpperCase(), ((String)object2).toUpperCase());
                    break;
                }
                n2 = ((String)object).toUpperCase().compareTo(((String)object2).toUpperCase());
                break;
            }
            case 91: {
                if (((java.sql.Date)object).after((java.sql.Date)object2)) {
                    return 1;
                }
                if (((java.sql.Date)object).before((java.sql.Date)object2)) {
                    return -1;
                }
                return 0;
            }
            case 92: {
                if (((Time)object).after((Time)object2)) {
                    return 1;
                }
                if (((Time)object).before((Time)object2)) {
                    return -1;
                }
                return 0;
            }
            case 93: {
                if (((Timestamp)object).after((Timestamp)object2)) {
                    return 1;
                }
                if (((Timestamp)object).before((Timestamp)object2)) {
                    return -1;
                }
                return 0;
            }
            case 2: 
            case 3: {
                n2 = ((BigDecimal)object).compareTo((BigDecimal)object2);
                break;
            }
            case -7: {
                boolean bl = (Boolean)object;
                boolean bl2 = (Boolean)object2;
                return bl == bl2 ? 0 : (bl2 ? -1 : 1);
            }
            case -6: {
                byte by = ((Number)object).byteValue();
                byte by2 = ((Number)object2).byteValue();
                return by > by2 ? 1 : (by2 > by ? -1 : 0);
            }
            case 5: {
                short s = ((Number)object).shortValue();
                short s2 = ((Number)object2).shortValue();
                return s > s2 ? 1 : (s2 > s ? -1 : 0);
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return l > l2 ? 1 : (l2 > l ? -1 : 0);
            }
            case 7: {
                float f = ((Number)object).floatValue();
                float f2 = ((Number)object2).floatValue();
                return f > f2 ? 1 : (f2 > f ? -1 : 0);
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: {
                n2 = ((ByteArray)object).compareTo((ByteArray)object2);
                break;
            }
            default: {
                throw Trace.error(20, n);
            }
        }
        return n2 > 0 ? 1 : (n2 < 0 ? -1 : 0);
    }

    static Object convertString(String string, int n) throws SQLException {
        if (string == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 4: {
                return new Integer(string);
            }
            case 6: 
            case 8: {
                return new Double(string);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return string;
            }
            case 91: {
                return HsqlDateTime.dateValue(string);
            }
            case 92: {
                return HsqlDateTime.timeValue(string);
            }
            case 93: {
                return HsqlDateTime.timestampValue(string);
            }
            case 2: 
            case 3: {
                return new BigDecimal(string.trim());
            }
            case -7: {
                return new Boolean(string);
            }
            case -6: {
                return new Byte(string);
            }
            case 5: {
                return new Short(string);
            }
            case -5: {
                return new Long(string);
            }
            case 7: {
                return new Float(string);
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: {
                return new ByteArray(string);
            }
        }
        throw Trace.error(20, n);
    }

    static String convertObject(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    static Object convertObject(Object object, int n) throws SQLException {
        if (object == null) {
            return null;
        }
        switch (n) {
            case 92: {
                if (object instanceof Timestamp) {
                    return new Time(((Date)((Timestamp)object)).getTime());
                }
                if (!(object instanceof java.sql.Date)) break;
                return new Time(0L);
            }
            case 91: {
                if (!(object instanceof Timestamp)) break;
                return new java.sql.Date(((Date)((Timestamp)object)).getTime());
            }
            case -4: 
            case -3: 
            case -2: {
                if (!(object instanceof byte[])) break;
                return new ByteArray((byte[])object);
            }
        }
        return Column.convertString(object.toString(), n);
    }

    static String createSQLString(Object object, int n) throws SQLException {
        if (object == null) {
            return "NULL";
        }
        switch (n) {
            case 0: {
                return "NULL";
            }
            case -4: 
            case -3: 
            case -2: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                return StringConverter.toQuotedString(object.toString(), '\'', false);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return Column.createSQLString((String)object);
            }
        }
        return object.toString();
    }

    static String createSQLString(String string) {
        return StringConverter.toQuotedString(string, '\'', true);
    }

    static int getLargerNumberType(int n, int n2) {
        return Column.getNumTypeOrder(n) > Column.getNumTypeOrder(n2) ? n : n2;
    }

    private static int getNumTypeOrder(int n) {
        switch (n) {
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case -5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 8: {
                return 5;
            }
            case 3: {
                return 6;
            }
        }
        return 6;
    }

    static {
        TYPES = new int[]{-7, -6, -5, -4, -3, -2, -1, 1, 2, 3, 4, 5, 6, 7, 8, 12, 91, 92, 93, 1111};
        hTypes = new Hashtable();
        Column.addTypes(4, "INTEGER", "int", "java.lang.Integer");
        Column.addType(4, "INT");
        Column.addTypes(8, "DOUBLE", "double", "java.lang.Double");
        Column.addType(6, "FLOAT");
        Column.addTypes(12, "VARCHAR", "java.lang.String", null);
        Column.addTypes(1, "CHAR", "CHARACTER", null);
        Column.addType(-1, "LONGVARCHAR");
        Column.addType(100, "VARCHAR_IGNORECASE");
        Column.addTypes(91, "DATE", "java.sql.Date", null);
        Column.addTypes(92, "TIME", "java.sql.Time", null);
        Column.addTypes(93, "TIMESTAMP", "java.sql.Timestamp", "DATETIME");
        Column.addTypes(3, "DECIMAL", "java.math.BigDecimal", null);
        Column.addType(2, "NUMERIC");
        Column.addTypes(-7, "BIT", "java.lang.Boolean", "boolean");
        Column.addTypes(-6, "TINYINT", "java.lang.Byte", "byte");
        Column.addTypes(5, "SMALLINT", "java.lang.Short", "short");
        Column.addTypes(-5, "BIGINT", "java.lang.Long", "long");
        Column.addTypes(7, "REAL", "java.lang.Float", "float");
        Column.addTypes(-2, "BINARY", "byte[]", null);
        Column.addType(-3, "VARBINARY");
        Column.addType(-4, "LONGVARBINARY");
        Column.addTypes(1111, "OTHER", "java.lang.Object", "OBJECT");
        Column.addTypes(0, "NULL", "java.lang.Void", "void");
        i18nCollator = Collator.getInstance();
        sql_compare_in_locale = false;
        sql_compare_in_locale_set = false;
    }
}

