package org.maachang.bdb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/**
 * シリアライズ用ユーティリティ.
 * 
 * @version 2010/01/02
 * @author  masahito suzuki
 * @since   bdb 1.0.0
 */
abstract class SerializableUtil {
    private SerializableUtil() {}
    
    /**
     * シリアライズオブジェクトをバイナリ変換.
     * @param value 対象のシリアライズオブジェクトを設定します.
     * @return byte[] バイナリ変換された内容が返されます.
     * @exception Exception 例外.
     */
    public static final byte[] toBinary( Serializable value )
        throws Exception {
        if( value == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        byte[] ret = null ;
        ObjectOutputStream o = null ;
        try{
            ByteArrayOutputStream b = new ByteArrayOutputStream() ;
            o = new ObjectOutputStream( b ) ;
            o.writeObject( value ) ;
            o.flush() ;
            ret = b.toByteArray() ;
        } catch( Exception e ){
            throw e ;
        } finally {
            try {
                o.close() ;
            } catch( Exception e ) {
            }
        }
        return ret ;
    }
    
    /**
     * バイナリをシリアライズオブジェクトに変換.
     * @param bin 対象のバイナリを設定します.
     * @return Serializable 変換されたシリアライズオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final Serializable toObject( byte[] bin )
        throws Exception {
        if( bin == null || bin.length <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        ObjectInputStream in = null;
        Serializable ret = null ;
        try{
            in = new ObjectInputStream( new ByteArrayInputStream( bin ) ) ;
            ret = ( Serializable )in.readObject() ;
        }catch( Exception e ){
            throw e ;
        }finally{
            try{
                in.close() ;
            }catch( Exception e ){
            }
            in = null ;
        }
        return ret ;
    }
    
}
