package org.maachang.bdb ;

import java.util.Iterator;


public class BdbTest {
    private static final int DEFAULT_LENGTH = 100000 ;
    public static void main(String[] args) throws Exception {
        int len ;
        boolean writeMode = true ;
        if( args == null || args.length <= 0 ) {
            len = DEFAULT_LENGTH ;
        }
        else {
            len = Integer.parseInt( args[ 0 ] ) ;
            if( args.length >= 2 ) {
                String s = args[ 1 ].toLowerCase() ;
                if( !"true".equals( s ) && !"on".equals( s ) && !"write".equals( s ) ) {
                    writeMode = false ;
                }
            }
        }
        if( writeMode ) {
            System.out.println( "write=" + len ) ;
        }
        else {
            System.out.println( "read=" + len ) ;
        }
        
        BdbKeyValue kv = new BdbKeyValue() ;
        BdbManager man = null ;
        try {
            final String k = "0000000" ;
            String s ;
            Object[] key = new Object[ len ] ;
            
            for( int i = 0 ; i < len ; i ++ ) {
                s = String.valueOf( i ) ;
                key[ i ] = ( k.substring( s.length() ) + s ).getBytes("UTF8") ;
            }
            man = new BdbManager() ;
            Bdb bdb = man.get( "test" ) ;
            
            System.out.println( "start" ) ;
            long t ;
            
            System.out.println( "size:" + bdb.size() ) ;
            
            if( writeMode ) {
                t = System.currentTimeMillis() ;
                for( int i = 0 ; i < len ; i ++ ) {
                    kv.setKey( (byte[])key[ i ] ) ;
                    kv.setValue( (byte[])key[ i ] ) ;
                    bdb.put( kv ) ;
                }
                t = System.currentTimeMillis() - t ;
                System.out.println( "write:" + t + "msec" ) ;
            }
            
            System.out.println( "size:" + bdb.size() ) ;
            
            int cnt ;
            cnt = 0 ;
            t = System.currentTimeMillis() ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( bdb.containsKey( kv.setKey( (byte[])key[ i ] ) ) ) {
                    cnt ++ ;
                }
            }
            t = System.currentTimeMillis() - t ;
            System.out.println( "check:" + t + "msec(" + cnt + "/" + len + ")" ) ;
            
            cnt = 0 ;
            t = System.currentTimeMillis() ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( bdb.get( kv.setKey( (byte[])key[ i ] ) ) ) {
                    cnt ++ ;
                }
            }
            t = System.currentTimeMillis() - t ;
            System.out.println( "read:" + t + "msec(" + cnt + "/" + len + ")" ) ;
            
            cnt = 0 ;
            Iterator it = bdb.keyValues() ;
            t = System.currentTimeMillis() ;
            while( it.hasNext() ) {
                if( it.next() != null ) {
                    cnt ++ ;
                }
            }
            t = System.currentTimeMillis() - t ;
            System.out.println( "Iterator:" + t + "msec(" + cnt + "/" + len + ")" ) ;
            man.destroy() ;
            man = null ;
        } finally {
            if( man != null ) {
                try {
                    man.destroy() ;
                } catch( Exception e ) {
                }
            }
        }
    }
}

