package org.maachang.bdb ;

public class BQueueTest {
    private static final int DEFAULT_LENGTH = 100000 ;
    public static void main(String[] args) throws Exception {
        int len ;
        if( args == null || args.length <= 0 ) {
            len = DEFAULT_LENGTH ;
        }
        else {
            len = Integer.parseInt( args[ 0 ] ) ;
        }
        final String k = "0000000" ;
        String s ;
        Object[] key = new Object[ len ] ;
        
        for( int i = 0 ; i < len ; i ++ ) {
            s = String.valueOf( i ) ;
            key[ i ] = ( k.substring( s.length() ) + s ).getBytes("UTF8") ;
        }
        BdbKeyValue kv = new BdbKeyValue() ;
        BdbManager man = null ;
        try {
            man = new BdbManager() ;
            BQueue queue = man.getQueue( "test" ) ;
            System.out.println( "start :" + len ) ;
            long t = System.currentTimeMillis() ;
            for( int i = 0 ; i < len ; i ++ ) {
                queue.offer( kv,(byte[])key[i] ) ;
            }
            t = System.currentTimeMillis() - t ;
            System.out.println( "push(" + len + "):" + t + "msec" ) ;
            
            t = System.currentTimeMillis() ;
            /*
            byte[] bin ;
            while( true ) {
                if( ( bin = queue.offer( kv ) ) == null ) {
                    break ;
                }
                System.out.println( new String( bin,"UTF8" ) ) ;
            }
            */
            while( true ) {
                if( queue.poll( kv ) == null ) {
                    break ;
                }
            }
            t = System.currentTimeMillis() - t ;
            System.out.println( "get(" + len + "):" + t + "msec" ) ;
            
            System.out.println() ;
            System.out.println( "queue.length:" + queue.length() ) ;
            
        } finally {
            if( man != null ) {
                try {
                    man.destroy() ;
                } catch( Exception e ) {
                }
            }
        }
        
    }
}

