package org.maachang.bdb ;

import java.util.Iterator;

/**
 * Berkeley DB Queue.
 *
 * @version 2010/01/20
 * @author  masahito suzuki
 * @since   bdb 1.0.4
 */
public interface BQueue {
    
    /**
     * オブジェクトクローズ.
     */
    public void close() ;
    
    /**
     * 情報追加.
     * @param keyValue Bdbオブジェクトを制御するKeyValueオブジェクトを設定します.
     * @param value 対象の要素を設定します.
     * @exception Exception 例外.
     */
    public void offer( BdbKeyValue keyValue,byte[] value )
        throws Exception ;
    
    /**
     * 情報取得.
     * <p>この処理を実行した場合、取得された内容は削除されます.</p>
     * @param keyValue Bdbオブジェクトを制御するKeyValueオブジェクトを設定します.
     * @return byte[] 対象の要素が返されます.
     * @exception Exception 例外.
     */
    public byte[] poll( BdbKeyValue keyValue ) throws Exception ;
    
    /**
     * 情報取得.
     * <p>この処理を実行した場合、取得された内容は削除されません.</p>
     * @param keyValue Bdbオブジェクトを制御するKeyValueオブジェクトを設定します.
     * @return byte[] 対象の要素が返されます.
     * @exception Exception 例外.
     */
    public byte[] peek( BdbKeyValue keyValue ) throws Exception ;
    
    /**
     * 情報一覧取得.
     * <p>この処理を実行した場合、取得された内容は削除されません.</p>
     * @return Iterator<byte[]> 格納一覧内容が格納されたIteratorが返されます.
     * @exception Exception 例外.
     */
    public Iterator<byte[]> iterator() throws Exception ;
    
    /**
     * 格納情報数を取得.
     * @return long 格納情報数が返されます.
     * @exception Exception 例外.
     */
    public long length() throws Exception ;
    
    /**
     * 最大格納数を取得.
     * @return long 最大格納数が返されます.
     */
    public long getMaxLength() ;
    
    /**
     * 警告値を取得.
     * @return double 警告値が返されます.
     */
    public double getWarning() ;
    
    /**
     * キュー名を取得.
     */
    public String getName() ;
    
    /**
     * BdbKeyValueオブジェクトを取得.
     * <p>※このオブジェクトは、ThreadLocalから取得されているので、Threadセーフです.</p>
     * @return BdbKeyValue BdbKeyValueオブジェクトが返されます.
     */
    public BdbKeyValue getBdbKeyValue() ;
    
    /**
     * 現在の格納数が警告値を越しているかチェック.
     * @return boolean [true]の場合、警告値を越しています.
     * @exception Exception 例外.
     */
    public boolean isWarning() throws Exception ;
    
    /**
     * このオブジェクトが既にクローズされているかチェック.
     * @return boolean [true]の場合、既にクローズされています.
     */
    public boolean isClose() ;
    
}
