package org.maachang.bdb ;

import java.util.concurrent.atomic.AtomicReference;

/**
 * AtomicOBJ.
 * 
 * @version 2010/01/03
 * @author masahito suzuki
 * @since bdb 1.00
 */
class AtomicOBJ<T> {
    private final AtomicReference<T> ato = new AtomicReference<T>() ;
    
    /**
     * コンストラクタ.
     */
    public AtomicOBJ() {
        
    }
    
    /**
     * コンストラクタ.
     * @param f 初期値を設定します.
     */
    public AtomicOBJ( T t ) {
        setting( t ) ;
    }
    
    /**
     * Object値を取得.
     * @return T Object値が返されます.
     */
    public T get() {
        return ato.get() ;
    }
    
    /**
     * Objectを設定.
     * @param t 対象オブジェクトを設定します.
     */
    public void set( T t ) {
        setting( t ) ;
    }
    
    /**
     * 文字列変換.
     * @return String 文字列が返されます.
     */
    public String toString() {
        return String.valueOf( get() ) ;
    }
    
    protected AtomicReference getAtomicReference() {
        return ato ;
    }
    
    private void setting( T t ) {
        while( !ato.compareAndSet( ato.get(),t ) ) {}
    }
}
