/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.bdb;

import java.util.Iterator;
import org.maachang.bdb.Bdb;
import org.maachang.bdb.BdbKeyValue;
import org.maachang.bdb.BdbManager;

public class BdbTest {
    private static final int DEFAULT_LENGTH = 100000;

    public static void main(String[] args) throws Exception {
        int len;
        boolean writeMode = true;
        if (args == null || args.length <= 0) {
            len = 100000;
        } else {
            String s;
            len = Integer.parseInt(args[0]);
            if (!(args.length < 2 || "true".equals(s = args[1].toLowerCase()) || "on".equals(s) || "write".equals(s))) {
                writeMode = false;
            }
        }
        if (writeMode) {
            System.out.println("write=" + len);
        } else {
            System.out.println("read=" + len);
        }
        BdbKeyValue kv = new BdbKeyValue();
        BdbManager man = null;
        try {
            long t;
            String k = "0000000";
            Object[] key = new Object[len];
            int i = 0;
            while (i < len) {
                String s = String.valueOf(i);
                key[i] = (String.valueOf("0000000".substring(s.length())) + s).getBytes("UTF8");
                ++i;
            }
            man = new BdbManager();
            Bdb bdb = man.get("test");
            System.out.println("start");
            System.out.println("size:" + bdb.size());
            if (writeMode) {
                t = System.currentTimeMillis();
                int i2 = 0;
                while (i2 < len) {
                    kv.setKey((byte[])key[i2]);
                    kv.setValue((byte[])key[i2]);
                    bdb.put(kv);
                    ++i2;
                }
                t = System.currentTimeMillis() - t;
                System.out.println("write:" + t + "msec");
            }
            System.out.println("size:" + bdb.size());
            int cnt = 0;
            t = System.currentTimeMillis();
            int i3 = 0;
            while (i3 < len) {
                if (bdb.containsKey(kv.setKey((byte[])key[i3]))) {
                    ++cnt;
                }
                ++i3;
            }
            t = System.currentTimeMillis() - t;
            System.out.println("check:" + t + "msec(" + cnt + "/" + len + ")");
            cnt = 0;
            t = System.currentTimeMillis();
            i3 = 0;
            while (i3 < len) {
                if (bdb.get(kv.setKey((byte[])key[i3]))) {
                    ++cnt;
                }
                ++i3;
            }
            t = System.currentTimeMillis() - t;
            System.out.println("read:" + t + "msec(" + cnt + "/" + len + ")");
            cnt = 0;
            Iterator<BdbKeyValue> it = bdb.keyValues();
            t = System.currentTimeMillis();
            while (it.hasNext()) {
                if (it.next() == null) continue;
                ++cnt;
            }
            t = System.currentTimeMillis() - t;
            System.out.println("Iterator:" + t + "msec(" + cnt + "/" + len + ")");
            man.destroy();
            man = null;
        }
        finally {
            if (man != null) {
                try {
                    man.destroy();
                }
                catch (Exception exception) {}
            }
        }
    }
}

