/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.bdb;

import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.bdb.AtomicOBJ;
import org.maachang.bdb.BQueue;
import org.maachang.bdb.BQueueImpl;
import org.maachang.bdb.Bdb;
import org.maachang.bdb.BdbImpl;
import org.maachang.bdb.BdbKeyValue;

public class BdbManager {
    protected static boolean _DEFERRED_WRITE = true;
    protected final AtomicOBJ<String> dirName = new AtomicOBJ();
    protected final AtomicOBJ<Environment> env = new AtomicOBJ();
    protected final ConcurrentHashMap<String, Bdb> manager = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, BQueue> managerq = new ConcurrentHashMap();
    private static final ThreadLocal<BdbKeyValue> LO = new ThreadLocal();

    public static final BdbKeyValue getBdbKeyValue() {
        BdbKeyValue ret = LO.get();
        if (ret == null) {
            ret = new BdbKeyValue();
            LO.set(ret);
        } else {
            ret.clear();
        }
        return ret;
    }

    public BdbManager() throws Exception {
        this(null);
    }

    public BdbManager(String dir) throws Exception {
        this(true, dir);
    }

    public BdbManager(boolean mode, String dir) throws Exception {
        File f;
        if (dir == null || (dir = dir.trim()).length() <= 0) {
            dir = ".";
        }
        if (!(f = new File(dir)).isDirectory() && !f.mkdirs()) {
            throw new IOException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + dir);
        }
        _DEFERRED_WRITE = mode;
        EnvironmentConfig conf = new EnvironmentConfig();
        conf.setTransactional(false);
        conf.setAllowCreate(true);
        conf.setLocking(true);
        Environment env = new Environment(f, conf);
        f = null;
        this.env.set(env);
        this.dirName.set(dir);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() {
        String k;
        if (this.env.get() == null) return;
        this.dirName.set(null);
        Environment env = this.env.get();
        this.env.set(null);
        Iterator it = this.manager.keySet().iterator();
        try {
            while (it.hasNext()) {
                k = (String)it.next();
                Bdb bdb = this.manager.get(k);
                if (bdb == null) continue;
                try {
                    bdb.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.manager.clear();
        it = this.managerq.keySet().iterator();
        try {
            while (it.hasNext()) {
                k = (String)it.next();
                BQueue queue = this.managerq.get(k);
                if (queue == null) continue;
                queue.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.managerq.clear();
        try {
            env.sync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            env.cleanLog();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            env.close();
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void flush() throws Exception {
        Environment env = this.env.get();
        if (env == null) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        env.sync();
    }

    public Bdb get(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.env.get() == null) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Bdb ret = this.manager.get(name);
        if (ret == null) {
            ret = new BdbImpl(false, name, this);
        }
        return ret;
    }

    public BQueue getQueue(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.env.get() == null) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        BQueue ret = this.managerq.get(name);
        if (ret == null) {
            ret = new BQueueImpl(this, name);
        }
        return ret;
    }

    public BQueue getQueue(String name, long max, double warning) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.env.get() == null) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        BQueue ret = this.managerq.get(name);
        if (ret == null) {
            ret = new BQueueImpl(this, name, max, warning);
        }
        return ret;
    }

    protected void remove(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.env.get() == null) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Bdb b = this.manager.remove(name);
        if (b != null) {
            b.close();
        }
    }

    public String getDirectory() {
        return this.dirName.get();
    }

    public boolean isDestroy() {
        return this.env.get() == null;
    }

    public static final void setDeferredWrite(boolean mode) {
        _DEFERRED_WRITE = mode;
    }

    public static final boolean isDeferredWrite() {
        return _DEFERRED_WRITE;
    }
}

