/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.bdb;

import com.sleepycat.je.DatabaseEntry;

public class BdbKeyValue {
    private final DatabaseEntry key = new DatabaseEntry();
    private final DatabaseEntry value = new DatabaseEntry();

    public BdbKeyValue create(byte[] key, byte[] value) throws Exception {
        this.setKey(key);
        this.setValue(value);
        return this;
    }

    public BdbKeyValue clear() {
        this.key.setData(null, 0, 0);
        this.key.setPartial(0, 0, false);
        this.value.setData(null, 0, 0);
        this.value.setPartial(0, 0, false);
        return this;
    }

    public BdbKeyValue setKey(byte[] key) {
        this.key.setPartial(0, 0, false);
        if (key == null || key.length <= 0) {
            key = null;
            this.key.setData(null, 0, 0);
            return this;
        }
        this.key.setData(key, 0, key.length);
        return this;
    }

    public BdbKeyValue setValue(byte[] value) {
        this.value.setPartial(0, 0, false);
        if (value == null || value.length <= 0) {
            this.value.setData(null, 0, 0);
            return this;
        }
        this.value.setData(value, 0, value.length);
        return this;
    }

    public byte[] getKey() {
        return this.key.getData();
    }

    public byte[] getValue() {
        return this.value.getData();
    }

    protected DatabaseEntry keyEntry() {
        return this.key;
    }

    protected DatabaseEntry valueEntry() {
        return this.value;
    }

    public boolean isKey() {
        return this.key.getData() != null;
    }

    public boolean isValue() {
        return this.value.getData() != null;
    }

    public boolean isKeyValue() {
        return this.key.getData() != null && this.value.getData() != null;
    }
}

