/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.bdb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import org.maachang.bdb.BdbImpl;
import org.maachang.bdb.BdbKeyValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BdbKeyIterator
implements Iterator<byte[]> {
    private static final CursorConfig CONF = BdbImpl.CURSOR_CONF;
    private Cursor cursor = null;
    private BdbKeyValue kv = null;
    private Lock rsync = null;
    private Lock wsync = null;
    private boolean flg = false;

    protected BdbKeyIterator(Lock rsync, Lock wsync, Database db) throws Exception {
        this(rsync, wsync, db, null);
    }

    protected BdbKeyIterator(Lock rsync, Lock wsync, Database db, BdbKeyValue o) throws Exception {
        this.cursor = db.openCursor(null, CONF);
        this.kv = o != null ? o : new BdbKeyValue();
        this.rsync = rsync;
        this.wsync = wsync;
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public void close() {
        if (this.cursor != null) {
            this.rsync.lock();
            try {
                try {
                    this.cursor.close();
                }
                catch (Exception exception) {}
            }
            finally {
                this.rsync.unlock();
            }
        }
        if (this.kv != null) {
            this.kv.clear();
        }
        this.cursor = null;
        this.kv = null;
        this.flg = false;
    }

    @Override
    public boolean hasNext() {
        if (this.cursor != null) {
            OperationStatus state;
            this.kv.clear();
            this.kv.valueEntry().setPartial(0, 0, true);
            this.rsync.lock();
            try {
                try {
                    state = this.cursor.getNext(this.kv.keyEntry(), this.kv.valueEntry(), LockMode.READ_UNCOMMITTED);
                }
                catch (Exception e) {
                    this.close();
                    this.rsync.unlock();
                    return false;
                }
            }
            finally {
                this.rsync.unlock();
            }
            if (OperationStatus.SUCCESS != state) {
                this.close();
                return false;
            }
            this.flg = true;
            return true;
        }
        return false;
    }

    @Override
    public byte[] next() {
        if (this.cursor != null) {
            if (!this.flg) {
                OperationStatus state;
                this.kv.clear();
                this.kv.valueEntry().setPartial(0, 0, true);
                this.rsync.lock();
                try {
                    try {
                        state = this.cursor.getNext(this.kv.keyEntry(), this.kv.valueEntry(), LockMode.READ_UNCOMMITTED);
                    }
                    catch (Exception e) {
                        this.close();
                        throw new NoSuchElementException();
                    }
                }
                finally {
                    this.rsync.unlock();
                }
                if (OperationStatus.SUCCESS != state) {
                    this.close();
                    throw new NoSuchElementException();
                }
            }
            this.flg = false;
            return this.kv.getKey();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.cursor != null) {
            this.wsync.lock();
            try {
                try {
                    this.cursor.delete();
                }
                catch (Exception exception) {}
            }
            finally {
                this.wsync.unlock();
            }
        }
    }
}

