/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.bdb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.maachang.bdb.AtomicBL;
import org.maachang.bdb.AtomicOBJ;
import org.maachang.bdb.Bdb;
import org.maachang.bdb.BdbKeyIterator;
import org.maachang.bdb.BdbKeyValue;
import org.maachang.bdb.BdbKeyValueIterator;
import org.maachang.bdb.BdbManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BdbImpl
implements Bdb {
    protected static final CursorConfig CURSOR_CONF = new CursorConfig().setReadUncommitted(true);
    private static final boolean _NOT_SORT_KEY = true;
    private final AtomicOBJ<BdbManager> man = new AtomicOBJ();
    private final AtomicOBJ<Database> db = new AtomicOBJ();
    private final AtomicOBJ<String> name = new AtomicOBJ();
    private final AtomicBL closeFlag = new AtomicBL(true);
    private final ReentrantReadWriteLock sync = new ReentrantReadWriteLock();
    private final Lock rsync = this.sync.readLock();
    private final Lock wsync = this.sync.writeLock();

    private BdbImpl() {
    }

    protected BdbImpl(boolean mode, String bdbName, BdbManager manager) throws Exception {
        if (bdbName == null || (bdbName = bdbName.trim()).length() <= 0 || manager == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (manager.isDestroy()) {
            throw new IOException("BdbManager\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = null;
        try {
            Environment env = manager.env.get();
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setTransactional(false);
            dbConfig.setAllowCreate(true);
            dbConfig.setSortedDuplicates(false);
            dbConfig.setDeferredWrite(BdbManager._DEFERRED_WRITE);
            db = env.openDatabase(null, bdbName, dbConfig);
            this.db.set(db);
            this.man.set(manager);
            this.name.set(bdbName);
            this.closeFlag.set(false);
            if (!mode) {
                manager.manager.put(bdbName, this);
            }
        }
        catch (Exception e) {
            if (db != null) {
                try {
                    db.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.closeFlag.get()) {
            this.closeFlag.set(true);
            Database db = this.db.get();
            this.db.set(null);
            String name = this.name.get();
            this.name.set(null);
            BdbManager man = this.man.get();
            this.man.set(null);
            this.wsync.lock();
            try {
                try {
                    db.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (name != null && man != null && !man.isDestroy()) {
                    man.manager.remove(name);
                }
            }
            finally {
                this.wsync.unlock();
            }
        }
    }

    @Override
    public Database database() throws Exception {
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return this.db.get();
    }

    @Override
    public void put(BdbKeyValue o) throws Exception {
        OperationStatus state;
        if (o == null || !o.isKeyValue()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        this.wsync.lock();
        try {
            state = db.put(null, o.keyEntry(), o.valueEntry());
        }
        finally {
            this.wsync.unlock();
        }
        if (OperationStatus.SUCCESS != state) {
            throw new IOException("\u30c7\u30fc\u30bf\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + state);
        }
    }

    protected void putNoLock(BdbKeyValue o) throws Exception {
        if (o == null || !o.isKeyValue()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        OperationStatus state = db.put(null, o.keyEntry(), o.valueEntry());
        if (OperationStatus.SUCCESS != state) {
            throw new IOException("\u30c7\u30fc\u30bf\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + state);
        }
    }

    @Override
    public void put(BdbKeyValue o, int offset, int length) throws Exception {
        OperationStatus state;
        if (o == null || !o.isKeyValue()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (offset < 0 || length <= 0) {
            throw new IOException("\u30aa\u30d5\u30bb\u30c3\u30c8\u5024\u3001\u9577\u3055\u304c\u4e0d\u6b63\u3067\u3059");
        }
        Database db = this.db.get();
        o.valueEntry().setPartial(offset, length, true);
        this.wsync.lock();
        try {
            state = db.put(null, o.keyEntry(), o.valueEntry());
        }
        finally {
            this.wsync.unlock();
            o.valueEntry().setPartial(0, 0, false);
        }
        if (OperationStatus.SUCCESS != state) {
            throw new IOException("\u30c7\u30fc\u30bf\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + state);
        }
    }

    protected void putNoLock(BdbKeyValue o, int offset, int length) throws Exception {
        OperationStatus state;
        if (o == null || !o.isKeyValue()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (offset < 0 || length <= 0) {
            throw new IOException("\u30aa\u30d5\u30bb\u30c3\u30c8\u5024\u3001\u9577\u3055\u304c\u4e0d\u6b63\u3067\u3059");
        }
        Database db = this.db.get();
        o.valueEntry().setPartial(offset, length, true);
        try {
            state = db.put(null, o.keyEntry(), o.valueEntry());
        }
        finally {
            o.valueEntry().setPartial(0, 0, false);
        }
        if (OperationStatus.SUCCESS != state) {
            throw new IOException("\u30c7\u30fc\u30bf\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + state);
        }
    }

    @Override
    public boolean remove(BdbKeyValue o) throws Exception {
        OperationStatus state;
        if (o == null || !o.isKey()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        this.wsync.lock();
        try {
            state = db.delete(null, o.keyEntry());
        }
        finally {
            this.wsync.unlock();
        }
        return OperationStatus.SUCCESS == state;
    }

    protected boolean removeNoLock(BdbKeyValue o) throws Exception {
        if (o == null || !o.isKey()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        OperationStatus state = db.delete(null, o.keyEntry());
        return OperationStatus.SUCCESS == state;
    }

    @Override
    public boolean get(BdbKeyValue o) throws Exception {
        OperationStatus state;
        if (o == null || !o.isKey()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        o.setValue(null);
        this.rsync.lock();
        try {
            state = db.get(null, o.keyEntry(), o.valueEntry(), LockMode.READ_UNCOMMITTED);
        }
        finally {
            this.rsync.unlock();
        }
        return OperationStatus.SUCCESS == state;
    }

    protected boolean getNoLock(BdbKeyValue o) throws Exception {
        if (o == null || !o.isKey()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        o.setValue(null);
        OperationStatus state = db.get(null, o.keyEntry(), o.valueEntry(), LockMode.READ_UNCOMMITTED);
        return OperationStatus.SUCCESS == state;
    }

    @Override
    public boolean get(BdbKeyValue o, int offset, int length) throws Exception {
        OperationStatus state;
        if (o == null || !o.isKey()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (offset < 0 || length <= 0) {
            return false;
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        o.setValue(null);
        o.valueEntry().setPartial(offset, length, true);
        this.rsync.lock();
        try {
            state = db.get(null, o.keyEntry(), o.valueEntry(), LockMode.READ_UNCOMMITTED);
        }
        finally {
            this.rsync.unlock();
            o.valueEntry().setPartial(0, 0, false);
        }
        return OperationStatus.SUCCESS == state;
    }

    protected boolean getNoLock(BdbKeyValue o, int offset, int length) throws Exception {
        OperationStatus state;
        if (o == null || !o.isKey()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (offset < 0 || length <= 0) {
            return false;
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        o.setValue(null);
        o.valueEntry().setPartial(offset, length, true);
        try {
            state = db.get(null, o.keyEntry(), o.valueEntry(), LockMode.READ_UNCOMMITTED);
        }
        finally {
            o.valueEntry().setPartial(0, 0, false);
        }
        return OperationStatus.SUCCESS == state;
    }

    @Override
    public boolean getToRemove(BdbKeyValue o) throws Exception {
        if (o == null || !o.isKey()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        Cursor cursor = null;
        this.wsync.lock();
        try {
            cursor = db.openCursor(null, CURSOR_CONF);
            OperationStatus state = cursor.getSearchKey(o.keyEntry(), o.valueEntry(), LockMode.READ_UNCOMMITTED);
            if (OperationStatus.SUCCESS != state) {
                return false;
            }
            cursor.delete();
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {}
            }
            this.wsync.unlock();
        }
        return true;
    }

    protected boolean getToRemoveNoLock(BdbKeyValue o) throws Exception {
        if (o == null || !o.isKey()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        Cursor cursor = null;
        try {
            cursor = db.openCursor(null, CURSOR_CONF);
            OperationStatus state = cursor.getSearchKey(o.keyEntry(), o.valueEntry(), LockMode.READ_UNCOMMITTED);
            if (OperationStatus.SUCCESS != state) {
                return false;
            }
            cursor.delete();
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    @Override
    public boolean containsKey(BdbKeyValue o) throws Exception {
        OperationStatus state;
        if (o == null || !o.isKey()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        o.valueEntry().setPartial(0, 0, true);
        this.rsync.lock();
        try {
            state = db.get(null, o.keyEntry(), o.valueEntry(), LockMode.READ_UNCOMMITTED);
        }
        finally {
            this.rsync.unlock();
        }
        o.setValue(null);
        return OperationStatus.SUCCESS == state;
    }

    protected boolean containsKeyNoLock(BdbKeyValue o) throws Exception {
        if (o == null || !o.isKey()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        o.valueEntry().setPartial(0, 0, true);
        OperationStatus state = db.get(null, o.keyEntry(), o.valueEntry(), LockMode.READ_UNCOMMITTED);
        o.setValue(null);
        return OperationStatus.SUCCESS == state;
    }

    @Override
    public Iterator<byte[]> keys() throws Exception {
        return this.keys(null);
    }

    @Override
    public Iterator<byte[]> keys(BdbKeyValue o) throws Exception {
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return new BdbKeyIterator(this.rsync, this.wsync, this.db.get(), o);
    }

    @Override
    public Iterator<BdbKeyValue> keyValues() throws Exception {
        return this.keyValues(null);
    }

    @Override
    public Iterator<BdbKeyValue> keyValues(BdbKeyValue o) throws Exception {
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return new BdbKeyValueIterator(this.rsync, this.wsync, this.db.get(), o);
    }

    @Override
    public long size() throws Exception {
        long ret;
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        this.rsync.lock();
        try {
            ret = db.count();
        }
        finally {
            this.rsync.unlock();
        }
        return ret;
    }

    protected long sizeNoLock() throws Exception {
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Database db = this.db.get();
        long ret = db.count();
        return ret;
    }

    @Override
    public String getName() throws Exception {
        if (this.closeFlag.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return this.name.get();
    }

    @Override
    public Lock getRSync() {
        return this.rsync;
    }

    @Override
    public Lock getWSync() {
        return this.wsync;
    }

    @Override
    public BdbKeyValue getBdbKeyValue() {
        return BdbManager.getBdbKeyValue();
    }

    @Override
    public boolean isClose() {
        return this.closeFlag.get();
    }
}

