/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.bdb;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import org.maachang.bdb.AtomicBL;
import org.maachang.bdb.BQueue;
import org.maachang.bdb.BdbImpl;
import org.maachang.bdb.BdbKeyValue;
import org.maachang.bdb.BdbManager;
import org.maachang.bdb.ConvertParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BQueueImpl
implements BQueue {
    public static final Object QUEUE_LOCK = new Object();
    private BdbImpl bdb = null;
    private BMqHeader header = null;
    private long max = -1L;
    private double warning = 0.0;
    private long warnLen;
    private String name = null;
    private Lock rsync = null;
    private Lock wsync = null;
    private final AtomicBL closeFlag = new AtomicBL(true);

    private BQueueImpl() {
    }

    protected BQueueImpl(BdbManager manager, String name) throws Exception {
        this(manager, name, Integer.MAX_VALUE, 0.75);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BQueueImpl(BdbManager manager, String name, long max, double warning) throws Exception {
        BdbImpl bdb;
        if (manager == null || manager.isDestroy() || name == null || (name = name.trim()).length() <= 0 || max < 128L || warning < 0.25) {
            if (manager == null || manager.isDestroy()) {
                throw new IllegalArgumentException("\u4e0d\u6b63\u306abdb\u30de\u30cd\u30fc\u30b8\u30e3\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            if (name == null || (name = name.trim()).length() <= 0) {
                throw new IllegalArgumentException("BQueue\u7528\u306b\u30aa\u30fc\u30d7\u30f3\u3059\u308bBdb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            if (max < 128L) {
                throw new IllegalArgumentException("\u6700\u5927\u683c\u7d0d\u6570\u306f\u3001128\u4ee5\u4e0a\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            if (warning < 0.25) {
                throw new IllegalArgumentException("\u8b66\u544a\u5024\u306f\u300125%\u4ee5\u4e0a\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
            }
        }
        BMqHeader header = null;
        Object object = QUEUE_LOCK;
        synchronized (object) {
            header = new BMqHeader(manager.getDirectory(), name);
        }
        this.bdb = bdb = new BdbImpl(true, name, manager);
        this.header = header;
        this.max = max;
        this.warning = warning;
        this.warnLen = (long)((double)max * warning);
        this.name = name;
        this.rsync = bdb.getRSync();
        this.wsync = bdb.getWSync();
        this.closeFlag.set(false);
        manager.managerq.put(name, this);
    }

    protected void finalize() throws Exception {
        this.close();
    }

    @Override
    public void close() {
        this.wsync.lock();
        try {
            if (this.header != null) {
                this.header.close();
            }
            if (this.bdb != null) {
                try {
                    this.bdb.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.header = null;
            this.bdb = null;
            this.closeFlag.set(true);
        }
        finally {
            this.wsync.unlock();
        }
    }

    @Override
    public void offer(BdbKeyValue keyValue, byte[] value) throws Exception {
        if (keyValue == null) {
            throw new IllegalArgumentException("KeyValue\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (value == null || value.length <= 0) {
            throw new IllegalArgumentException("\u8ffd\u52a0\u8981\u7d20\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        this.wsync.lock();
        try {
            BdbImpl b = this.bdb;
            if (b == null) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            long s = this.header.getSequence();
            b.putNoLock(keyValue.create(ConvertParam.convertLong(s), value));
        }
        finally {
            this.wsync.unlock();
            keyValue.clear();
        }
    }

    @Override
    public byte[] poll(BdbKeyValue keyValue) throws Exception {
        if (keyValue == null) {
            throw new IllegalArgumentException("KeyValue\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        byte[] ret = null;
        this.wsync.lock();
        try {
            BdbImpl b = this.bdb;
            if (b == null) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            long first = this.header.getFirst();
            long last = this.header.getLast();
            while (!b.getToRemoveNoLock(keyValue.create(ConvertParam.convertLong(first), null))) {
                if (last > ++first) continue;
                byte[] byArray = null;
                return byArray;
            }
            this.header.setFirst(first + 1L);
            ret = keyValue.getValue();
            keyValue.setValue(null);
        }
        finally {
            this.wsync.unlock();
            keyValue.clear();
        }
        return ret;
    }

    @Override
    public byte[] peek(BdbKeyValue keyValue) throws Exception {
        if (keyValue == null) {
            throw new IllegalArgumentException("KeyValue\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        byte[] ret = null;
        this.wsync.lock();
        try {
            BdbImpl b = this.bdb;
            if (b == null) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            long last = this.header.getLast();
            long first = this.header.getFirst();
            while (!b.getNoLock(keyValue.create(ConvertParam.convertLong(first), null))) {
                if (last > ++first) continue;
                byte[] byArray = null;
                return byArray;
            }
            ret = keyValue.getValue();
        }
        finally {
            this.wsync.unlock();
            keyValue.clear();
        }
        return ret;
    }

    @Override
    public Iterator<byte[]> iterator() throws Exception {
        this.rsync.lock();
        try {
            if (this.bdb == null) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            BQueueIterator bQueueIterator = new BQueueIterator(new BdbKeyValue(), this.bdb, this.header, this.rsync, this.closeFlag);
            return bQueueIterator;
        }
        finally {
            this.rsync.unlock();
        }
    }

    @Override
    public long length() throws Exception {
        long ret;
        this.rsync.lock();
        try {
            if (this.bdb == null) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            ret = this.bdb.sizeNoLock();
        }
        finally {
            this.rsync.unlock();
        }
        return ret;
    }

    @Override
    public long getMaxLength() {
        return this.max;
    }

    @Override
    public double getWarning() {
        return this.warning;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BdbKeyValue getBdbKeyValue() {
        return BdbManager.getBdbKeyValue();
    }

    @Override
    public boolean isWarning() throws Exception {
        boolean ret;
        this.rsync.lock();
        try {
            if (this.bdb == null) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            ret = this.warnLen <= this.bdb.sizeNoLock();
        }
        finally {
            this.rsync.unlock();
        }
        return ret;
    }

    @Override
    public boolean isClose() {
        return this.closeFlag.get();
    }

    private static class BMqHeader {
        private static final String ADD_DIR = "/queue/";
        private static final String HEADER_PLUS = ".header";
        private static final long LENGTH = 16L;
        private RandomAccessFile fp = null;
        private MappedByteBuffer buf = null;

        BMqHeader(String dir, String name) throws Exception {
            File fl = new File(String.valueOf(dir) + ADD_DIR);
            if (!fl.isDirectory() && !fl.mkdirs()) {
                throw new IOException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + dir);
            }
            name = String.valueOf(dir) + ADD_DIR + name + HEADER_PLUS;
            this.close();
            RandomAccessFile f = null;
            MappedByteBuffer m = null;
            try {
                f = new RandomAccessFile(name, "rw");
                f.setLength(16L);
                m = f.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, 16L);
            }
            catch (Exception e) {
                if (f != null) {
                    try {
                        f.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    f = null;
                    m = null;
                }
                throw e;
            }
            this.fp = f;
            this.buf = m;
        }

        void close() {
            if (this.fp != null) {
                try {
                    this.fp.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.fp = null;
            this.buf = null;
        }

        long getSequence() throws Exception {
            long ret = this.buf.getLong(0);
            if (ret >= Long.MAX_VALUE) {
                throw new IOException("Long(64bit)\u306e\u30b7\u30fc\u30b1\u30f3\u30b9ID\u304c\u67af\u6e07\u3057\u307e\u3057\u305f");
            }
            this.buf.putLong(0, ++ret);
            return ret;
        }

        long getLast() throws Exception {
            return this.buf.getLong(0);
        }

        void setFirst(long first) {
            this.buf.putLong(8, first);
        }

        long getFirst() {
            return this.buf.getLong(8);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BQueueIterator
    implements Iterator<byte[]> {
        private BdbImpl bdb = null;
        private BMqHeader header = null;
        private BdbKeyValue keyValue = null;
        private Lock rsync = null;
        private AtomicBL closeFlag = null;
        private long target = -1L;
        private boolean flg = false;

        BQueueIterator() {
        }

        BQueueIterator(BdbKeyValue keyValue, BdbImpl bdb, BMqHeader header, Lock rsync, AtomicBL closeFlag) throws Exception {
            this.keyValue = keyValue;
            this.bdb = bdb;
            this.header = header;
            this.rsync = rsync;
            this.closeFlag = closeFlag;
        }

        protected void finalize() throws Exception {
            this.close();
        }

        public void close() {
            this.bdb = null;
            this.header = null;
            this.keyValue = null;
            this.rsync = null;
            this.target = -1L;
            this.flg = false;
        }

        @Override
        public boolean hasNext() {
            if (this.flg) {
                return true;
            }
            try {
                long last;
                this.rsync.lock();
                try {
                    last = this.header.getLast();
                }
                finally {
                    this.rsync.unlock();
                }
                if (this.target > last || this.closeFlag.get()) {
                    return false;
                }
                if (this.target <= -1L) {
                    this.rsync.lock();
                    try {
                        this.target = this.header.getFirst();
                    }
                    finally {
                        this.rsync.unlock();
                    }
                }
                boolean getFlag = false;
                do {
                    long s;
                    this.rsync.lock();
                    try {
                        getFlag = this.bdb.get(this.keyValue.create(ConvertParam.convertLong(this.target), null));
                    }
                    finally {
                        this.rsync.unlock();
                    }
                    if (getFlag) {
                        this.flg = true;
                        ++this.target;
                        return true;
                    }
                    this.rsync.lock();
                    try {
                        s = this.header.getFirst();
                    }
                    finally {
                        this.rsync.unlock();
                    }
                    this.target = s > this.target ? s : ++this.target;
                    this.rsync.lock();
                    try {
                        last = this.header.getLast();
                    }
                    finally {
                        this.rsync.unlock();
                    }
                } while (this.target <= last && !this.closeFlag.get());
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public byte[] next() {
            if (this.closeFlag.get()) {
                throw new NoSuchElementException();
            }
            if (this.flg) {
                this.flg = false;
                return this.keyValue.getValue();
            }
            if (this.hasNext()) {
                this.flg = false;
                return this.keyValue.getValue();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

