/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.bdb;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.maachang.bdb.Bdb;
import org.maachang.bdb.BdbKeyValue;
import org.maachang.bdb.BdbManager;
import org.maachang.bdb.ConvertParam;
import org.maachang.bdb.SerializableUtil;

public abstract class AccessBdb {
    public static final int TYPE_BINARY = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_SHORT = 2;
    public static final int TYPE_INT = 3;
    public static final int TYPE_LONG = 4;
    public static final int TYPE_FLOAT = 5;
    public static final int TYPE_DOUBLE = 6;
    public static final int TYPE_DECIMAL = 7;
    public static final int TYPE_OBJECT = 8;
    protected static final Map<Class, Integer> cnvMap;
    protected static final Set<Class> ncnvSet;

    static {
        HashMap<Class, Integer> m = new HashMap<Class, Integer>();
        m.put(Short.class, 2);
        m.put(Integer.class, 3);
        m.put(Long.class, 4);
        m.put(Float.class, 5);
        m.put(Double.class, 6);
        m.put(Short.TYPE, 2);
        m.put(Integer.TYPE, 3);
        m.put(Long.TYPE, 4);
        m.put(Float.TYPE, 5);
        m.put(Double.TYPE, 6);
        cnvMap = m;
        HashSet<Class> n = new HashSet<Class>();
        n.add(Boolean.class);
        n.add(Byte.class);
        n.add(Character.class);
        n.add(Boolean.TYPE);
        n.add(Byte.TYPE);
        n.add(Character.TYPE);
        ncnvSet = n;
    }

    private AccessBdb() {
    }

    public static void put(Bdb bdb, BdbKeyValue kv, byte[] key, Object value) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        if (key == null || key.length <= 0 || value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        bdb.put(kv.create(key, AccessBdb.cbin(value)));
    }

    public static void put(Bdb bdb, BdbKeyValue kv, String key, Object value) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        if (key == null || key.length() <= 0 || value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        bdb.put(kv.create(key.getBytes("UTF8"), AccessBdb.cbin(value)));
    }

    public static void put(Bdb bdb, BdbKeyValue kv, short key, Object value) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        if (value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        bdb.put(kv.create(ConvertParam.convertShort(key), AccessBdb.cbin(value)));
    }

    public static void put(Bdb bdb, BdbKeyValue kv, int key, Object value) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        if (value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        bdb.put(kv.create(ConvertParam.convertInt(key), AccessBdb.cbin(value)));
    }

    public static boolean remove(Bdb bdb, BdbKeyValue kv, byte[] key) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        if (key == null || key.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return bdb.remove(kv.setKey(key));
    }

    public static boolean remove(Bdb bdb, BdbKeyValue kv, String key) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return bdb.remove(kv.setKey(key.getBytes("UTF8")));
    }

    public static boolean remove(Bdb bdb, BdbKeyValue kv, short key) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        return bdb.remove(kv.setKey(ConvertParam.convertShort(key)));
    }

    public static boolean remove(Bdb bdb, BdbKeyValue kv, int key) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        return bdb.remove(kv.setKey(ConvertParam.convertInt(key)));
    }

    public static boolean remove(Bdb bdb, BdbKeyValue kv, long key) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        return bdb.remove(kv.setKey(ConvertParam.convertLong(key)));
    }

    public static Object get(Bdb bdb, BdbKeyValue kv, int type, byte[] key) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        if (key == null || key.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (bdb.get(kv.setKey(key))) {
            return AccessBdb.dbin(type, kv.getValue());
        }
        return null;
    }

    public static Object get(Bdb bdb, BdbKeyValue kv, int type, String key) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (bdb.get(kv.setKey(key.getBytes("UTF8")))) {
            return AccessBdb.dbin(type, kv.getValue());
        }
        return null;
    }

    public static Object get(Bdb bdb, BdbKeyValue kv, int type, short key) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        if (bdb.get(kv.setKey(ConvertParam.convertShort(key)))) {
            return AccessBdb.dbin(type, kv.getValue());
        }
        return null;
    }

    public static Object get(Bdb bdb, BdbKeyValue kv, int type, int key) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        if (bdb.get(kv.setKey(ConvertParam.convertInt(key)))) {
            return AccessBdb.dbin(type, kv.getValue());
        }
        return null;
    }

    public static Object get(Bdb bdb, BdbKeyValue kv, int type, long key) throws Exception {
        if (bdb == null || bdb.isClose()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fBdb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (kv == null) {
            kv = BdbManager.getBdbKeyValue();
        }
        if (bdb.get(kv.setKey(ConvertParam.convertLong(key)))) {
            return AccessBdb.dbin(type, kv.getValue());
        }
        return null;
    }

    private static final byte[] cbin(Object v) throws Exception {
        if (v == null) {
            throw new IllegalArgumentException("\u6307\u5b9a\u5f15\u6570\u306fnull\u3067\u3059");
        }
        if (ncnvSet.contains(v)) {
            throw new IOException("\u6307\u5b9a\u8981\u7d20\u306f\u5909\u63db\u3067\u304d\u306a\u3044\u578b\u5f0f\u3067\u3059:" + v.getClass().getName());
        }
        int type = cnvMap.get(v.getClass());
        switch (type) {
            case 2: {
                return ConvertParam.convertShort((Short)v);
            }
            case 3: {
                return ConvertParam.convertInt((Integer)v);
            }
            case 4: {
                return ConvertParam.convertLong((Long)v);
            }
            case 5: {
                return ConvertParam.convertFloat(((Float)v).floatValue());
            }
            case 6: {
                return ConvertParam.convertDouble((Double)v);
            }
        }
        if (v instanceof byte[]) {
            return (byte[])v;
        }
        if (v instanceof String) {
            return ((String)v).getBytes("UTF8");
        }
        if (v instanceof BigDecimal) {
            return ConvertParam.convertDecimal((BigDecimal)v);
        }
        if (v instanceof Serializable) {
            return SerializableUtil.toBinary((Serializable)v);
        }
        throw new IOException("\u6307\u5b9a\u8981\u7d20\u306f\u5909\u63db\u3067\u304d\u306a\u3044\u578b\u5f0f\u3067\u3059:" + v.getClass().getName());
    }

    private static final Object dbin(int type, byte[] v) throws Exception {
        if (v == null || v.length <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u5f15\u6570\u306fnull\u3067\u3059");
        }
        switch (type) {
            case 0: {
                return v;
            }
            case 1: {
                return new String(v, "UTF8");
            }
            case 2: {
                return ConvertParam.convertShort(0, v);
            }
            case 3: {
                return ConvertParam.convertInt(0, v);
            }
            case 4: {
                return ConvertParam.convertLong(0, v);
            }
            case 5: {
                return Float.valueOf(ConvertParam.convertFloat(0, v));
            }
            case 6: {
                return ConvertParam.convertDouble(0, v);
            }
            case 7: {
                return ConvertParam.convertDecimal(0, v);
            }
            case 8: {
                return SerializableUtil.toObject(v);
            }
        }
        return v;
    }
}

