/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DumpFileReader;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.PrintFileReader;
import com.sleepycat.je.log.StatsFileReader;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;

public class DbPrintLog {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(File envHome, String entryTypes, String txnIds, long startLsn, long endLsn, boolean verbose, boolean stats, boolean repEntriesOnly, boolean csvFormat) throws EnvironmentNotFoundException, EnvironmentLockedException {
        EnvironmentImpl env = CmdUtil.makeUtilityEnvironment(envHome, true);
        FileManager fileManager = env.getFileManager();
        fileManager.setIncludeDeletedFiles(true);
        int readBufferSize = env.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        try {
            DumpFileReader reader = stats ? new StatsFileReader(env, readBufferSize, startLsn, endLsn, entryTypes, txnIds, verbose, repEntriesOnly) : new PrintFileReader(env, readBufferSize, startLsn, endLsn, entryTypes, txnIds, verbose, repEntriesOnly);
            if (!csvFormat) {
                System.out.println("<DbPrintLog>");
            }
            while (reader.readNextEntry()) {
            }
            reader.summarize(csvFormat);
            if (!csvFormat) {
                System.out.println("</DbPrintLog>");
            }
            Object var17_14 = null;
        }
        catch (Throwable throwable) {
            Object var17_15 = null;
            env.close();
            throw throwable;
        }
        env.close();
    }

    public static void main(String[] argv) {
        try {
            String entryTypes = null;
            String txnIds = null;
            long startLsn = -1L;
            long endLsn = -1L;
            boolean verbose = true;
            boolean stats = false;
            boolean csvFormat = false;
            boolean repEntriesOnly = false;
            File envHome = new File(".");
            Key.DUMP_TYPE = Key.DumpType.BINARY;
            for (int whichArg = 0; whichArg < argv.length; ++whichArg) {
                String nextArg = argv[whichArg];
                if (nextArg.equals("-h")) {
                    envHome = new File(CmdUtil.getArg(argv, ++whichArg));
                    continue;
                }
                if (nextArg.equals("-ty")) {
                    entryTypes = CmdUtil.getArg(argv, ++whichArg);
                    continue;
                }
                if (nextArg.equals("-tx")) {
                    txnIds = CmdUtil.getArg(argv, ++whichArg);
                    continue;
                }
                if (nextArg.equals("-s")) {
                    startLsn = CmdUtil.readLsn(CmdUtil.getArg(argv, ++whichArg));
                    continue;
                }
                if (nextArg.equals("-e")) {
                    endLsn = CmdUtil.readLsn(CmdUtil.getArg(argv, ++whichArg));
                    continue;
                }
                if (nextArg.equals("-k")) {
                    String dumpType;
                    if ((dumpType = CmdUtil.getArg(argv, ++whichArg)).equalsIgnoreCase("text")) {
                        Key.DUMP_TYPE = Key.DumpType.TEXT;
                        continue;
                    }
                    if (dumpType.equalsIgnoreCase("hex")) {
                        Key.DUMP_TYPE = Key.DumpType.HEX;
                        continue;
                    }
                    if (dumpType.equalsIgnoreCase("binary")) {
                        Key.DUMP_TYPE = Key.DumpType.BINARY;
                        continue;
                    }
                    if (dumpType.equalsIgnoreCase("obfuscate")) {
                        Key.DUMP_TYPE = Key.DumpType.OBFUSCATE;
                        continue;
                    }
                    System.err.println(dumpType + " is not a supported dump format type.");
                    continue;
                }
                if (nextArg.equals("-q")) {
                    verbose = false;
                    continue;
                }
                if (nextArg.equals("-S")) {
                    stats = true;
                    continue;
                }
                if (nextArg.equals("-SC")) {
                    stats = true;
                    csvFormat = true;
                    continue;
                }
                if (nextArg.equals("-r")) {
                    repEntriesOnly = true;
                    continue;
                }
                System.err.println(nextArg + " is not a supported option.");
                DbPrintLog.usage();
                System.exit(-1);
            }
            DbPrintLog printer = new DbPrintLog();
            printer.dump(envHome, entryTypes, txnIds, startLsn, endLsn, verbose, stats, repEntriesOnly, csvFormat);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            DbPrintLog.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("Usage: " + CmdUtil.getJavaCommand(DbPrintLog.class));
        System.out.println(" -h  <envHomeDir>");
        System.out.println(" -s  <start file number or LSN, in hex>");
        System.out.println(" -e  <end file number or LSN, in hex>");
        System.out.println(" -k  <binary|text|hex|obfuscate> (format for dumping the key)");
        System.out.println(" -tx <targeted txn ids, comma separated>");
        System.out.println(" -ty <targeted entry types, comma separated>");
        System.out.println(" -S  show Summary of log entries");
        System.out.println(" -SC show Summary of log entries in CSV format");
        System.out.println(" -r  only print replicated log entries");
        System.out.println(" -q  if specified, concise version is printed");
        System.out.println("     Default is verbose version.)");
        System.out.println("All arguments are optional");
    }
}

