/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.SimpleFormat;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCatalog
implements Catalog {
    private static final Map<String, Class> keywordToPrimitive = new HashMap<String, Class>(8);
    private static final Map<Class, Class> primitiveTypeToWrapper;
    private static final SimpleCatalog instance;
    private List<SimpleFormat> formatList;
    private Map<String, SimpleFormat> formatMap;

    static SimpleCatalog getInstance() {
        return instance;
    }

    static boolean isSimpleType(Class type) {
        return SimpleCatalog.instance.formatMap.containsKey(type.getName());
    }

    static Class primitiveToWrapper(Class type) {
        Class cls = primitiveTypeToWrapper.get(type);
        if (cls == null) {
            throw DbCompat.unexpectedState(type.getName());
        }
        return cls;
    }

    public static Class keyClassForName(String className) {
        Class cls = keywordToPrimitive.get(className);
        if (cls != null) {
            cls = primitiveTypeToWrapper.get(cls);
        } else {
            try {
                cls = EntityModel.classForName(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Key class not found: " + className);
            }
        }
        return cls;
    }

    public static String keyClassName(String className) {
        Class cls = keywordToPrimitive.get(className);
        if (cls != null) {
            cls = primitiveTypeToWrapper.get(cls);
            return cls.getName();
        }
        return className;
    }

    public static Class classForName(String className) throws ClassNotFoundException {
        Class cls = keywordToPrimitive.get(className);
        if (cls == null) {
            cls = EntityModel.classForName(className);
        }
        return cls;
    }

    static SimpleFormat getSimpleFormat(Class type) {
        return SimpleCatalog.instance.formatMap.get(type.getName());
    }

    static List<Format> copyFormatList() {
        return new ArrayList<Format>(SimpleCatalog.instance.formatList);
    }

    static boolean copyMissingFormats(List<Format> copyToList) {
        boolean anyCopied = false;
        for (int i = 0; i <= 30; ++i) {
            Format thisFormat = SimpleCatalog.instance.formatList.get(i);
            Format otherFormat = copyToList.get(i);
            if (thisFormat == null || otherFormat != null) continue;
            copyToList.set(i, thisFormat);
            anyCopied = true;
        }
        return anyCopied;
    }

    private SimpleCatalog() {
        int initCapacity = 60;
        this.formatList = new ArrayList<SimpleFormat>(initCapacity);
        this.formatMap = new HashMap<String, SimpleFormat>(initCapacity);
        for (int i = 0; i <= 30; ++i) {
            this.formatList.add(null);
        }
        this.setFormat(2, new SimpleFormat.FBool(true));
        this.setFormat(3, new SimpleFormat.FBool(false));
        this.setFormat(4, new SimpleFormat.FByte(true));
        this.setFormat(5, new SimpleFormat.FByte(false));
        this.setFormat(6, new SimpleFormat.FShort(true));
        this.setFormat(7, new SimpleFormat.FShort(false));
        this.setFormat(8, new SimpleFormat.FInt(true));
        this.setFormat(9, new SimpleFormat.FInt(false));
        this.setFormat(10, new SimpleFormat.FLong(true));
        this.setFormat(11, new SimpleFormat.FLong(false));
        this.setFormat(12, new SimpleFormat.FFloat(true));
        this.setFormat(13, new SimpleFormat.FFloat(false));
        this.setFormat(14, new SimpleFormat.FDouble(true));
        this.setFormat(15, new SimpleFormat.FDouble(false));
        this.setFormat(16, new SimpleFormat.FChar(true));
        this.setFormat(17, new SimpleFormat.FChar(false));
        this.setFormat(18, new SimpleFormat.FString());
        this.setFormat(19, new SimpleFormat.FBigInt());
        this.setFormat(21, new SimpleFormat.FDate());
        this.setWrapper(2, 3);
        this.setWrapper(4, 5);
        this.setWrapper(6, 7);
        this.setWrapper(8, 9);
        this.setWrapper(10, 11);
        this.setWrapper(12, 13);
        this.setWrapper(14, 15);
        this.setWrapper(16, 17);
    }

    private void setFormat(int id, SimpleFormat format) {
        format.setId(id);
        format.initializeIfNeeded(this, null);
        this.formatList.set(id, format);
        this.formatMap.put(format.getClassName(), format);
    }

    private void setWrapper(int primitiveId, int wrapperId) {
        SimpleFormat primitiveFormat = this.formatList.get(primitiveId);
        SimpleFormat wrapperFormat = this.formatList.get(wrapperId);
        primitiveFormat.setWrapperFormat(wrapperFormat);
    }

    @Override
    public int getInitVersion(Format format, boolean forReader) {
        return 1;
    }

    @Override
    public Format getFormat(int formatId) {
        try {
            Format format = this.formatList.get(formatId);
            if (format == null) {
                throw DbCompat.unexpectedState("Not a simple type: " + formatId);
            }
            return format;
        }
        catch (NoSuchElementException e) {
            throw DbCompat.unexpectedState("Not a simple type: " + formatId);
        }
    }

    @Override
    public Format getFormat(Class cls, boolean checkEntitySubclassIndexes) {
        Format format = this.formatMap.get(cls.getName());
        if (format == null) {
            throw new IllegalArgumentException("Not a simple type: " + cls.getName());
        }
        return format;
    }

    @Override
    public Format getFormat(String className) {
        return this.formatMap.get(className);
    }

    @Override
    public Format createFormat(String clsName, Map<String, Format> newFormats) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public Format createFormat(Class type, Map<String, Format> newFormats) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public boolean isRawAccess() {
        return false;
    }

    @Override
    public Object convertRawObject(RawObject o, IdentityHashMap converted) {
        throw DbCompat.unexpectedState();
    }

    static {
        keywordToPrimitive.put("boolean", Boolean.TYPE);
        keywordToPrimitive.put("char", Character.TYPE);
        keywordToPrimitive.put("byte", Byte.TYPE);
        keywordToPrimitive.put("short", Short.TYPE);
        keywordToPrimitive.put("int", Integer.TYPE);
        keywordToPrimitive.put("long", Long.TYPE);
        keywordToPrimitive.put("float", Float.TYPE);
        keywordToPrimitive.put("double", Double.TYPE);
        primitiveTypeToWrapper = new HashMap<Class, Class>(8);
        primitiveTypeToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveTypeToWrapper.put(Character.TYPE, Character.class);
        primitiveTypeToWrapper.put(Byte.TYPE, Byte.class);
        primitiveTypeToWrapper.put(Short.TYPE, Short.class);
        primitiveTypeToWrapper.put(Integer.TYPE, Integer.class);
        primitiveTypeToWrapper.put(Long.TYPE, Long.class);
        primitiveTypeToWrapper.put(Float.TYPE, Float.class);
        primitiveTypeToWrapper.put(Double.TYPE, Double.class);
        instance = new SimpleCatalog();
    }
}

