/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.Trace;
import com.sleepycat.je.util.ConsoleHandler;
import com.sleepycat.je.utilint.ConsoleRedirectHandler;
import com.sleepycat.je.utilint.FileRedirectHandler;
import com.sleepycat.je.utilint.FormatterRedirectHandler;
import com.sleepycat.je.utilint.MemoryRedirectHandler;
import com.sleepycat.je.utilint.TracerFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerUtils {
    static Map<Thread, EnvironmentImpl> envMap = new ConcurrentHashMap<Thread, EnvironmentImpl>();
    static Map<Thread, Formatter> formatterMap = new ConcurrentHashMap<Thread, Formatter>();
    public static final String NO_ENV = ".noEnv";
    public static final String FIXED_PREFIX = ".fixedPrefix";
    private static final String LOGGABLE_LEVEL = ".loggable.level";
    private static final String PUSH_LEVEL = ".push.level";

    public static Logger getLogger(Class<?> cl) {
        Logger logger = LoggerUtils.createLogger(cl.getName());
        boolean hasConsoleHandler = false;
        boolean hasMemoryHandler = false;
        boolean hasFileHandler = false;
        for (Handler h : logger.getHandlers()) {
            if (h instanceof java.util.logging.ConsoleHandler) {
                hasConsoleHandler = true;
            }
            if (h instanceof MemoryRedirectHandler) {
                hasMemoryHandler = true;
            }
            if (!(h instanceof FileRedirectHandler)) continue;
            hasFileHandler = true;
        }
        if (!hasConsoleHandler) {
            logger.addHandler(new ConsoleRedirectHandler());
        }
        if (!hasMemoryHandler) {
            logger.addHandler(new MemoryRedirectHandler());
        }
        if (!hasFileHandler) {
            logger.addHandler(new FileRedirectHandler());
        }
        return logger;
    }

    public static Logger getLoggerFormatterNeeded(Class<?> cl) {
        Logger logger = LoggerUtils.createLogger(cl.getName() + NO_ENV);
        boolean hasConsoleHandler = false;
        for (Handler h : logger.getHandlers()) {
            if (!(h instanceof java.util.logging.ConsoleHandler)) continue;
            hasConsoleHandler = true;
        }
        if (!hasConsoleHandler) {
            logger.addHandler(new FormatterRedirectHandler());
        }
        return logger;
    }

    public static Logger getLoggerFixedPrefix(Class<?> cl, String prefix) {
        Logger logger = LoggerUtils.createLogger(cl.getName() + FIXED_PREFIX);
        boolean hasConsoleHandler = false;
        for (Handler h : logger.getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            hasConsoleHandler = true;
        }
        if (!hasConsoleHandler) {
            logger.addHandler(new ConsoleHandler(new TracerFormatter(prefix)));
        }
        return logger;
    }

    private static Logger createLogger(String className) {
        Logger logger = Logger.getLogger(className);
        logger.setUseParentHandlers(false);
        return logger;
    }

    public static String getLoggerProperty(String property) {
        LogManager mgr = LogManager.getLogManager();
        return mgr.getProperty(property);
    }

    public static Level getPushLevel(String name) {
        String propertyValue = LoggerUtils.getLoggerProperty(name + PUSH_LEVEL);
        Level level = Level.OFF;
        if (propertyValue != null) {
            level = Level.parse(propertyValue);
        }
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logMsg(Logger useLogger, EnvironmentImpl envImpl, Level logLevel, String msg) {
        if (envImpl != null) {
            envMap.put(Thread.currentThread(), envImpl);
        }
        try {
            useLogger.log(logLevel, msg);
            Object var5_4 = null;
            envMap.remove(Thread.currentThread());
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            envMap.remove(Thread.currentThread());
            throw throwable;
        }
    }

    public static void envLogMsg(Level logLevel, EnvironmentImpl envImpl, String msg) {
        LoggerUtils.logMsg(envImpl.getLogger(), envImpl, logLevel, msg);
    }

    public static void logMsg(Logger useLogger, EnvironmentImpl envImpl, Formatter formatter, Level logLevel, String msg) {
        if (envImpl != null) {
            LoggerUtils.logMsg(useLogger, envImpl, logLevel, msg);
        } else {
            LoggerUtils.logMsg(useLogger, formatter, logLevel, msg);
        }
    }

    public static void severe(Logger useLogger, EnvironmentImpl envImpl, String msg) {
        LoggerUtils.logMsg(useLogger, envImpl, Level.SEVERE, msg);
    }

    public static void warning(Logger useLogger, EnvironmentImpl envImpl, String msg) {
        LoggerUtils.logMsg(useLogger, envImpl, Level.WARNING, msg);
    }

    public static void info(Logger useLogger, EnvironmentImpl envImpl, String msg) {
        LoggerUtils.logMsg(useLogger, envImpl, Level.INFO, msg);
    }

    public static void fine(Logger useLogger, EnvironmentImpl envImpl, String msg) {
        LoggerUtils.logMsg(useLogger, envImpl, Level.FINE, msg);
    }

    public static void finest(Logger useLogger, EnvironmentImpl envImpl, String msg) {
        LoggerUtils.logMsg(useLogger, envImpl, Level.FINEST, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logMsg(Logger useLogger, Formatter formatter, Level logLevel, String msg) {
        if (formatter != null) {
            formatterMap.put(Thread.currentThread(), formatter);
        }
        try {
            useLogger.log(logLevel, msg);
            Object var5_4 = null;
            formatterMap.remove(Thread.currentThread());
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            formatterMap.remove(Thread.currentThread());
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceAndLogException(EnvironmentImpl envImpl, String sourceClass, String sourceMethod, String msg, Throwable t) {
        String traceMsg = msg + "\n" + LoggerUtils.getStackTrace(t);
        envMap.put(Thread.currentThread(), envImpl);
        try {
            envImpl.getLogger().logp(Level.SEVERE, sourceClass, sourceMethod, traceMsg);
            Object var7_6 = null;
            envMap.remove(Thread.currentThread());
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            envMap.remove(Thread.currentThread());
            throw throwable;
        }
        Trace.trace(envImpl, traceMsg);
    }

    public static void traceAndLog(Logger logger, EnvironmentImpl envImpl, Level logLevel, String msg) {
        LoggerUtils.logMsg(logger, envImpl, logLevel, msg);
        Trace.trace(envImpl, msg);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.toString();
        stackTrace = stackTrace.replaceAll("&lt", "<");
        stackTrace = stackTrace.replaceAll("&gt", ">");
        return stackTrace;
    }

    public static String getStackTrace() {
        Exception e = new Exception();
        return LoggerUtils.getStackTrace(e);
    }
}

