/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import java.util.Iterator;

public class ThreadLocker
extends BasicLocker {
    public ThreadLocker(EnvironmentImpl env) {
        super(env);
        this.lockManager.registerThreadLocker(this);
    }

    public static ThreadLocker createThreadLocker(EnvironmentImpl env) throws DatabaseException {
        BasicLocker ret = null;
        try {
            ret = env.isReplicated() ? env.createRepThreadLocker() : new ThreadLocker(env);
        }
        catch (DatabaseException DE) {
            ret.operationEnd(false);
            throw DE;
        }
        return ret;
    }

    void close() {
        super.close();
        this.lockManager.unregisterThreadLocker(this);
    }

    void checkPreempted(Locker allowPreemptedLocker) throws OperationFailureException {
        Iterator<ThreadLocker> iter = this.lockManager.getThreadLockers(this.thread);
        while (iter.hasNext()) {
            ThreadLocker locker = iter.next();
            locker.throwIfPreempted(allowPreemptedLocker);
        }
    }

    protected void checkState(boolean ignoreCalledByAbort) {
        if (this.thread != Thread.currentThread()) {
            throw new IllegalStateException("Non-transactional Cursors may not be used in multiple threads; Cursor was created in " + this.thread + " but used in " + Thread.currentThread());
        }
    }

    public Locker newNonTxnLocker() throws DatabaseException {
        this.checkState(false);
        return ThreadLocker.createThreadLocker(this.envImpl);
    }

    public boolean sharesLocksWith(Locker other) {
        if (super.sharesLocksWith(other)) {
            return true;
        }
        if (other instanceof ThreadLocker) {
            return this.thread == ((ThreadLocker)other).thread;
        }
        return false;
    }
}

