/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.networkRestore;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.networkRestore.FeederManager;
import com.sleepycat.je.rep.impl.networkRestore.Protocol;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.util.DbBackup;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.logging.Logger;

public class LogFileFeeder
extends StoppableThread {
    private static final int SOCKET_TIMEOUT_MS = 300000;
    static final int TRANSFER_BYTES = 8192;
    private final FeederManager feederManager;
    private final SocketChannel channel;
    private int clientId;
    private DbBackup dbBackup = null;
    final MessageDigest messageDigest;
    private final Logger logger;

    public LogFileFeeder(FeederManager feederManager, SocketChannel channel) throws DatabaseException {
        super(feederManager.getEnvImpl());
        this.feederManager = feederManager;
        this.logger = feederManager.logger;
        this.channel = channel;
        try {
            this.messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            LoggerUtils.severe(this.logger, feederManager.getEnvImpl(), "The SHA1 algorithm was not made available by the security provider");
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    public void shutdown() {
        if (this.shutdownDone()) {
            return;
        }
        if (Thread.currentThread() != this) {
            this.interrupt();
        }
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LoggerUtils.info(this.logger, this.feederManager.getEnvImpl(), "Log file feeder for client:" + this.clientId + " is shutdown.");
        this.feederManager.feeders.remove(this.clientId);
    }

    /*
     * Loose catch block
     */
    public void run() {
        block29: {
            Protocol protocol = new Protocol(this.feederManager.nameIdPair, 2, this.feederManager.getEnvImpl());
            this.configureChannel();
            protocol = this.checkProtocol(protocol);
            this.checkFeeder(protocol);
            this.sendFileList(protocol);
            this.sendRequestedFiles(protocol);
            this.dbBackup.endBackup();
            this.dbBackup = null;
            Object var4_2 = null;
            try {
                this.channel.close();
            }
            catch (IOException e2) {
                LoggerUtils.warning(this.logger, this.feederManager.getEnvImpl(), "Log File feeder io exception on channel close: " + e2.getMessage());
            }
            this.shutdown();
            if (this.dbBackup != null) {
                if (this.feederManager.shutdown.get()) {
                    this.dbBackup.endBackup();
                } else {
                    FeederManager feederManager = this.feederManager;
                    feederManager.getClass();
                    feederManager.new FeederManager.Lease(this.clientId, this.feederManager.leaseDuration, this.dbBackup);
                    LoggerUtils.info(this.logger, this.feederManager.getEnvImpl(), "Lease created for node: " + this.clientId);
                }
            }
            LoggerUtils.info(this.logger, this.feederManager.getEnvImpl(), "Log file feeder for client: " + this.clientId + " exited");
            {
                break block29;
                catch (ClosedByInterruptException e) {
                    LoggerUtils.fine(this.logger, this.feederManager.getEnvImpl(), "Ignoring ClosedByInterruptException normal shutdown");
                    Object var4_3 = null;
                    try {
                        this.channel.close();
                    }
                    catch (IOException e2) {
                        LoggerUtils.warning(this.logger, this.feederManager.getEnvImpl(), "Log File feeder io exception on channel close: " + e2.getMessage());
                    }
                    this.shutdown();
                    if (this.dbBackup != null) {
                        if (this.feederManager.shutdown.get()) {
                            this.dbBackup.endBackup();
                        } else {
                            FeederManager feederManager = this.feederManager;
                            feederManager.getClass();
                            feederManager.new FeederManager.Lease(this.clientId, this.feederManager.leaseDuration, this.dbBackup);
                            LoggerUtils.info(this.logger, this.feederManager.getEnvImpl(), "Lease created for node: " + this.clientId);
                        }
                    }
                    LoggerUtils.info(this.logger, this.feederManager.getEnvImpl(), "Log file feeder for client: " + this.clientId + " exited");
                    break block29;
                }
                catch (IOException e) {
                    LoggerUtils.warning(this.logger, this.feederManager.getEnvImpl(), " IO Exception: " + e.getMessage());
                    Object var4_4 = null;
                    try {
                        this.channel.close();
                    }
                    catch (IOException e2) {
                        LoggerUtils.warning(this.logger, this.feederManager.getEnvImpl(), "Log File feeder io exception on channel close: " + e2.getMessage());
                    }
                    this.shutdown();
                    if (this.dbBackup != null) {
                        if (this.feederManager.shutdown.get()) {
                            this.dbBackup.endBackup();
                        } else {
                            FeederManager feederManager = this.feederManager;
                            feederManager.getClass();
                            feederManager.new FeederManager.Lease(this.clientId, this.feederManager.leaseDuration, this.dbBackup);
                            LoggerUtils.info(this.logger, this.feederManager.getEnvImpl(), "Lease created for node: " + this.clientId);
                        }
                    }
                    LoggerUtils.info(this.logger, this.feederManager.getEnvImpl(), "Log file feeder for client: " + this.clientId + " exited");
                    break block29;
                }
                catch (BinaryProtocol.ProtocolException e) {
                    LoggerUtils.severe(this.logger, this.feederManager.getEnvImpl(), " Protocol Exception: " + e.getMessage());
                    Object var4_5 = null;
                    try {
                        this.channel.close();
                    }
                    catch (IOException e2) {
                        LoggerUtils.warning(this.logger, this.feederManager.getEnvImpl(), "Log File feeder io exception on channel close: " + e2.getMessage());
                    }
                    this.shutdown();
                    if (this.dbBackup != null) {
                        if (this.feederManager.shutdown.get()) {
                            this.dbBackup.endBackup();
                        } else {
                            FeederManager feederManager = this.feederManager;
                            feederManager.getClass();
                            feederManager.new FeederManager.Lease(this.clientId, this.feederManager.leaseDuration, this.dbBackup);
                            LoggerUtils.info(this.logger, this.feederManager.getEnvImpl(), "Lease created for node: " + this.clientId);
                        }
                    }
                    LoggerUtils.info(this.logger, this.feederManager.getEnvImpl(), "Log file feeder for client: " + this.clientId + " exited");
                    break block29;
                }
                catch (Exception e) {
                    throw new EnvironmentFailureException(this.feederManager.getEnvImpl(), EnvironmentFailureReason.UNCAUGHT_EXCEPTION, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    this.channel.close();
                }
                catch (IOException e2) {
                    LoggerUtils.warning(this.logger, this.feederManager.getEnvImpl(), "Log File feeder io exception on channel close: " + e2.getMessage());
                }
                this.shutdown();
                if (this.dbBackup != null) {
                    if (this.feederManager.shutdown.get()) {
                        this.dbBackup.endBackup();
                    } else {
                        FeederManager feederManager = this.feederManager;
                        feederManager.getClass();
                        feederManager.new FeederManager.Lease(this.clientId, this.feederManager.leaseDuration, this.dbBackup);
                        LoggerUtils.info(this.logger, this.feederManager.getEnvImpl(), "Lease created for node: " + this.clientId);
                    }
                }
                LoggerUtils.info(this.logger, this.feederManager.getEnvImpl(), "Log file feeder for client: " + this.clientId + " exited");
                throw throwable;
            }
        }
    }

    private void checkFeeder(Protocol protocol) throws IOException, DatabaseException {
        protocol.read(this.channel, Protocol.FeederInfoReq.class);
        int feeders = this.feederManager.getActiveFeederCount() - 1;
        VLSN rangeFirst = VLSN.NULL_VLSN;
        VLSN rangeLast = VLSN.NULL_VLSN;
        if (this.feederManager.getEnvImpl() instanceof RepImpl) {
            RepImpl repImpl = (RepImpl)this.feederManager.getEnvImpl();
            feeders += repImpl.getRepNode().feederManager().activeReplicaCount();
            VLSNRange range = repImpl.getVLSNIndex().getRange();
            rangeFirst = range.getFirst();
            rangeLast = range.getLast();
        }
        Protocol protocol2 = protocol;
        protocol2.getClass();
        protocol.write((BinaryProtocol.Message)new Protocol.FeederInfoResp(protocol2, feeders, rangeFirst, rangeLast), this.channel);
    }

    private void sendRequestedFiles(Protocol protocol) throws IOException, BinaryProtocol.ProtocolException, DatabaseException {
        File envDir = this.feederManager.getEnvImpl().getEnvironmentHome();
        try {
            while (true) {
                byte[] cachedDigest;
                Protocol.FileReq fileReq;
                String fileName;
                File file;
                if (!(file = new File(envDir, fileName = (fileReq = protocol.read(this.channel, Protocol.FileReq.class)).getFileName())).exists()) {
                    throw EnvironmentFailureException.unexpectedState("Log file not found: " + fileName);
                }
                long length = file.length();
                long lastModified = file.lastModified();
                byte[] digest = null;
                Protocol.FileInfoResp resp = null;
                Protocol.FileInfoResp cachedResp = this.feederManager.statResponses.get(fileName);
                byte[] byArray = cachedDigest = cachedResp != null && cachedResp.getFileLength() == length && cachedResp.getLastModifiedTime() == lastModified ? cachedResp.getDigestSHA1() : null;
                if (fileReq instanceof Protocol.FileInfoReq) {
                    digest = cachedDigest != null ? cachedDigest : (((Protocol.FileInfoReq)fileReq).getNeedSHA1() ? LogFileFeeder.getSHA1Digest(file, length).digest() : new byte[]{});
                    Protocol protocol2 = protocol;
                    protocol2.getClass();
                    resp = new Protocol.FileInfoResp(protocol2, fileName, length, lastModified, digest);
                } else {
                    Protocol protocol3 = protocol;
                    protocol3.getClass();
                    protocol.write((BinaryProtocol.Message)new Protocol.FileStart(protocol3, fileName, length, lastModified), this.channel);
                    digest = this.sendFileContents(file, length);
                    if (cachedDigest != null && !Arrays.equals(cachedDigest, digest)) {
                        throw EnvironmentFailureException.unexpectedState("Inconsistent cached and computed digests");
                    }
                    Protocol protocol4 = protocol;
                    protocol4.getClass();
                    resp = new Protocol.FileEnd(protocol4, fileName, length, lastModified, digest);
                }
                if (digest.length > 0) {
                    this.feederManager.statResponses.put(fileName, resp);
                }
                protocol.write((BinaryProtocol.Message)resp, this.channel);
            }
        }
        catch (BinaryProtocol.ProtocolException pe) {
            if (pe.getUnexpectedMessage() instanceof Protocol.Done) {
                return;
            }
            throw pe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MessageDigest getSHA1Digest(File file, long length) throws IOException, DatabaseException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        FileInputStream fileStream = new FileInputStream(file);
        try {
            int readBytes;
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            for (long bytes = length; bytes > 0L; bytes -= (long)readBytes) {
                int readSize = (int)Math.min(8192L, bytes);
                readBytes = fileStream.read(buffer.array(), 0, readSize);
                if (readBytes == -1) {
                    throw new IOException("Premature EOF. Was expecting: " + readSize);
                }
                messageDigest.update(buffer.array(), 0, readBytes);
            }
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            fileStream.close();
            throw throwable;
        }
        fileStream.close();
        return messageDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] sendFileContents(File file, long length) throws IOException {
        FileInputStream fileStream = new FileInputStream(file);
        this.messageDigest.reset();
        try {
            int readBytes;
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            for (long bytes = length; bytes > 0L; bytes -= (long)readBytes) {
                int readSize = (int)Math.min(8192L, bytes);
                readBytes = fileStream.read(buffer.array(), 0, readSize);
                if (readBytes == -1) {
                    throw new IOException("Premature EOF. Was expecting: " + readSize);
                }
                buffer.position(0);
                buffer.limit(readBytes);
                buffer.mark();
                this.channel.write(buffer);
                buffer.reset();
                this.messageDigest.update(buffer);
            }
            LoggerUtils.fine(this.logger, this.feederManager.getEnvImpl(), "Sent file: " + file + " Length: " + length + " bytes");
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            fileStream.close();
            throw throwable;
        }
        fileStream.close();
        return this.messageDigest.digest();
    }

    private void sendFileList(Protocol protocol) throws IOException, BinaryProtocol.ProtocolException, DatabaseException {
        protocol.read(this.channel, Protocol.FileListReq.class);
        if (this.dbBackup == null) {
            this.dbBackup = new DbBackup(this.feederManager.getEnvImpl());
            this.dbBackup.startBackup();
        } else {
            ++this.feederManager.leaseRenewalCount;
        }
        String[] files = this.dbBackup.getLogFilesInBackupSet();
        Protocol protocol2 = protocol;
        protocol2.getClass();
        protocol.write((BinaryProtocol.Message)new Protocol.FileListResp(protocol2, files), this.channel);
    }

    private Protocol checkProtocol(Protocol protocol) throws IOException, BinaryProtocol.ProtocolException {
        BinaryProtocol.ClientVersion clientVersion = protocol.read(this.channel, BinaryProtocol.ClientVersion.class);
        this.clientId = clientVersion.getNodeId();
        FeederManager.Lease lease = this.feederManager.leases.get(this.clientId);
        if (lease != null) {
            this.dbBackup = lease.terminate();
        }
        this.feederManager.feeders.put(this.clientId, this);
        if (clientVersion.getVersion() != protocol.getVersion()) {
            String message = "Client requested protocol version: " + clientVersion.getVersion() + " but the server version is " + protocol.getVersion();
            LoggerUtils.warning(this.logger, this.feederManager.getEnvImpl(), message);
        }
        protocol.write((BinaryProtocol.Message)new BinaryProtocol.ServerVersion(protocol), this.channel);
        return protocol;
    }

    private SocketChannel configureChannel() throws IOException {
        this.channel.configureBlocking(true);
        LoggerUtils.fine(this.logger, this.feederManager.getEnvImpl(), "Log File Feeder accepted connection from " + this.channel);
        this.channel.socket().setSoTimeout(300000);
        this.channel.socket().setTcpNoDelay(false);
        return this.channel;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

